/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.registry;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.google.cloud.tools.jib.blob.Blobs;
import com.google.cloud.tools.jib.configuration.credentials.Credential;
import com.google.cloud.tools.jib.event.EventDispatcher;
import com.google.cloud.tools.jib.global.JibSystemProperties;
import com.google.cloud.tools.jib.http.Authorization;
import com.google.cloud.tools.jib.http.Authorizations;
import com.google.cloud.tools.jib.http.BlobHttpContent;
import com.google.cloud.tools.jib.http.Connection;
import com.google.cloud.tools.jib.http.Request;
import com.google.cloud.tools.jib.http.Response;
import com.google.cloud.tools.jib.json.JsonTemplate;
import com.google.cloud.tools.jib.json.JsonTemplateMapper;
import com.google.cloud.tools.jib.registry.InsecureRegistryException;
import com.google.cloud.tools.jib.registry.RegistryAuthenticationFailedException;
import com.google.cloud.tools.jib.registry.RegistryClient;
import com.google.cloud.tools.jib.registry.RegistryEndpointRequestProperties;
import com.google.cloud.tools.jib.registry.RegistryException;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Verify;
import com.google.common.net.MediaType;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public class RegistryAuthenticator {
    private final RegistryEndpointRequestProperties registryEndpointRequestProperties;
    private final String realm;
    private final String service;
    @Nullable
    private Credential credential;
    private final String userAgent;

    public RegistryAuthenticator setCredential(@Nullable Credential credential) {
        this.credential = credential;
        return this;
    }

    public static Initializer initializer(EventDispatcher eventDispatcher, String serverUrl, String repository) {
        return new Initializer(eventDispatcher, serverUrl, repository);
    }

    @Nullable
    static RegistryAuthenticator fromAuthenticationMethod(String authenticationMethod, RegistryEndpointRequestProperties registryEndpointRequestProperties, String userAgent) throws RegistryAuthenticationFailedException {
        if (authenticationMethod.matches("^(?i)(basic) .*")) {
            return null;
        }
        if (!authenticationMethod.matches("^(?i)(bearer) .*")) {
            throw RegistryAuthenticator.newRegistryAuthenticationFailedException(registryEndpointRequestProperties.getServerUrl(), registryEndpointRequestProperties.getImageName(), authenticationMethod, "Bearer");
        }
        Pattern realmPattern = Pattern.compile("realm=\"(.*?)\"");
        Matcher realmMatcher = realmPattern.matcher(authenticationMethod);
        if (!realmMatcher.find()) {
            throw RegistryAuthenticator.newRegistryAuthenticationFailedException(registryEndpointRequestProperties.getServerUrl(), registryEndpointRequestProperties.getImageName(), authenticationMethod, "realm");
        }
        String realm = realmMatcher.group(1);
        Pattern servicePattern = Pattern.compile("service=\"(.*?)\"");
        Matcher serviceMatcher = servicePattern.matcher(authenticationMethod);
        String service = serviceMatcher.find() ? serviceMatcher.group(1) : registryEndpointRequestProperties.getServerUrl();
        return new RegistryAuthenticator(realm, service, registryEndpointRequestProperties, userAgent);
    }

    private static RegistryAuthenticationFailedException newRegistryAuthenticationFailedException(String registry, String repository, String authenticationMethod, String authParam) {
        return new RegistryAuthenticationFailedException(registry, repository, "'" + authParam + "' was not found in the 'WWW-Authenticate' header, tried to parse: " + authenticationMethod);
    }

    RegistryAuthenticator(String realm, String service, RegistryEndpointRequestProperties registryEndpointRequestProperties, String userAgent) {
        this.realm = realm;
        this.service = service;
        this.registryEndpointRequestProperties = registryEndpointRequestProperties;
        this.userAgent = userAgent;
    }

    public Authorization authenticatePull() throws RegistryAuthenticationFailedException {
        return this.authenticate("pull");
    }

    public Authorization authenticatePush() throws RegistryAuthenticationFailedException {
        return this.authenticate("pull,push");
    }

    @VisibleForTesting
    String getServiceScopeRequestParameters(String scope) {
        return "service=" + this.service + "&scope=repository:" + this.registryEndpointRequestProperties.getImageName() + ":" + scope;
    }

    @VisibleForTesting
    URL getAuthenticationUrl(String scope) throws MalformedURLException {
        return this.isOAuth2Auth() ? new URL(this.realm) : new URL(this.realm + "?" + this.getServiceScopeRequestParameters(scope));
    }

    @VisibleForTesting
    String getAuthRequestParameters(String scope) {
        String serviceScope = this.getServiceScopeRequestParameters(scope);
        return this.isOAuth2Auth() ? serviceScope + "&client_id=jib.da031fe481a93ac107a95a96462358f9&grant_type=refresh_token&refresh_token=" + ((Credential)Verify.verifyNotNull((Object)this.credential)).getPassword() : serviceScope;
    }

    @VisibleForTesting
    boolean isOAuth2Auth() {
        return this.credential != null && this.credential.isOAuth2RefreshToken();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Authorization authenticate(String scope) throws RegistryAuthenticationFailedException {
        try (Connection connection = Connection.getConnectionFactory().apply(this.getAuthenticationUrl(scope));){
            Request.Builder requestBuilder = Request.builder().setHttpTimeout(JibSystemProperties.getHttpTimeout()).setUserAgent(this.userAgent);
            if (this.isOAuth2Auth()) {
                String parameters = this.getAuthRequestParameters(scope);
                requestBuilder.setBody(new BlobHttpContent(Blobs.from(parameters), MediaType.FORM_DATA.toString(), null));
            } else if (this.credential != null) {
                requestBuilder.setAuthorization(Authorizations.withBasicCredentials(this.credential.getUsername(), this.credential.getPassword()));
            }
            Request request = requestBuilder.build();
            Response response = this.isOAuth2Auth() ? connection.post(request) : connection.get(request);
            String responseString = Blobs.writeToString(response.getBody());
            AuthenticationResponseTemplate responseJson = JsonTemplateMapper.readJson(responseString, AuthenticationResponseTemplate.class);
            if (responseJson.getToken() == null) {
                throw new RegistryAuthenticationFailedException(this.registryEndpointRequestProperties.getServerUrl(), this.registryEndpointRequestProperties.getImageName(), "Did not get token in authentication response from " + this.getAuthenticationUrl(scope) + "; parameters: " + this.getAuthRequestParameters(scope));
            }
            Authorization authorization = Authorizations.withBearerToken(responseJson.getToken());
            return authorization;
        }
        catch (IOException ex) {
            throw new RegistryAuthenticationFailedException(this.registryEndpointRequestProperties.getServerUrl(), this.registryEndpointRequestProperties.getImageName(), ex);
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    private static class AuthenticationResponseTemplate
    implements JsonTemplate {
        @Nullable
        private String token;
        @Nullable
        private String access_token;

        private AuthenticationResponseTemplate() {
        }

        @Nullable
        private String getToken() {
            if (this.token != null) {
                return this.token;
            }
            return this.access_token;
        }
    }

    public static class Initializer {
        private final EventDispatcher eventDispatcher;
        private final String serverUrl;
        private final String repository;
        private boolean allowInsecureRegistries = false;
        @Nullable
        private String userAgentSuffix;

        private Initializer(EventDispatcher eventDispatcher, String serverUrl, String repository) {
            this.eventDispatcher = eventDispatcher;
            this.serverUrl = serverUrl;
            this.repository = repository;
        }

        public Initializer setAllowInsecureRegistries(boolean allowInsecureRegistries) {
            this.allowInsecureRegistries = allowInsecureRegistries;
            return this;
        }

        public Initializer setUserAgentSuffix(@Nullable String userAgentSuffix) {
            this.userAgentSuffix = userAgentSuffix;
            return this;
        }

        @Nullable
        public RegistryAuthenticator initialize() throws RegistryAuthenticationFailedException, IOException, RegistryException {
            try {
                return RegistryClient.factory(this.eventDispatcher, this.serverUrl, this.repository).setAllowInsecureRegistries(this.allowInsecureRegistries).setUserAgentSuffix(this.userAgentSuffix).newRegistryClient().getRegistryAuthenticator();
            }
            catch (MalformedURLException ex) {
                throw new RegistryAuthenticationFailedException(this.serverUrl, this.repository, ex);
            }
            catch (InsecureRegistryException ex) {
                return null;
            }
        }
    }
}

