/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.registry.credentials;

import com.google.api.client.util.Base64;
import com.google.cloud.tools.jib.configuration.credentials.Credential;
import com.google.cloud.tools.jib.event.EventDispatcher;
import com.google.cloud.tools.jib.event.events.LogEvent;
import com.google.cloud.tools.jib.json.JsonTemplateMapper;
import com.google.cloud.tools.jib.registry.RegistryAliasGroup;
import com.google.cloud.tools.jib.registry.credentials.CredentialHelperNotFoundException;
import com.google.cloud.tools.jib.registry.credentials.CredentialHelperUnhandledServerUrlException;
import com.google.cloud.tools.jib.registry.credentials.DockerConfig;
import com.google.cloud.tools.jib.registry.credentials.DockerCredentialHelper;
import com.google.cloud.tools.jib.registry.credentials.json.DockerConfigTemplate;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import javax.annotation.Nullable;

public class DockerConfigCredentialRetriever {
    private static final Path DOCKER_CONFIG_FILE = Paths.get(System.getProperty("user.home"), ".docker", "config.json");
    private final String registry;
    private final Path dockerConfigFile;

    public DockerConfigCredentialRetriever(String registry) {
        this(registry, DOCKER_CONFIG_FILE);
    }

    @VisibleForTesting
    public DockerConfigCredentialRetriever(String registry, Path dockerConfigFile) {
        this.registry = registry;
        this.dockerConfigFile = dockerConfigFile;
    }

    public Optional<Credential> retrieve(@Nullable EventDispatcher eventDispatcher) throws IOException {
        if (!Files.exists(this.dockerConfigFile, new LinkOption[0])) {
            return Optional.empty();
        }
        DockerConfig dockerConfig = new DockerConfig(JsonTemplateMapper.readJsonFromFile(this.dockerConfigFile, DockerConfigTemplate.class));
        return this.retrieve(dockerConfig, eventDispatcher);
    }

    @VisibleForTesting
    Optional<Credential> retrieve(DockerConfig dockerConfig, @Nullable EventDispatcher eventDispatcher) {
        for (String registryAlias : RegistryAliasGroup.getAliasesGroup(this.registry)) {
            String auth = dockerConfig.getAuthFor(registryAlias);
            if (auth != null) {
                String usernameColonPassword = new String(Base64.decodeBase64((String)auth), StandardCharsets.UTF_8);
                String username = usernameColonPassword.substring(0, usernameColonPassword.indexOf(":"));
                String password = usernameColonPassword.substring(usernameColonPassword.indexOf(":") + 1);
                return Optional.of(Credential.from(username, password));
            }
            DockerCredentialHelper dockerCredentialHelper = dockerConfig.getCredentialHelperFor(registryAlias);
            if (dockerCredentialHelper == null) continue;
            try {
                return Optional.of(dockerCredentialHelper.retrieve());
            }
            catch (CredentialHelperNotFoundException | CredentialHelperUnhandledServerUrlException | IOException ex) {
                if (eventDispatcher == null || ex.getMessage() == null) continue;
                eventDispatcher.dispatch(LogEvent.warn(ex.getMessage()));
                if (ex.getCause() == null || ex.getCause().getMessage() == null) continue;
                eventDispatcher.dispatch(LogEvent.warn("  Caused by: " + ex.getCause().getMessage()));
            }
        }
        return Optional.empty();
    }
}

