/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.registry.credentials;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.cloud.tools.jib.configuration.credentials.Credential;
import com.google.cloud.tools.jib.json.JsonTemplate;
import com.google.cloud.tools.jib.json.JsonTemplateMapper;
import com.google.cloud.tools.jib.registry.credentials.CredentialHelperNotFoundException;
import com.google.cloud.tools.jib.registry.credentials.CredentialHelperUnhandledServerUrlException;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.common.io.CharStreams;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.annotation.Nullable;

public class DockerCredentialHelper {
    public static final String CREDENTIAL_HELPER_PREFIX = "docker-credential-";
    private final String serverUrl;
    private final Path credentialHelper;

    public DockerCredentialHelper(String serverUrl, Path credentialHelper) {
        this.serverUrl = serverUrl;
        this.credentialHelper = credentialHelper;
    }

    DockerCredentialHelper(String registry, String credentialHelperSuffix) {
        this(registry, Paths.get(CREDENTIAL_HELPER_PREFIX + credentialHelperSuffix, new String[0]));
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public Credential retrieve() throws IOException, CredentialHelperUnhandledServerUrlException, CredentialHelperNotFoundException {
        try {
            String[] credentialHelperCommand = new String[]{this.credentialHelper.toString(), "get"};
            Process process = new ProcessBuilder(credentialHelperCommand).start();
            try (OutputStream processStdin = process.getOutputStream();){
                processStdin.write(this.serverUrl.getBytes(StandardCharsets.UTF_8));
            }
            var4_5 = null;
            try (InputStreamReader processStdoutReader = new InputStreamReader(process.getInputStream(), StandardCharsets.UTF_8);){
                String output = CharStreams.toString((Readable)processStdoutReader);
                if (output.contains("credentials not found in native keychain")) {
                    throw new CredentialHelperUnhandledServerUrlException(this.credentialHelper, this.serverUrl, output);
                }
                if (output.isEmpty()) {
                    InputStreamReader processStderrReader = new InputStreamReader(process.getErrorStream(), StandardCharsets.UTF_8);
                    Throwable throwable = null;
                    try {
                        try {
                            String errorOutput = CharStreams.toString((Readable)processStderrReader);
                            throw new CredentialHelperUnhandledServerUrlException(this.credentialHelper, this.serverUrl, errorOutput);
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                    }
                    catch (Throwable throwable3) {
                        DockerCredentialHelper.$closeResource(throwable, processStderrReader);
                        throw throwable3;
                    }
                }
                try {
                    DockerCredentialsTemplate dockerCredentials = JsonTemplateMapper.readJson(output, DockerCredentialsTemplate.class);
                    if (Strings.isNullOrEmpty((String)dockerCredentials.Username) || Strings.isNullOrEmpty((String)dockerCredentials.Secret)) {
                        throw new CredentialHelperUnhandledServerUrlException(this.credentialHelper, this.serverUrl, output);
                    }
                    Credential credential = Credential.from(dockerCredentials.Username, dockerCredentials.Secret);
                    return credential;
                }
                catch (JsonProcessingException ex) {
                    try {
                        throw new CredentialHelperUnhandledServerUrlException(this.credentialHelper, this.serverUrl, output);
                    }
                    catch (Throwable throwable) {
                        var4_5 = throwable;
                        throw throwable;
                    }
                }
            }
        }
        catch (IOException ex) {
            if (ex.getMessage() == null) {
                throw ex;
            }
            if (ex.getMessage().contains("No such file or directory") || ex.getMessage().contains("cannot find the file")) {
                throw new CredentialHelperNotFoundException(this.credentialHelper, (Throwable)ex);
            }
            throw ex;
        }
    }

    @VisibleForTesting
    Path getCredentialHelper() {
        return this.credentialHelper;
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    private static class DockerCredentialsTemplate
    implements JsonTemplate {
        @Nullable
        private String Username;
        @Nullable
        private String Secret;

        private DockerCredentialsTemplate() {
        }
    }
}

