/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.cache;

import com.google.cloud.tools.jib.api.DescriptorDigest;
import com.google.cloud.tools.jib.blob.Blob;
import com.google.cloud.tools.jib.blob.BlobDescriptor;
import com.google.cloud.tools.jib.image.Layer;
import com.google.common.base.Preconditions;
import javax.annotation.Nullable;

public class CachedLayer
implements Layer {
    private final DescriptorDigest layerDiffId;
    private final BlobDescriptor blobDescriptor;
    private final Blob layerBlob;

    static Builder builder() {
        return new Builder();
    }

    private CachedLayer(DescriptorDigest layerDigest, DescriptorDigest layerDiffId, long layerSize, Blob layerBlob) {
        this.layerDiffId = layerDiffId;
        this.layerBlob = layerBlob;
        this.blobDescriptor = new BlobDescriptor(layerSize, layerDigest);
    }

    public DescriptorDigest getDigest() {
        return this.blobDescriptor.getDigest();
    }

    public long getSize() {
        return this.blobDescriptor.getSize();
    }

    @Override
    public DescriptorDigest getDiffId() {
        return this.layerDiffId;
    }

    @Override
    public Blob getBlob() {
        return this.layerBlob;
    }

    @Override
    public BlobDescriptor getBlobDescriptor() {
        return this.blobDescriptor;
    }

    static class Builder {
        @Nullable
        private DescriptorDigest layerDigest;
        @Nullable
        private DescriptorDigest layerDiffId;
        private long layerSize = -1L;
        @Nullable
        private Blob layerBlob;

        private Builder() {
        }

        Builder setLayerDigest(DescriptorDigest layerDigest) {
            this.layerDigest = layerDigest;
            return this;
        }

        Builder setLayerDiffId(DescriptorDigest layerDiffId) {
            this.layerDiffId = layerDiffId;
            return this;
        }

        Builder setLayerSize(long layerSize) {
            this.layerSize = layerSize;
            return this;
        }

        Builder setLayerBlob(Blob layerBlob) {
            this.layerBlob = layerBlob;
            return this;
        }

        boolean hasLayerBlob() {
            return this.layerBlob != null;
        }

        CachedLayer build() {
            return new CachedLayer((DescriptorDigest)Preconditions.checkNotNull((Object)this.layerDigest, (Object)"layerDigest required"), (DescriptorDigest)Preconditions.checkNotNull((Object)this.layerDiffId, (Object)"layerDiffId required"), this.layerSize, (Blob)Preconditions.checkNotNull((Object)this.layerBlob, (Object)"layerBlob required"));
        }
    }
}

