/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.maven.skaffold;

import com.google.cloud.tools.jib.maven.MavenProjectProperties;
import com.google.cloud.tools.jib.plugins.common.ConfigurationPropertyValidator;
import com.google.cloud.tools.jib.plugins.common.SkaffoldFilesOutput;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.FileSet;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.DefaultDependencyResolutionRequest;
import org.apache.maven.project.DependencyResolutionException;
import org.apache.maven.project.DependencyResolutionResult;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectDependenciesResolver;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyFilter;

@Mojo(name="_skaffold-files-v2", requiresDependencyCollection=ResolutionScope.COMPILE_PLUS_RUNTIME, aggregator=true)
public class FilesMojoV2
extends AbstractMojo {
    @VisibleForTesting
    static final String GOAL_NAME = "_skaffold-files-v2";
    @Nullable
    @Parameter(defaultValue="${session}", required=true, readonly=true)
    private MavenSession session;
    @Nullable
    @Parameter(defaultValue="${reactorProjects}", required=true, readonly=true)
    private List<MavenProject> projects;
    @Nullable
    @Component
    private ProjectDependenciesResolver projectDependenciesResolver;
    private final SkaffoldFilesOutput skaffoldFilesOutput = new SkaffoldFilesOutput();

    public void execute() throws MojoExecutionException, MojoFailureException {
        Preconditions.checkNotNull(this.projects);
        Preconditions.checkNotNull((Object)this.session);
        Preconditions.checkNotNull((Object)this.projectDependenciesResolver);
        for (MavenProject project : this.projects) {
            this.skaffoldFilesOutput.addBuild(project.getFile().toPath());
            if ("pom".equals(project.getPackaging())) continue;
            this.skaffoldFilesOutput.addInput(Paths.get(project.getBuild().getSourceDirectory(), new String[0]));
            project.getBuild().getResources().stream().map(FileSet::getDirectory).map(x$0 -> Paths.get(x$0, new String[0])).forEach(this.skaffoldFilesOutput::addInput);
            if (project.getPlugin("com.google.cloud.tools:jib-maven-plugin") != null) {
                this.resolveExtraDirectories(project).forEach(this.skaffoldFilesOutput::addInput);
            }
            Set projectArtifacts = this.projects.stream().map(MavenProject::getArtifact).map(Object::toString).collect(Collectors.toSet());
            DependencyFilter ignoreProjectDependenciesFilter = (node, parents) -> {
                if (node == null || node.getDependency() == null) {
                    return false;
                }
                if (projectArtifacts.contains(node.getArtifact().toString())) {
                    return false;
                }
                return "compile+runtime".contains(node.getDependency().getScope());
            };
            try {
                DependencyResolutionResult resolutionResult = this.projectDependenciesResolver.resolve(new DefaultDependencyResolutionRequest(project, this.session.getRepositorySession()).setResolutionFilter(ignoreProjectDependenciesFilter));
                resolutionResult.getDependencies().stream().map(Dependency::getArtifact).filter(Artifact::isSnapshot).map(Artifact::getFile).map(File::toPath).forEach(this.skaffoldFilesOutput::addInput);
            }
            catch (DependencyResolutionException ex) {
                throw new MojoExecutionException("Failed to resolve dependencies", (Exception)((Object)ex));
            }
        }
        try {
            System.out.println("\nBEGIN JIB JSON");
            System.out.println(this.skaffoldFilesOutput.getJsonString());
        }
        catch (IOException ex) {
            throw new MojoExecutionException(ex.getMessage(), (Exception)ex);
        }
    }

    private List<Path> resolveExtraDirectories(MavenProject project) throws MojoExecutionException {
        return this.collectExtraDirectories(project).stream().map(path -> path.isAbsolute() ? path : project.getBasedir().toPath().resolve((Path)path)).collect(Collectors.toList());
    }

    private List<Path> collectExtraDirectories(MavenProject project) throws MojoExecutionException {
        Xpp3Dom pluginConfiguration;
        String property;
        String deprecatedProperty = MavenProjectProperties.getProperty("jib.extraDirectory.path", project, this.session);
        String newProperty = MavenProjectProperties.getProperty("jib.extraDirectories.paths", project, this.session);
        if (deprecatedProperty != null && newProperty != null) {
            throw new MojoExecutionException("You cannot configure both 'jib.extraDirectory.path' and 'jib.extraDirectories.paths'");
        }
        String string = property = newProperty != null ? newProperty : deprecatedProperty;
        if (property != null) {
            List<String> paths = ConfigurationPropertyValidator.parseListProperty(property);
            return paths.stream().map(x$0 -> Paths.get(x$0, new String[0])).collect(Collectors.toList());
        }
        Plugin jibMavenPlugin = project.getPlugin("com.google.cloud.tools:jib-maven-plugin");
        if (jibMavenPlugin != null && (pluginConfiguration = (Xpp3Dom)jibMavenPlugin.getConfiguration()) != null) {
            Xpp3Dom child;
            Xpp3Dom extraDirectoryConfiguration = pluginConfiguration.getChild("extraDirectory");
            Xpp3Dom extraDirectoriesConfiguration = pluginConfiguration.getChild("extraDirectories");
            if (extraDirectoryConfiguration != null && extraDirectoriesConfiguration != null) {
                throw new MojoExecutionException("You cannot configure both <extraDirectory> and <extraDirectories>");
            }
            if (extraDirectoriesConfiguration != null && (child = extraDirectoriesConfiguration.getChild("paths")) != null) {
                return Arrays.stream(child.getChildren()).map(Xpp3Dom::getValue).map(x$0 -> Paths.get(x$0, new String[0])).collect(Collectors.toList());
            }
            if (extraDirectoryConfiguration != null) {
                child = extraDirectoryConfiguration.getChild("path");
                if (child != null) {
                    return Collections.singletonList(Paths.get(child.getValue(), new String[0]));
                }
                String value = extraDirectoryConfiguration.getValue();
                if (value != null) {
                    return Collections.singletonList(Paths.get(extraDirectoryConfiguration.getValue(), new String[0]));
                }
            }
        }
        Path projectBase = ((MavenProject)Preconditions.checkNotNull((Object)project)).getBasedir().getAbsoluteFile().toPath();
        Path srcMainJib = Paths.get("src", "main", "jib");
        return Collections.singletonList(projectBase.resolve(srcMainJib));
    }
}

