/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.plugins.common;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.cloud.tools.jib.ProjectInfo;
import com.google.common.annotations.VisibleForTesting;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public class SkaffoldFilesOutput {
    private final SkaffoldFilesTemplate skaffoldFilesTemplate;

    public SkaffoldFilesOutput() {
        this.skaffoldFilesTemplate = new SkaffoldFilesTemplate();
    }

    @VisibleForTesting
    public SkaffoldFilesOutput(String json) throws IOException {
        this.skaffoldFilesTemplate = (SkaffoldFilesTemplate)new ObjectMapper().readValue(json, SkaffoldFilesTemplate.class);
    }

    public void addBuild(Path build) {
        this.skaffoldFilesTemplate.build.add(build.toString());
    }

    public void addInput(Path inputFile) {
        this.skaffoldFilesTemplate.inputs.add(inputFile.toString());
    }

    public void addIgnore(Path ignoreFile) {
        this.skaffoldFilesTemplate.ignore.add(ignoreFile.toString());
    }

    @VisibleForTesting
    public List<String> getBuild() {
        return this.skaffoldFilesTemplate.build;
    }

    @VisibleForTesting
    public List<String> getInputs() {
        return this.skaffoldFilesTemplate.inputs;
    }

    @VisibleForTesting
    public List<String> getIgnore() {
        return this.skaffoldFilesTemplate.ignore;
    }

    public String getJsonString() throws IOException {
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            new ObjectMapper().writeValue((OutputStream)outputStream, (Object)this.skaffoldFilesTemplate);
            String string = ((Object)outputStream).toString();
            return string;
        }
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
    private static class SkaffoldFilesTemplate {
        @Nullable
        private final String version = ProjectInfo.VERSION;
        private final List<String> build = new ArrayList<String>();
        private final List<String> inputs = new ArrayList<String>();
        private final List<String> ignore = new ArrayList<String>();

        private SkaffoldFilesTemplate() {
        }
    }
}

