/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.blob;

import com.google.cloud.tools.jib.blob.Blob;
import com.google.cloud.tools.jib.blob.FileBlob;
import com.google.cloud.tools.jib.blob.InputStreamBlob;
import com.google.cloud.tools.jib.blob.JsonBlob;
import com.google.cloud.tools.jib.blob.StringBlob;
import com.google.cloud.tools.jib.blob.WritableContentsBlob;
import com.google.cloud.tools.jib.hash.WritableContents;
import com.google.cloud.tools.jib.json.JsonTemplate;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.zip.GZIPOutputStream;

public class Blobs {
    public static Blob from(InputStream inputStream) {
        return new InputStreamBlob(inputStream);
    }

    public static Blob from(Path file) {
        return new FileBlob(file);
    }

    public static Blob from(JsonTemplate template) {
        return new JsonBlob(template);
    }

    public static Blob from(String content) {
        return new StringBlob(content);
    }

    public static Blob from(WritableContents writable) {
        return new WritableContentsBlob(writable);
    }

    public static String writeToString(Blob blob) throws IOException {
        return new String(Blobs.writeToByteArray(blob), StandardCharsets.UTF_8);
    }

    public static byte[] writeToByteArray(Blob blob) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        blob.writeTo(byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static Blob compress(Blob blob) {
        return Blobs.from((OutputStream outputStream) -> {
            try (GZIPOutputStream compressorStream = new GZIPOutputStream(outputStream);){
                blob.writeTo(compressorStream);
            }
        });
    }

    private Blobs() {
    }
}

