/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.maven;

import com.google.cloud.tools.jib.api.CacheDirectoryCreationException;
import com.google.cloud.tools.jib.api.InvalidImageReferenceException;
import com.google.cloud.tools.jib.docker.DockerClient;
import com.google.cloud.tools.jib.maven.JibPluginConfiguration;
import com.google.cloud.tools.jib.maven.MavenHelpfulSuggestions;
import com.google.cloud.tools.jib.maven.MavenProjectProperties;
import com.google.cloud.tools.jib.maven.MavenRawConfiguration;
import com.google.cloud.tools.jib.maven.MavenSettingsProxyProvider;
import com.google.cloud.tools.jib.maven.MavenSettingsServerCredentials;
import com.google.cloud.tools.jib.maven.MojoCommon;
import com.google.cloud.tools.jib.plugins.common.BuildStepsExecutionException;
import com.google.cloud.tools.jib.plugins.common.ConfigurationPropertyValidator;
import com.google.cloud.tools.jib.plugins.common.HelpfulSuggestions;
import com.google.cloud.tools.jib.plugins.common.IncompatibleBaseImageJavaVersionException;
import com.google.cloud.tools.jib.plugins.common.InvalidAppRootException;
import com.google.cloud.tools.jib.plugins.common.InvalidContainerVolumeException;
import com.google.cloud.tools.jib.plugins.common.InvalidContainerizingModeException;
import com.google.cloud.tools.jib.plugins.common.InvalidCreationTimeException;
import com.google.cloud.tools.jib.plugins.common.InvalidFilesModificationTimeException;
import com.google.cloud.tools.jib.plugins.common.InvalidWorkingDirectoryException;
import com.google.cloud.tools.jib.plugins.common.MainClassInferenceException;
import com.google.cloud.tools.jib.plugins.common.PluginConfigurationProcessor;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="dockerBuild", requiresDependencyResolution=ResolutionScope.RUNTIME_PLUS_SYSTEM)
public class BuildDockerMojo
extends JibPluginConfiguration {
    @VisibleForTesting
    static final String GOAL_NAME = "dockerBuild";
    private static final String HELPFUL_SUGGESTIONS_PREFIX = "Build to Docker daemon failed";
    @Parameter
    private DockerClientConfiguration dockerClient = new DockerClientConfiguration();

    public void execute() throws MojoExecutionException, MojoFailureException {
        boolean isDockerInstalled;
        this.checkJibVersion();
        if (this.isSkipped()) {
            this.getLog().info((CharSequence)"Skipping containerization because jib-maven-plugin: skip = true");
            return;
        }
        if (!this.isContainerizable()) {
            this.getLog().info((CharSequence)"Skipping containerization of this module (not specified in jib.containerize)");
            return;
        }
        if ("pom".equals(this.getProject().getPackaging())) {
            this.getLog().info((CharSequence)"Skipping containerization because packaging is 'pom'...");
            return;
        }
        Path dockerExecutable = this.getDockerClientExecutable();
        boolean bl = isDockerInstalled = dockerExecutable == null ? DockerClient.isDefaultDockerInstalled() : DockerClient.isDockerInstalled(dockerExecutable);
        if (!isDockerInstalled) {
            throw new MojoExecutionException(HelpfulSuggestions.forDockerNotInstalled(HELPFUL_SUGGESTIONS_PREFIX));
        }
        MojoCommon.checkUseCurrentTimestampDeprecation(this);
        MavenSettingsProxyProvider.activateHttpAndHttpsProxies(this.getSession().getSettings(), this.getSettingsDecrypter());
        MavenProjectProperties projectProperties = MavenProjectProperties.getForProject(this.getProject(), this.getSession(), this.getLog());
        try {
            PluginConfigurationProcessor.createJibBuildRunnerForDockerDaemonImage(new MavenRawConfiguration(this), new MavenSettingsServerCredentials(this.getSession().getSettings(), this.getSettingsDecrypter()), projectProperties, dockerExecutable, this.getDockerClientEnvironment(), new MavenHelpfulSuggestions(HELPFUL_SUGGESTIONS_PREFIX)).runBuild();
        }
        catch (InvalidAppRootException ex) {
            throw new MojoExecutionException("<container><appRoot> is not an absolute Unix-style path: " + ex.getInvalidPathValue(), (Exception)ex);
        }
        catch (InvalidContainerizingModeException ex) {
            throw new MojoExecutionException("invalid value for <containerizingMode>: " + ex.getInvalidContainerizingMode(), (Exception)ex);
        }
        catch (InvalidWorkingDirectoryException ex) {
            throw new MojoExecutionException("<container><workingDirectory> is not an absolute Unix-style path: " + ex.getInvalidPathValue(), (Exception)ex);
        }
        catch (InvalidContainerVolumeException ex) {
            throw new MojoExecutionException("<container><volumes> is not an absolute Unix-style path: " + ex.getInvalidVolume(), (Exception)ex);
        }
        catch (InvalidFilesModificationTimeException ex) {
            throw new MojoExecutionException("<container><filesModificationTime> should be an ISO 8601 date-time (see DateTimeFormatter.ISO_DATE_TIME) or special keyword \"EPOCH_PLUS_SECOND\": " + ex.getInvalidFilesModificationTime(), (Exception)ex);
        }
        catch (InvalidCreationTimeException ex) {
            throw new MojoExecutionException("<container><creationTime> should be an ISO 8601 date-time (see DateTimeFormatter.ISO_DATE_TIME) or a special keyword (\"EPOCH\", \"USE_CURRENT_TIMESTAMP\"): " + ex.getInvalidCreationTime(), (Exception)ex);
        }
        catch (IncompatibleBaseImageJavaVersionException ex) {
            throw new MojoExecutionException(HelpfulSuggestions.forIncompatibleBaseImageJavaVesionForMaven(ex.getBaseImageMajorJavaVersion(), ex.getProjectMajorJavaVersion()), (Exception)ex);
        }
        catch (InvalidImageReferenceException ex) {
            throw new MojoExecutionException(HelpfulSuggestions.forInvalidImageReference(ex.getInvalidReference()), (Exception)ex);
        }
        catch (CacheDirectoryCreationException | MainClassInferenceException | IOException ex) {
            throw new MojoExecutionException(ex.getMessage(), ex);
        }
        catch (BuildStepsExecutionException ex) {
            throw new MojoExecutionException(ex.getMessage(), ex.getCause());
        }
        finally {
            projectProperties.waitForLoggingThread();
            this.getLog().info((CharSequence)"");
        }
    }

    @Nullable
    private Path getDockerClientExecutable() {
        String property = this.getProperty("jib.dockerClient.executable");
        if (property != null) {
            return Paths.get(property, new String[0]);
        }
        return this.dockerClient.executable == null ? null : this.dockerClient.executable.toPath();
    }

    @Nullable
    private Map<String, String> getDockerClientEnvironment() {
        String property = this.getProperty("jib.dockerClient.environment");
        if (property != null) {
            return ConfigurationPropertyValidator.parseMapProperty(property);
        }
        return this.dockerClient.environment;
    }

    public static class DockerClientConfiguration {
        @Nullable
        @Parameter
        private File executable;
        @Nullable
        @Parameter
        private Map<String, String> environment;
    }
}

