/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.builder.steps;

import com.google.cloud.tools.jib.api.Credential;
import com.google.cloud.tools.jib.api.InsecureRegistryException;
import com.google.cloud.tools.jib.api.RegistryException;
import com.google.cloud.tools.jib.builder.ProgressEventDispatcher;
import com.google.cloud.tools.jib.builder.TimerEventDispatcher;
import com.google.cloud.tools.jib.configuration.BuildConfiguration;
import com.google.cloud.tools.jib.http.Authorization;
import com.google.cloud.tools.jib.registry.RegistryAuthenticator;
import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.Callable;
import javax.annotation.Nullable;

class AuthenticatePushStep
implements Callable<Optional<Authorization>> {
    private static final String DESCRIPTION = "Authenticating push to %s";
    private final BuildConfiguration buildConfiguration;
    private final ProgressEventDispatcher.Factory progressEventDispatcherFactory;
    @Nullable
    private final Credential registryCredential;

    AuthenticatePushStep(BuildConfiguration buildConfiguration, ProgressEventDispatcher.Factory progressEventDispatcherFactory, @Nullable Credential registryCredential) {
        this.buildConfiguration = buildConfiguration;
        this.progressEventDispatcherFactory = progressEventDispatcherFactory;
        this.registryCredential = registryCredential;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Optional<Authorization> call() throws IOException, RegistryException {
        Optional<Authorization> optional;
        String registry = this.buildConfiguration.getTargetImageConfiguration().getImageRegistry();
        try (ProgressEventDispatcher ignored = this.progressEventDispatcherFactory.create("authenticating push to " + registry, 1L);
             TimerEventDispatcher ignored2 = new TimerEventDispatcher(this.buildConfiguration.getEventHandlers(), String.format(DESCRIPTION, registry));){
            Optional<RegistryAuthenticator> registryAuthenticator = this.buildConfiguration.newTargetImageRegistryClientFactory().newRegistryClient().getRegistryAuthenticator();
            if (registryAuthenticator.isPresent()) {
                Optional<Authorization> optional2 = Optional.of(registryAuthenticator.get().authenticatePush(this.registryCredential));
                return optional2;
            }
        }
        catch (InsecureRegistryException insecureRegistryException) {
            // empty catch block
        }
        if (this.registryCredential != null && !this.registryCredential.isOAuth2RefreshToken()) {
            optional = Optional.of(Authorization.fromBasicCredentials(this.registryCredential.getUsername(), this.registryCredential.getPassword()));
            return optional;
        }
        optional = Optional.empty();
        return optional;
    }
}

