/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.registry;

import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpResponseException;
import com.google.cloud.tools.jib.api.InsecureRegistryException;
import com.google.cloud.tools.jib.api.LogEvent;
import com.google.cloud.tools.jib.api.RegistryException;
import com.google.cloud.tools.jib.api.RegistryUnauthorizedException;
import com.google.cloud.tools.jib.event.EventHandlers;
import com.google.cloud.tools.jib.global.JibSystemProperties;
import com.google.cloud.tools.jib.http.Authorization;
import com.google.cloud.tools.jib.http.Connection;
import com.google.cloud.tools.jib.http.Request;
import com.google.cloud.tools.jib.http.Response;
import com.google.cloud.tools.jib.json.JsonTemplateMapper;
import com.google.cloud.tools.jib.registry.RegistryCredentialsNotSentException;
import com.google.cloud.tools.jib.registry.RegistryEndpointProvider;
import com.google.cloud.tools.jib.registry.RegistryEndpointRequestProperties;
import com.google.cloud.tools.jib.registry.RegistryErrorException;
import com.google.cloud.tools.jib.registry.RegistryErrorExceptionBuilder;
import com.google.cloud.tools.jib.registry.json.ErrorEntryTemplate;
import com.google.cloud.tools.jib.registry.json.ErrorResponseTemplate;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.util.Locale;
import java.util.function.Function;
import javax.annotation.Nullable;
import javax.net.ssl.SSLException;

class RegistryEndpointCaller<T> {
    @VisibleForTesting
    static final int STATUS_CODE_PERMANENT_REDIRECT = 308;
    private static final String DEFAULT_PROTOCOL = "https";
    private final EventHandlers eventHandlers;
    private final URL initialRequestUrl;
    private final String userAgent;
    private final RegistryEndpointProvider<T> registryEndpointProvider;
    @Nullable
    private final Authorization authorization;
    private final RegistryEndpointRequestProperties registryEndpointRequestProperties;
    private final boolean allowInsecureRegistries;
    private final Function<URL, Connection> connectionFactory;
    @Nullable
    private Function<URL, Connection> insecureConnectionFactory;

    private static boolean isHttpsProtocol(URL url) {
        return DEFAULT_PROTOCOL.equals(url.getProtocol());
    }

    @VisibleForTesting
    static boolean isBrokenPipe(IOException original) {
        Throwable exception = original;
        while (exception != null) {
            String message = exception.getMessage();
            if (message != null && message.toLowerCase(Locale.US).contains("broken pipe")) {
                return true;
            }
            if ((exception = exception.getCause()) != original) continue;
            return false;
        }
        return false;
    }

    RegistryEndpointCaller(EventHandlers eventHandlers, String userAgent, String apiRouteBase, RegistryEndpointProvider<T> registryEndpointProvider, @Nullable Authorization authorization, RegistryEndpointRequestProperties registryEndpointRequestProperties, boolean allowInsecureRegistries) throws MalformedURLException {
        this(eventHandlers, userAgent, apiRouteBase, registryEndpointProvider, authorization, registryEndpointRequestProperties, allowInsecureRegistries, Connection.getConnectionFactory(), null);
    }

    @VisibleForTesting
    RegistryEndpointCaller(EventHandlers eventHandlers, String userAgent, String apiRouteBase, RegistryEndpointProvider<T> registryEndpointProvider, @Nullable Authorization authorization, RegistryEndpointRequestProperties registryEndpointRequestProperties, boolean allowInsecureRegistries, Function<URL, Connection> connectionFactory, @Nullable Function<URL, Connection> insecureConnectionFactory) throws MalformedURLException {
        this.eventHandlers = eventHandlers;
        this.initialRequestUrl = registryEndpointProvider.getApiRoute("https://" + apiRouteBase);
        this.userAgent = userAgent;
        this.registryEndpointProvider = registryEndpointProvider;
        this.authorization = authorization;
        this.registryEndpointRequestProperties = registryEndpointRequestProperties;
        this.allowInsecureRegistries = allowInsecureRegistries;
        this.connectionFactory = connectionFactory;
        this.insecureConnectionFactory = insecureConnectionFactory;
    }

    T call() throws IOException, RegistryException {
        try {
            return this.callWithAllowInsecureRegistryHandling(this.initialRequestUrl);
        }
        catch (IOException ex) {
            String registry = this.registryEndpointRequestProperties.getServerUrl();
            String repository = this.registryEndpointRequestProperties.getImageName();
            this.logError("I/O error for image [" + registry + "/" + repository + "]:");
            this.logError("    " + ex.getMessage());
            if (RegistryEndpointCaller.isBrokenPipe(ex)) {
                this.logError("broken pipe: the server shut down the connection. Check the server log if possible. This could also be a proxy issue. For example, a proxy may prevent sending packets that are too large.");
            }
            throw ex;
        }
    }

    private T callWithAllowInsecureRegistryHandling(URL url) throws IOException, RegistryException {
        if (!RegistryEndpointCaller.isHttpsProtocol(url) && !this.allowInsecureRegistries) {
            throw new InsecureRegistryException(url);
        }
        try {
            return this.call(url, this.connectionFactory);
        }
        catch (SSLException ex) {
            return this.handleUnverifiableServerException(url);
        }
        catch (ConnectException ex) {
            if (ex.getMessage() != null && ex.getMessage().contains("timed out")) {
                throw ex;
            }
            if (this.allowInsecureRegistries && RegistryEndpointCaller.isHttpsProtocol(url) && url.getPort() == -1) {
                return this.fallBackToHttp(url);
            }
            throw ex;
        }
    }

    private T handleUnverifiableServerException(URL url) throws IOException, RegistryException {
        if (!this.allowInsecureRegistries) {
            throw new InsecureRegistryException(url);
        }
        try {
            this.eventHandlers.dispatch(LogEvent.info("Cannot verify server at " + url + ". Attempting again with no TLS verification."));
            return this.call(url, this.getInsecureConnectionFactory());
        }
        catch (SSLException ex) {
            return this.fallBackToHttp(url);
        }
    }

    private T fallBackToHttp(URL url) throws IOException, RegistryException {
        GenericUrl httpUrl = new GenericUrl(url);
        httpUrl.setScheme("http");
        this.eventHandlers.dispatch(LogEvent.info("Failed to connect to " + url + " over HTTPS. Attempting again with HTTP: " + httpUrl));
        return this.call(httpUrl.toURL(), this.connectionFactory);
    }

    private Function<URL, Connection> getInsecureConnectionFactory() throws RegistryException {
        try {
            if (this.insecureConnectionFactory == null) {
                this.insecureConnectionFactory = Connection.getInsecureConnectionFactory();
            }
            return this.insecureConnectionFactory;
        }
        catch (GeneralSecurityException ex) {
            throw new RegistryException("cannot turn off TLS peer verification", ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private T call(URL url, Function<URL, Connection> connectionFactory) throws IOException, RegistryException {
        boolean sendCredentials = RegistryEndpointCaller.isHttpsProtocol(url) || JibSystemProperties.sendCredentialsOverHttp();
        try (Connection connection = connectionFactory.apply(url);){
            Request.Builder requestBuilder = Request.builder().setUserAgent(this.userAgent).setHttpTimeout(JibSystemProperties.getHttpTimeout()).setAccept(this.registryEndpointProvider.getAccept()).setBody(this.registryEndpointProvider.getContent());
            if (sendCredentials) {
                requestBuilder.setAuthorization(this.authorization);
            }
            Response response = connection.send(this.registryEndpointProvider.getHttpMethod(), requestBuilder.build());
            T t = this.registryEndpointProvider.handleResponse(response);
            return t;
        }
        catch (HttpResponseException ex) {
            try {
                return this.registryEndpointProvider.handleHttpResponseException(ex);
            }
            catch (HttpResponseException httpResponseException) {
                if (httpResponseException.getStatusCode() == 400) throw this.newRegistryErrorException(httpResponseException);
                if (httpResponseException.getStatusCode() == 404) throw this.newRegistryErrorException(httpResponseException);
                if (httpResponseException.getStatusCode() == 405) {
                    throw this.newRegistryErrorException(httpResponseException);
                }
                if (httpResponseException.getStatusCode() == 403) {
                    throw new RegistryUnauthorizedException(this.registryEndpointRequestProperties.getServerUrl(), this.registryEndpointRequestProperties.getImageName(), httpResponseException);
                }
                if (httpResponseException.getStatusCode() == 401) {
                    if (!sendCredentials) throw new RegistryCredentialsNotSentException(this.registryEndpointRequestProperties.getServerUrl(), this.registryEndpointRequestProperties.getImageName());
                    throw new RegistryUnauthorizedException(this.registryEndpointRequestProperties.getServerUrl(), this.registryEndpointRequestProperties.getImageName(), httpResponseException);
                }
                if (httpResponseException.getStatusCode() != 307 && httpResponseException.getStatusCode() != 301) {
                    if (httpResponseException.getStatusCode() != 308) throw httpResponseException;
                }
                URL redirectLocation = new URL(url, httpResponseException.getHeaders().getLocation());
                return this.callWithAllowInsecureRegistryHandling(redirectLocation);
            }
        }
    }

    @VisibleForTesting
    RegistryErrorException newRegistryErrorException(HttpResponseException httpResponseException) {
        RegistryErrorExceptionBuilder registryErrorExceptionBuilder = new RegistryErrorExceptionBuilder(this.registryEndpointProvider.getActionDescription(), httpResponseException);
        try {
            ErrorResponseTemplate errorResponse = JsonTemplateMapper.readJson(httpResponseException.getContent(), ErrorResponseTemplate.class);
            for (ErrorEntryTemplate errorEntry : errorResponse.getErrors()) {
                registryErrorExceptionBuilder.addReason(errorEntry);
            }
        }
        catch (IOException ex) {
            registryErrorExceptionBuilder.addReason("registry returned error code " + httpResponseException.getStatusCode() + "; possible causes include invalid or wrong reference. Actual error output follows:\n" + httpResponseException.getContent() + "\n");
        }
        return registryErrorExceptionBuilder.build();
    }

    private void logError(String message) {
        this.eventHandlers.dispatch(LogEvent.error("\u001b[31;1m" + message + "\u001b[0m"));
    }
}

