/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.builder.steps;

import com.google.cloud.tools.jib.api.LogEvent;
import com.google.cloud.tools.jib.builder.ProgressEventDispatcher;
import com.google.cloud.tools.jib.builder.steps.BuildResult;
import com.google.cloud.tools.jib.configuration.BuildConfiguration;
import com.google.cloud.tools.jib.docker.ImageTarball;
import com.google.cloud.tools.jib.filesystem.FileOperations;
import com.google.cloud.tools.jib.image.Image;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.Callable;

public class WriteTarFileStep
implements Callable<BuildResult> {
    private final BuildConfiguration buildConfiguration;
    private final ProgressEventDispatcher.Factory progressEventDispatcherFactory;
    private final Path outputPath;
    private final Image builtImage;

    WriteTarFileStep(BuildConfiguration buildConfiguration, ProgressEventDispatcher.Factory progressEventDispatcherFactory, Path outputPath, Image builtImage) {
        this.buildConfiguration = buildConfiguration;
        this.progressEventDispatcherFactory = progressEventDispatcherFactory;
        this.outputPath = outputPath;
        this.builtImage = builtImage;
    }

    @Override
    public BuildResult call() throws IOException {
        this.buildConfiguration.getEventHandlers().dispatch(LogEvent.progress("Building image to tar file..."));
        try (ProgressEventDispatcher ignored = this.progressEventDispatcherFactory.create("writing to tar file", 1L);){
            if (this.outputPath.getParent() != null) {
                Files.createDirectories(this.outputPath.getParent(), new FileAttribute[0]);
            }
            try (BufferedOutputStream outputStream = new BufferedOutputStream(FileOperations.newLockingOutputStream(this.outputPath));){
                new ImageTarball(this.builtImage, this.buildConfiguration.getTargetImageConfiguration().getImage(), this.buildConfiguration.getAllTargetImageTags()).writeTo(outputStream);
            }
            BuildResult buildResult = BuildResult.fromImage(this.builtImage, this.buildConfiguration.getTargetFormat());
            return buildResult;
        }
    }
}

