/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.registry;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.google.api.client.util.Base64;
import com.google.cloud.tools.jib.ProjectInfo;
import com.google.cloud.tools.jib.api.DescriptorDigest;
import com.google.cloud.tools.jib.api.RegistryException;
import com.google.cloud.tools.jib.blob.Blob;
import com.google.cloud.tools.jib.blob.BlobDescriptor;
import com.google.cloud.tools.jib.blob.Blobs;
import com.google.cloud.tools.jib.event.EventHandlers;
import com.google.cloud.tools.jib.global.JibSystemProperties;
import com.google.cloud.tools.jib.http.Authorization;
import com.google.cloud.tools.jib.image.json.BuildableManifestTemplate;
import com.google.cloud.tools.jib.image.json.ManifestTemplate;
import com.google.cloud.tools.jib.json.JsonTemplate;
import com.google.cloud.tools.jib.json.JsonTemplateMapper;
import com.google.cloud.tools.jib.registry.AuthenticationMethodRetriever;
import com.google.cloud.tools.jib.registry.BlobChecker;
import com.google.cloud.tools.jib.registry.BlobPuller;
import com.google.cloud.tools.jib.registry.ManifestAndDigest;
import com.google.cloud.tools.jib.registry.ManifestPuller;
import com.google.cloud.tools.jib.registry.ManifestPusher;
import com.google.cloud.tools.jib.registry.RegistryAuthenticator;
import com.google.cloud.tools.jib.registry.RegistryEndpointCaller;
import com.google.cloud.tools.jib.registry.RegistryEndpointProvider;
import com.google.cloud.tools.jib.registry.RegistryEndpointRequestProperties;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Multimap;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.annotation.Nullable;

public class RegistryClient {
    private final EventHandlers eventHandlers;
    @Nullable
    private final Authorization authorization;
    private final RegistryEndpointRequestProperties registryEndpointRequestProperties;
    private final boolean allowInsecureRegistries;
    private final String userAgent;

    public static Factory factory(EventHandlers eventHandlers, String serverUrl, String imageName) {
        return new Factory(eventHandlers, new RegistryEndpointRequestProperties(serverUrl, imageName));
    }

    public static Factory factory(EventHandlers eventHandlers, String serverUrl, String imageName, String sourceImageName) {
        return new Factory(eventHandlers, new RegistryEndpointRequestProperties(serverUrl, imageName, sourceImageName));
    }

    @Nullable
    @VisibleForTesting
    static Multimap<String, String> decodeTokenRepositoryGrants(String token) {
        byte[] payloadData;
        String[] jwtParts = token.split("\\.", -1);
        if (jwtParts.length != 3 || (payloadData = Base64.decodeBase64((String)jwtParts[1])) == null) {
            return null;
        }
        try {
            TokenPayloadTemplate payload = JsonTemplateMapper.readJson(payloadData, TokenPayloadTemplate.class);
            if (payload.access == null) {
                return null;
            }
            return (Multimap)payload.access.stream().filter(claim -> "repository".equals(((AccessClaim)claim).type)).collect(ImmutableSetMultimap.flatteningToImmutableSetMultimap(claim -> ((AccessClaim)claim).name, claim -> ((AccessClaim)claim).actions == null ? Stream.empty() : ((AccessClaim)claim).actions.stream()));
        }
        catch (IOException ex) {
            return null;
        }
    }

    private RegistryClient(EventHandlers eventHandlers, @Nullable Authorization authorization, RegistryEndpointRequestProperties registryEndpointRequestProperties, boolean allowInsecureRegistries, String userAgent) {
        this.eventHandlers = eventHandlers;
        this.authorization = authorization;
        this.registryEndpointRequestProperties = registryEndpointRequestProperties;
        this.allowInsecureRegistries = allowInsecureRegistries;
        this.userAgent = userAgent;
    }

    public Optional<RegistryAuthenticator> getRegistryAuthenticator() throws IOException, RegistryException {
        return this.callRegistryEndpoint(new AuthenticationMethodRetriever(this.registryEndpointRequestProperties, this.getUserAgent()));
    }

    public <T extends ManifestTemplate> ManifestAndDigest<T> pullManifest(String imageTag, Class<T> manifestTemplateClass) throws IOException, RegistryException {
        ManifestPuller<T> manifestPuller = new ManifestPuller<T>(this.registryEndpointRequestProperties, imageTag, manifestTemplateClass);
        return (ManifestAndDigest)this.callRegistryEndpoint(manifestPuller);
    }

    public ManifestAndDigest<ManifestTemplate> pullManifest(String imageTag) throws IOException, RegistryException {
        return this.pullManifest(imageTag, ManifestTemplate.class);
    }

    public DescriptorDigest pushManifest(BuildableManifestTemplate manifestTemplate, String imageTag) throws IOException, RegistryException {
        return this.callRegistryEndpoint(new ManifestPusher(this.registryEndpointRequestProperties, manifestTemplate, imageTag, this.eventHandlers));
    }

    public Optional<BlobDescriptor> checkBlob(DescriptorDigest blobDigest) throws IOException, RegistryException {
        BlobChecker blobChecker = new BlobChecker(this.registryEndpointRequestProperties, blobDigest);
        return this.callRegistryEndpoint(blobChecker);
    }

    public Blob pullBlob(DescriptorDigest blobDigest, Consumer<Long> blobSizeListener, Consumer<Long> writtenByteCountListener) {
        return Blobs.from(outputStream -> {
            try {
                this.callRegistryEndpoint(new BlobPuller(this.registryEndpointRequestProperties, blobDigest, outputStream, blobSizeListener, writtenByteCountListener));
            }
            catch (RegistryException ex) {
                throw new IOException(ex);
            }
        });
    }

    /*
     * Exception decompiling
     */
    public boolean pushBlob(DescriptorDigest blobDigest, Blob blob, @Nullable String sourceRepository, Consumer<Long> writtenByteCountListener) throws IOException, RegistryException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @VisibleForTesting
    static boolean canAttemptBlobMount(@Nullable Authorization authorization, String repository) {
        if (authorization == null || !"bearer".equalsIgnoreCase(authorization.getScheme())) {
            return true;
        }
        Multimap<String, String> repositoryGrants = RegistryClient.decodeTokenRepositoryGrants(authorization.getToken());
        return repositoryGrants == null || repositoryGrants.containsEntry((Object)repository, (Object)"pull");
    }

    @VisibleForTesting
    String getUserAgent() {
        return this.userAgent;
    }

    private <T> T callRegistryEndpoint(RegistryEndpointProvider<T> registryEndpointProvider) throws IOException, RegistryException {
        return new RegistryEndpointCaller<T>(this.eventHandlers, this.userAgent, registryEndpointProvider, this.authorization, this.registryEndpointRequestProperties, this.allowInsecureRegistries).call();
    }

    private static /* synthetic */ /* end resource */ void $closeResource(Throwable x0, AutoCloseable x1) {
        if (x0 != null) {
            try {
                x1.close();
            }
            catch (Throwable throwable) {
                x0.addSuppressed(throwable);
            }
        } else {
            x1.close();
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    private static class AccessClaim
    implements JsonTemplate {
        @Nullable
        private String type;
        @Nullable
        private String name;
        @Nullable
        private List<String> actions;

        private AccessClaim() {
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    private static class TokenPayloadTemplate
    implements JsonTemplate {
        @Nullable
        private List<AccessClaim> access;

        private TokenPayloadTemplate() {
        }
    }

    public static class Factory {
        private final EventHandlers eventHandlers;
        private final RegistryEndpointRequestProperties registryEndpointRequestProperties;
        private boolean allowInsecureRegistries = false;
        @Nullable
        private String userAgentSuffix;
        @Nullable
        private Authorization authorization;

        private Factory(EventHandlers eventHandlers, RegistryEndpointRequestProperties registryEndpointRequestProperties) {
            this.eventHandlers = eventHandlers;
            this.registryEndpointRequestProperties = registryEndpointRequestProperties;
        }

        public Factory setAllowInsecureRegistries(boolean allowInsecureRegistries) {
            this.allowInsecureRegistries = allowInsecureRegistries;
            return this;
        }

        public Factory setAuthorization(@Nullable Authorization authorization) {
            this.authorization = authorization;
            return this;
        }

        public Factory setUserAgentSuffix(@Nullable String userAgentSuffix) {
            this.userAgentSuffix = userAgentSuffix;
            return this;
        }

        public RegistryClient newRegistryClient() {
            return new RegistryClient(this.eventHandlers, this.authorization, this.registryEndpointRequestProperties, this.allowInsecureRegistries, this.makeUserAgent());
        }

        private String makeUserAgent() {
            if (!JibSystemProperties.isUserAgentEnabled()) {
                return "";
            }
            StringBuilder userAgentBuilder = new StringBuilder("jib ").append(ProjectInfo.VERSION);
            if (this.userAgentSuffix != null) {
                userAgentBuilder.append(" ").append(this.userAgentSuffix);
            }
            if (!Strings.isNullOrEmpty((String)System.getProperty("_JIB_UPSTREAM_CLIENT"))) {
                userAgentBuilder.append(" ").append(System.getProperty("_JIB_UPSTREAM_CLIENT"));
            }
            return userAgentBuilder.toString();
        }
    }
}

