/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.maven.skaffold;

import com.google.cloud.tools.jib.filesystem.TempDirectoryProvider;
import com.google.cloud.tools.jib.maven.JibPluginConfiguration;
import com.google.cloud.tools.jib.maven.MavenProjectProperties;
import com.google.cloud.tools.jib.maven.MavenRawConfiguration;
import com.google.cloud.tools.jib.maven.MojoCommon;
import com.google.cloud.tools.jib.plugins.common.ContainerizingMode;
import com.google.cloud.tools.jib.plugins.common.InvalidContainerizingModeException;
import com.google.cloud.tools.jib.plugins.common.PluginConfigurationProcessor;
import com.google.common.annotations.VisibleForTesting;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="_skaffold-sync-map", requiresDependencyCollection=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class SyncMapMojo
extends JibPluginConfiguration {
    @VisibleForTesting
    static final String GOAL_NAME = "_skaffold-sync-map";

    public void execute() throws MojoExecutionException {
        this.checkJibVersion();
        if (MojoCommon.shouldSkipJibExecution(this)) {
            return;
        }
        if (!"jar".equals(this.getProject().getPackaging())) {
            throw new MojoExecutionException("Skaffold sync is currently only available for 'jar' style Jib projects, but the packaging of " + this.getProject().getArtifactId() + " is '" + this.getProject().getPackaging() + "'");
        }
        try {
            if (!ContainerizingMode.EXPLODED.equals((Object)ContainerizingMode.from(this.getContainerizingMode()))) {
                throw new MojoExecutionException("Skaffold sync is currently only available for Jib projects in 'exploded' containerizing mode, but the containerizing mode of " + this.getProject().getArtifactId() + " is '" + this.getContainerizingMode() + "'");
            }
        }
        catch (InvalidContainerizingModeException ex) {
            throw new MojoExecutionException("Invalid containerizing mode", (Exception)ex);
        }
        try (TempDirectoryProvider tempDirectoryProvider = new TempDirectoryProvider();){
            MavenProjectProperties projectProperties = MavenProjectProperties.getForProject(this.getProject(), this.getSession(), this.getLog(), tempDirectoryProvider);
            MavenRawConfiguration configuration = new MavenRawConfiguration(this);
            try {
                String syncMapJson = PluginConfigurationProcessor.getSkaffoldSyncMap(configuration, projectProperties);
                System.out.println();
                System.out.println("BEGIN JIB JSON: SYNCMAP/1");
                System.out.println(syncMapJson);
            }
            catch (Exception ex) {
                throw new MojoExecutionException("Failed to generate a Jib file map for sync with Skaffold", ex);
            }
        }
    }
}

