/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.registry;

import com.google.cloud.tools.jib.api.InsecureRegistryException;
import com.google.cloud.tools.jib.api.LogEvent;
import com.google.cloud.tools.jib.api.RegistryException;
import com.google.cloud.tools.jib.api.RegistryUnauthorizedException;
import com.google.cloud.tools.jib.event.EventHandlers;
import com.google.cloud.tools.jib.global.JibSystemProperties;
import com.google.cloud.tools.jib.http.Authorization;
import com.google.cloud.tools.jib.http.FailoverHttpClient;
import com.google.cloud.tools.jib.http.Request;
import com.google.cloud.tools.jib.http.Response;
import com.google.cloud.tools.jib.http.ResponseException;
import com.google.cloud.tools.jib.json.JsonTemplateMapper;
import com.google.cloud.tools.jib.registry.RegistryCredentialsNotSentException;
import com.google.cloud.tools.jib.registry.RegistryEndpointProvider;
import com.google.cloud.tools.jib.registry.RegistryEndpointRequestProperties;
import com.google.cloud.tools.jib.registry.RegistryErrorException;
import com.google.cloud.tools.jib.registry.RegistryErrorExceptionBuilder;
import com.google.cloud.tools.jib.registry.json.ErrorEntryTemplate;
import com.google.cloud.tools.jib.registry.json.ErrorResponseTemplate;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.net.URL;
import java.util.Locale;
import javax.annotation.Nullable;
import javax.net.ssl.SSLException;

class RegistryEndpointCaller<T> {
    @VisibleForTesting
    static final int STATUS_CODE_PERMANENT_REDIRECT = 308;
    private final EventHandlers eventHandlers;
    private final String userAgent;
    private final RegistryEndpointProvider<T> registryEndpointProvider;
    @Nullable
    private final Authorization authorization;
    private final RegistryEndpointRequestProperties registryEndpointRequestProperties;
    private final FailoverHttpClient httpClient;

    @VisibleForTesting
    static boolean isBrokenPipe(IOException original) {
        Throwable exception = original;
        while (exception != null) {
            String message = exception.getMessage();
            if (message != null && message.toLowerCase(Locale.US).contains("broken pipe")) {
                return true;
            }
            if ((exception = exception.getCause()) != original) continue;
            return false;
        }
        return false;
    }

    @VisibleForTesting
    RegistryEndpointCaller(EventHandlers eventHandlers, String userAgent, RegistryEndpointProvider<T> registryEndpointProvider, @Nullable Authorization authorization, RegistryEndpointRequestProperties registryEndpointRequestProperties, FailoverHttpClient httpClient) {
        this.eventHandlers = eventHandlers;
        this.userAgent = userAgent;
        this.registryEndpointProvider = registryEndpointProvider;
        this.authorization = authorization;
        this.registryEndpointRequestProperties = registryEndpointRequestProperties;
        this.httpClient = httpClient;
    }

    T call() throws IOException, RegistryException {
        String apiRouteBase = "https://" + this.registryEndpointRequestProperties.getServerUrl() + "/v2/";
        URL initialRequestUrl = this.registryEndpointProvider.getApiRoute(apiRouteBase);
        return this.call(initialRequestUrl);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private T call(URL url) throws IOException, RegistryException {
        String serverUrl = this.registryEndpointRequestProperties.getServerUrl();
        String imageName = this.registryEndpointRequestProperties.getImageName();
        Request.Builder requestBuilder = Request.builder().setUserAgent(this.userAgent).setHttpTimeout(JibSystemProperties.getHttpTimeout()).setAccept(this.registryEndpointProvider.getAccept()).setBody(this.registryEndpointProvider.getContent()).setAuthorization(this.authorization);
        try (Response response = this.httpClient.call(this.registryEndpointProvider.getHttpMethod(), url, requestBuilder.build());){
            T t = this.registryEndpointProvider.handleResponse(response);
            return t;
        }
        catch (ResponseException ex) {
            try {
                return this.registryEndpointProvider.handleHttpResponseException(ex);
            }
            catch (ResponseException responseException) {
                if (responseException.getStatusCode() == 400) throw this.newRegistryErrorException(responseException);
                if (responseException.getStatusCode() == 404) throw this.newRegistryErrorException(responseException);
                if (responseException.getStatusCode() == 405) {
                    throw this.newRegistryErrorException(responseException);
                }
                if (responseException.getStatusCode() == 403) {
                    throw new RegistryUnauthorizedException(serverUrl, imageName, responseException);
                }
                if (responseException.getStatusCode() != 401) throw responseException;
                if (!responseException.requestAuthorizationCleared()) throw new RegistryUnauthorizedException(serverUrl, imageName, responseException);
                throw new RegistryCredentialsNotSentException(serverUrl, imageName);
            }
        }
        catch (IOException ex) {
            this.logError("I/O error for image [" + serverUrl + "/" + imageName + "]:");
            this.logError("    " + ex.getClass().getName());
            this.logError("    " + (ex.getMessage() == null ? "(null exception message)" : ex.getMessage()));
            this.logErrorIfBrokenPipe(ex);
            if (!(ex instanceof SSLException)) throw ex;
            throw new InsecureRegistryException(url, (Throwable)ex);
        }
    }

    @VisibleForTesting
    RegistryErrorException newRegistryErrorException(ResponseException responseException) {
        RegistryErrorExceptionBuilder registryErrorExceptionBuilder = new RegistryErrorExceptionBuilder(this.registryEndpointProvider.getActionDescription(), responseException);
        try {
            ErrorResponseTemplate errorResponse = JsonTemplateMapper.readJson(responseException.getContent(), ErrorResponseTemplate.class);
            for (ErrorEntryTemplate errorEntry : errorResponse.getErrors()) {
                registryErrorExceptionBuilder.addReason(errorEntry);
            }
        }
        catch (IOException ex) {
            registryErrorExceptionBuilder.addReason("registry returned error code " + responseException.getStatusCode() + "; possible causes include invalid or wrong reference. Actual error output follows:\n" + responseException.getContent() + "\n");
        }
        return registryErrorExceptionBuilder.build();
    }

    private void logError(String message) {
        this.eventHandlers.dispatch(LogEvent.error("\u001b[31;1m" + message + "\u001b[0m"));
    }

    private void logErrorIfBrokenPipe(IOException ex) {
        if (RegistryEndpointCaller.isBrokenPipe(ex)) {
            this.logError("broken pipe: the server shut down the connection. Check the server log if possible. This could also be a proxy issue. For example, a proxy may prevent sending packets that are too large.");
        }
    }
}

