/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.plugins.common.logging;

import com.google.cloud.tools.jib.api.LogEvent;
import com.google.cloud.tools.jib.plugins.common.logging.AnsiLoggerWithFooter;
import com.google.cloud.tools.jib.plugins.common.logging.ConsoleLogger;
import com.google.cloud.tools.jib.plugins.common.logging.PlainConsoleLogger;
import com.google.cloud.tools.jib.plugins.common.logging.SingleThreadedExecutor;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import java.util.function.Consumer;
import java.util.function.Function;

public class ConsoleLoggerBuilder {
    private final ImmutableMap.Builder<LogEvent.Level, Consumer<String>> messageConsumers = ImmutableMap.builder();
    private final ConsoleLoggerFactory consoleLoggerFactory;

    public static ConsoleLoggerBuilder rich(SingleThreadedExecutor singleThreadedExecutor, boolean enableTwoCursorUpJump) {
        return new ConsoleLoggerBuilder(messageConsumerMap -> new AnsiLoggerWithFooter((ImmutableMap<LogEvent.Level, Consumer<String>>)messageConsumerMap, singleThreadedExecutor, enableTwoCursorUpJump));
    }

    public static ConsoleLoggerBuilder plain(SingleThreadedExecutor singleThreadedExecutor) {
        return new ConsoleLoggerBuilder(messageConsumerMap -> new PlainConsoleLogger((ImmutableMap<LogEvent.Level, Consumer<String>>)messageConsumerMap, singleThreadedExecutor));
    }

    @VisibleForTesting
    ConsoleLoggerBuilder(ConsoleLoggerFactory consoleLoggerFactory) {
        this.consoleLoggerFactory = consoleLoggerFactory;
    }

    public ConsoleLoggerBuilder lifecycle(Consumer<String> messageConsumer) {
        this.messageConsumers.put((Object)LogEvent.Level.LIFECYCLE, messageConsumer);
        return this;
    }

    public ConsoleLoggerBuilder progress(Consumer<String> messageConsumer) {
        this.messageConsumers.put((Object)LogEvent.Level.PROGRESS, messageConsumer);
        return this;
    }

    public ConsoleLoggerBuilder debug(Consumer<String> messageConsumer) {
        this.messageConsumers.put((Object)LogEvent.Level.DEBUG, messageConsumer);
        return this;
    }

    public ConsoleLoggerBuilder error(Consumer<String> messageConsumer) {
        this.messageConsumers.put((Object)LogEvent.Level.ERROR, messageConsumer);
        return this;
    }

    public ConsoleLoggerBuilder info(Consumer<String> messageConsumer) {
        this.messageConsumers.put((Object)LogEvent.Level.INFO, messageConsumer);
        return this;
    }

    public ConsoleLoggerBuilder warn(Consumer<String> messageConsumer) {
        this.messageConsumers.put((Object)LogEvent.Level.WARN, messageConsumer);
        return this;
    }

    public ConsoleLogger build() {
        return (ConsoleLogger)this.consoleLoggerFactory.apply(this.messageConsumers.build());
    }

    @FunctionalInterface
    @VisibleForTesting
    static interface ConsoleLoggerFactory
    extends Function<ImmutableMap<LogEvent.Level, Consumer<String>>, ConsoleLogger> {
    }
}

