/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.image.json;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.cloud.tools.jib.json.JsonTemplate;
import java.time.Instant;
import java.util.Objects;
import javax.annotation.Nullable;

@JsonIgnoreProperties(ignoreUnknown=true)
public class HistoryEntry
implements JsonTemplate {
    @JsonProperty(value="created")
    @Nullable
    private String creationTimestamp;
    @JsonProperty(value="author")
    @Nullable
    private String author;
    @JsonProperty(value="created_by")
    @Nullable
    private String createdBy;
    @JsonProperty(value="comment")
    @Nullable
    private String comment;
    @JsonProperty(value="empty_layer")
    @Nullable
    private Boolean emptyLayer;

    public static Builder builder() {
        return new Builder();
    }

    public HistoryEntry() {
    }

    private HistoryEntry(@Nullable String creationTimestamp, @Nullable String author, @Nullable String createdBy, @Nullable String comment, @Nullable Boolean emptyLayer) {
        this.author = author;
        this.creationTimestamp = creationTimestamp;
        this.createdBy = createdBy;
        this.comment = comment;
        this.emptyLayer = emptyLayer;
    }

    @JsonIgnore
    public boolean hasCorrespondingLayer() {
        return this.emptyLayer == null ? false : this.emptyLayer;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof HistoryEntry) {
            HistoryEntry otherHistory = (HistoryEntry)other;
            return Objects.equals(otherHistory.creationTimestamp, this.creationTimestamp) && Objects.equals(otherHistory.author, this.author) && Objects.equals(otherHistory.createdBy, this.createdBy) && Objects.equals(otherHistory.comment, this.comment) && Objects.equals(otherHistory.emptyLayer, this.emptyLayer);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.author, this.creationTimestamp, this.createdBy, this.comment, this.emptyLayer);
    }

    public String toString() {
        return this.createdBy == null ? "" : this.createdBy;
    }

    public static class Builder {
        @Nullable
        private Instant creationTimestamp;
        @Nullable
        private String author;
        @Nullable
        private String createdBy;
        @Nullable
        private String comment;
        @Nullable
        private Boolean emptyLayer;

        public Builder setCreationTimestamp(Instant creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
            return this;
        }

        public Builder setAuthor(String author) {
            this.author = author;
            return this;
        }

        public Builder setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public Builder setComment(String comment) {
            this.comment = comment;
            return this;
        }

        public Builder setEmptyLayer(Boolean emptyLayer) {
            this.emptyLayer = emptyLayer;
            return this;
        }

        public HistoryEntry build() {
            return new HistoryEntry(this.creationTimestamp == null ? null : this.creationTimestamp.toString(), this.author, this.createdBy, this.comment, this.emptyLayer);
        }

        private Builder() {
        }
    }
}

