/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.builder.steps;

import com.google.cloud.tools.jib.api.DescriptorDigest;
import com.google.cloud.tools.jib.blob.BlobDescriptor;
import com.google.cloud.tools.jib.hash.Digests;
import com.google.cloud.tools.jib.image.Image;
import com.google.cloud.tools.jib.image.json.BuildableManifestTemplate;
import com.google.cloud.tools.jib.image.json.ImageToJsonTranslator;
import java.io.IOException;
import java.util.Objects;

public class BuildResult {
    private final DescriptorDigest imageDigest;
    private final DescriptorDigest imageId;
    private final Boolean imagePushed;

    static BuildResult fromImage(Image image, Class<? extends BuildableManifestTemplate> targetFormat) throws IOException {
        ImageToJsonTranslator imageToJsonTranslator = new ImageToJsonTranslator(image);
        BlobDescriptor containerConfigurationBlobDescriptor = Digests.computeDigest(imageToJsonTranslator.getContainerConfiguration());
        BuildableManifestTemplate manifestTemplate = imageToJsonTranslator.getManifestTemplate(targetFormat, containerConfigurationBlobDescriptor);
        DescriptorDigest imageDigest = Digests.computeJsonDigest(manifestTemplate);
        DescriptorDigest imageId = containerConfigurationBlobDescriptor.getDigest();
        return new BuildResult(imageDigest, imageId, false);
    }

    BuildResult(DescriptorDigest imageDigest, DescriptorDigest imageId, boolean imagePushed) {
        this.imageDigest = imageDigest;
        this.imageId = imageId;
        this.imagePushed = imagePushed;
    }

    public DescriptorDigest getImageDigest() {
        return this.imageDigest;
    }

    public DescriptorDigest getImageId() {
        return this.imageId;
    }

    public boolean isImagePushed() {
        return this.imagePushed;
    }

    public int hashCode() {
        return Objects.hash(this.imageDigest, this.imageId);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof BuildResult)) {
            return false;
        }
        BuildResult otherBuildResult = (BuildResult)other;
        return this.imageDigest.equals(otherBuildResult.imageDigest) && this.imageId.equals(otherBuildResult.imageId) && this.imagePushed.equals(otherBuildResult.imagePushed);
    }
}

