/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.event;

import com.google.cloud.tools.jib.api.JibEvent;
import com.google.cloud.tools.jib.event.Handler;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.function.Consumer;

public class EventHandlers {
    public static final EventHandlers NONE = new Builder().build();
    private final ImmutableMultimap<Class<? extends JibEvent>, Handler<? extends JibEvent>> handlers;

    private EventHandlers(Multimap<Class<? extends JibEvent>, Handler<? extends JibEvent>> handlers) {
        this.handlers = ImmutableMultimap.copyOf(handlers);
    }

    public static Builder builder() {
        return new Builder();
    }

    public void dispatch(JibEvent jibEvent) {
        if (this.handlers.isEmpty()) {
            return;
        }
        this.handlers.get(JibEvent.class).forEach(handler -> handler.handle(jibEvent));
        this.handlers.get(jibEvent.getClass()).forEach(handler -> handler.handle(jibEvent));
    }

    @VisibleForTesting
    ImmutableMultimap<Class<? extends JibEvent>, Handler<? extends JibEvent>> getHandlers() {
        return ImmutableMultimap.copyOf(this.handlers);
    }

    public static class Builder {
        private final Multimap<Class<? extends JibEvent>, Handler<? extends JibEvent>> handlers = ArrayListMultimap.create();

        public <E extends JibEvent> Builder add(Class<E> eventType, Consumer<? super E> eventConsumer) {
            this.handlers.put(eventType, new Handler<E>(eventType, eventConsumer));
            return this;
        }

        public EventHandlers build() {
            return new EventHandlers(this.handlers);
        }
    }
}

