/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.plugins.common;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.google.cloud.tools.jib.api.LogEvent;
import com.google.cloud.tools.jib.http.FailoverHttpClient;
import com.google.cloud.tools.jib.http.Request;
import com.google.cloud.tools.jib.http.Response;
import com.google.cloud.tools.jib.json.JsonTemplate;
import com.google.cloud.tools.jib.json.JsonTemplateMapper;
import com.google.cloud.tools.jib.plugins.common.globalconfig.GlobalConfig;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.time.Instant;
import java.time.format.DateTimeParseException;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.function.Consumer;

public class UpdateChecker {
    private static final String LAST_UPDATE_CHECK_FILENAME = "lastUpdateCheck";

    public static Future<Optional<String>> checkForUpdate(ExecutorService executorService, String versionUrl, String toolName, String toolVersion, Consumer<LogEvent> log) {
        return executorService.submit(() -> UpdateChecker.performUpdateCheck(GlobalConfig.getConfigDir(), toolVersion, versionUrl, toolName, log));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @VisibleForTesting
    static Optional<String> performUpdateCheck(Path configDir, String currentVersion, String versionUrl, String toolName, Consumer<LogEvent> log) {
        Path lastUpdateCheck = configDir.resolve(LAST_UPDATE_CHECK_FILENAME);
        try {
            if (Files.exists(lastUpdateCheck, new LinkOption[0])) {
                try {
                    String fileContents = new String(Files.readAllBytes(lastUpdateCheck), StandardCharsets.UTF_8);
                    Instant modifiedTime = Instant.parse(fileContents);
                    if (modifiedTime.plus(Duration.ofDays(1L)).isAfter(Instant.now())) {
                        return Optional.empty();
                    }
                }
                catch (IOException | DateTimeParseException ex) {
                    log.accept(LogEvent.debug("Failed to read lastUpdateCheck; " + ex.getMessage()));
                    Files.delete(lastUpdateCheck);
                }
            }
            FailoverHttpClient httpClient = new FailoverHttpClient(true, false, ignored -> {});
            try {
                Response response = httpClient.get(new URL(versionUrl), Request.builder().setHttpTimeout(3000).setUserAgent("jib " + currentVersion + " " + toolName).build());
                VersionJsonTemplate version = JsonTemplateMapper.readJson(response.getBody(), VersionJsonTemplate.class);
                Path lastUpdateCheckTemp = Files.createTempFile(configDir, LAST_UPDATE_CHECK_FILENAME, null, new FileAttribute[0]);
                lastUpdateCheckTemp.toFile().deleteOnExit();
                Files.write(lastUpdateCheckTemp, Instant.now().toString().getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                Files.move(lastUpdateCheckTemp, lastUpdateCheck, StandardCopyOption.REPLACE_EXISTING);
                if (currentVersion.equals(version.latest)) {
                    Optional<String> optional = Optional.empty();
                    return optional;
                }
                Optional<String> optional = Optional.of(version.latest);
                return optional;
            }
            finally {
                httpClient.shutDown();
            }
        }
        catch (IOException ex) {
            log.accept(LogEvent.debug("Update check failed; " + ex.getMessage()));
            return Optional.empty();
        }
    }

    public static Optional<String> finishUpdateCheck(Future<Optional<String>> updateMessageFuture) {
        if (updateMessageFuture.isDone()) {
            try {
                return updateMessageFuture.get();
            }
            catch (InterruptedException | ExecutionException exception) {
                // empty catch block
            }
        }
        updateMessageFuture.cancel(true);
        return Optional.empty();
    }

    private UpdateChecker() {
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    private static class VersionJsonTemplate
    implements JsonTemplate {
        private String latest = "";

        private VersionJsonTemplate() {
        }
    }
}

