/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.builder.steps;

import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.google.cloud.tools.jib.api.DescriptorDigest;
import com.google.cloud.tools.jib.api.DockerClient;
import com.google.cloud.tools.jib.api.ImageDetails;
import com.google.cloud.tools.jib.api.ImageReference;
import com.google.cloud.tools.jib.blob.Blob;
import com.google.cloud.tools.jib.blob.BlobDescriptor;
import com.google.cloud.tools.jib.blob.Blobs;
import com.google.cloud.tools.jib.builder.ProgressEventDispatcher;
import com.google.cloud.tools.jib.builder.TimerEventDispatcher;
import com.google.cloud.tools.jib.builder.steps.PlatformChecker;
import com.google.cloud.tools.jib.builder.steps.PreparedLayer;
import com.google.cloud.tools.jib.builder.steps.PullBaseImageStep;
import com.google.cloud.tools.jib.cache.Cache;
import com.google.cloud.tools.jib.cache.CacheCorruptedException;
import com.google.cloud.tools.jib.cache.CachedLayer;
import com.google.cloud.tools.jib.configuration.BuildContext;
import com.google.cloud.tools.jib.docker.json.DockerManifestEntryTemplate;
import com.google.cloud.tools.jib.event.progress.ThrottledAccumulatingConsumer;
import com.google.cloud.tools.jib.filesystem.TempDirectoryProvider;
import com.google.cloud.tools.jib.hash.Digests;
import com.google.cloud.tools.jib.http.NotifyingOutputStream;
import com.google.cloud.tools.jib.image.LayerCountMismatchException;
import com.google.cloud.tools.jib.image.json.ContainerConfigurationTemplate;
import com.google.cloud.tools.jib.image.json.JsonToImageTranslator;
import com.google.cloud.tools.jib.image.json.V22ManifestTemplate;
import com.google.cloud.tools.jib.json.JsonTemplateMapper;
import com.google.cloud.tools.jib.tar.TarExtractor;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.io.ByteStreams;
import com.google.common.util.concurrent.Futures;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.DigestException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.zip.GZIPOutputStream;

public class LocalBaseImageSteps {
    private LocalBaseImageSteps() {
    }

    @VisibleForTesting
    static boolean isGzipped(Path path) throws IOException {
        try (InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);){
            inputStream.mark(2);
            int magic = inputStream.read() & 0xFF | inputStream.read() << 8 & 0xFF00;
            boolean bl = magic == 35615;
            return bl;
        }
    }

    static Callable<LocalImage> retrieveDockerDaemonLayersStep(BuildContext buildContext, ProgressEventDispatcher.Factory progressEventDispatcherFactory, DockerClient dockerClient, TempDirectoryProvider tempDirectoryProvider) {
        return () -> {
            ImageReference imageReference = buildContext.getBaseImageConfiguration().getImage();
            try (ProgressEventDispatcher progressEventDispatcher = progressEventDispatcherFactory.create("processing base image " + imageReference, 2L);){
                ImageDetails dockerImageDetails;
                TimerEventDispatcher ignored;
                block24: {
                    ignored = new TimerEventDispatcher(buildContext.getEventHandlers(), "Saving " + imageReference + " from Docker daemon");
                    try {
                        dockerImageDetails = dockerClient.inspect(imageReference);
                        Optional<LocalImage> cachedImage = LocalBaseImageSteps.getCachedDockerImage(buildContext.getBaseImageLayersCache(), dockerImageDetails);
                        if (!cachedImage.isPresent()) break block24;
                        PlatformChecker.checkManifestPlatform(buildContext, cachedImage.get().configurationTemplate);
                        LocalImage localImage = cachedImage.get();
                        ignored.close();
                        return localImage;
                    }
                    catch (Throwable throwable) {
                        try {
                            ignored.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                Path tarPath = tempDirectoryProvider.newDirectory().resolve("out.tar");
                long size = dockerImageDetails.getSize();
                try (ProgressEventDispatcher dockerProgress = progressEventDispatcher.newChildProducer().create("saving base image " + imageReference, size);
                     ThrottledAccumulatingConsumer throttledProgressReporter = new ThrottledAccumulatingConsumer(dockerProgress::dispatchProgress);){
                    dockerClient.save(imageReference, tarPath, throttledProgressReporter);
                }
                LocalImage localImage = LocalBaseImageSteps.cacheDockerImageTar(buildContext, tarPath, progressEventDispatcher.newChildProducer(), tempDirectoryProvider);
                PlatformChecker.checkManifestPlatform(buildContext, localImage.configurationTemplate);
                LocalImage localImage2 = localImage;
                ignored.close();
                return localImage2;
            }
        };
    }

    static Callable<LocalImage> retrieveTarLayersStep(BuildContext buildContext, ProgressEventDispatcher.Factory progressEventDispatcherFactory, Path tarPath, TempDirectoryProvider tempDirectoryProvider) {
        return () -> {
            LocalImage localImage = LocalBaseImageSteps.cacheDockerImageTar(buildContext, tarPath, progressEventDispatcherFactory, tempDirectoryProvider);
            PlatformChecker.checkManifestPlatform(buildContext, localImage.configurationTemplate);
            return localImage;
        };
    }

    static Callable<PullBaseImageStep.ImagesAndRegistryClient> returnImageAndRegistryClientStep(List<PreparedLayer> layers, ContainerConfigurationTemplate configurationTemplate) {
        return () -> {
            V22ManifestTemplate v22Manifest = new V22ManifestTemplate();
            for (PreparedLayer layer : layers) {
                BlobDescriptor descriptor = layer.getBlobDescriptor();
                v22Manifest.addLayer(descriptor.getSize(), descriptor.getDigest());
            }
            BlobDescriptor configDescriptor = Digests.computeDigest(configurationTemplate);
            v22Manifest.setContainerConfiguration(configDescriptor.getSize(), configDescriptor.getDigest());
            return new PullBaseImageStep.ImagesAndRegistryClient(Collections.singletonList(JsonToImageTranslator.toImage(v22Manifest, configurationTemplate)), null);
        };
    }

    @VisibleForTesting
    static Optional<LocalImage> getCachedDockerImage(Cache cache, ImageDetails dockerImageDetails) throws DigestException, IOException, CacheCorruptedException {
        Optional<ContainerConfigurationTemplate> cachedConfig = cache.retrieveLocalConfig(dockerImageDetails.getImageId());
        if (!cachedConfig.isPresent()) {
            return Optional.empty();
        }
        ArrayList<Future<PreparedLayer>> cachedLayers = new ArrayList<Future<PreparedLayer>>();
        for (DescriptorDigest diffId : dockerImageDetails.getDiffIds()) {
            Optional<CachedLayer> cachedLayer = cache.retrieveTarLayer(diffId);
            if (!cachedLayer.isPresent()) {
                return Optional.empty();
            }
            CachedLayer layer = cachedLayer.get();
            cachedLayers.add((Future<PreparedLayer>)Futures.immediateFuture((Object)new PreparedLayer.Builder(layer).build()));
        }
        return Optional.of(new LocalImage(cachedLayers, cachedConfig.get()));
    }

    @VisibleForTesting
    static LocalImage cacheDockerImageTar(BuildContext buildContext, Path tarPath, ProgressEventDispatcher.Factory progressEventDispatcherFactory, TempDirectoryProvider tempDirectoryProvider) throws IOException, LayerCountMismatchException {
        ExecutorService executorService = buildContext.getExecutorService();
        Path destination = tempDirectoryProvider.newDirectory();
        try (TimerEventDispatcher ignored = new TimerEventDispatcher(buildContext.getEventHandlers(), "Extracting tar " + tarPath + " into " + destination);){
            DockerManifestEntryTemplate loadManifest;
            TarExtractor.extract(tarPath, destination);
            try (InputStream manifestStream = Files.newInputStream(destination.resolve("manifest.json"), new OpenOption[0]);){
                loadManifest = ((DockerManifestEntryTemplate[])((JsonMapper)((JsonMapper.Builder)JsonMapper.builder().configure(MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES, true)).build()).readValue(manifestStream, DockerManifestEntryTemplate[].class))[0];
            }
            Path configPath = destination.resolve(loadManifest.getConfig());
            ContainerConfigurationTemplate configurationTemplate = JsonTemplateMapper.readJsonFromFile(configPath, ContainerConfigurationTemplate.class);
            BlobDescriptor originalConfigDescriptor = Blobs.from(configPath).writeTo(ByteStreams.nullOutputStream());
            List<String> layerFiles = loadManifest.getLayerFiles();
            if (configurationTemplate.getLayerCount() != layerFiles.size()) {
                throw new LayerCountMismatchException("Invalid base image format: manifest contains " + layerFiles.size() + " layers, but container configuration contains " + configurationTemplate.getLayerCount() + " layers");
            }
            buildContext.getBaseImageLayersCache().writeLocalConfig(originalConfigDescriptor.getDigest(), configurationTemplate);
            boolean layersAreCompressed = !layerFiles.isEmpty() && LocalBaseImageSteps.isGzipped(destination.resolve(layerFiles.get(0)));
            ProgressEventDispatcher progressEventDispatcher = progressEventDispatcherFactory.create("processing base image layers", layerFiles.size());
            try {
                ArrayList<Future<PreparedLayer>> preparedLayers = new ArrayList<Future<PreparedLayer>>();
                for (int index = 0; index < layerFiles.size(); ++index) {
                    Path layerFile = destination.resolve(layerFiles.get(index));
                    DescriptorDigest diffId = configurationTemplate.getLayerDiffId(index);
                    ProgressEventDispatcher.Factory layerProgressDispatcherFactory = progressEventDispatcher.newChildProducer();
                    preparedLayers.add(executorService.submit(() -> LocalBaseImageSteps.compressAndCacheTarLayer(buildContext.getBaseImageLayersCache(), diffId, layerFile, layersAreCompressed, layerProgressDispatcherFactory)));
                }
                LocalImage localImage = new LocalImage(preparedLayers, configurationTemplate);
                if (progressEventDispatcher != null) {
                    progressEventDispatcher.close();
                }
                return localImage;
            }
            catch (Throwable throwable) {
                if (progressEventDispatcher != null) {
                    try {
                        progressEventDispatcher.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
    }

    private static PreparedLayer compressAndCacheTarLayer(Cache cache, DescriptorDigest diffId, Path layerFile, boolean layersAreCompressed, ProgressEventDispatcher.Factory progressEventDispatcherFactory) throws IOException, CacheCorruptedException {
        try (ProgressEventDispatcher childDispatcher = progressEventDispatcherFactory.create("compressing layer " + diffId, Files.size(layerFile));){
            ThrottledAccumulatingConsumer throttledProgressReporter;
            block16: {
                block15: {
                    throttledProgressReporter = new ThrottledAccumulatingConsumer(childDispatcher::dispatchProgress);
                    try {
                        Optional<CachedLayer> optionalLayer = cache.retrieveTarLayer(diffId);
                        if (!optionalLayer.isPresent()) break block15;
                        PreparedLayer preparedLayer = new PreparedLayer.Builder(optionalLayer.get()).build();
                        throttledProgressReporter.close();
                        return preparedLayer;
                    }
                    catch (Throwable throwable) {
                        try {
                            throttledProgressReporter.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                if (!layersAreCompressed) break block16;
                PreparedLayer preparedLayer = new PreparedLayer.Builder(cache.writeTarLayer(diffId, Blobs.from(layerFile))).build();
                throttledProgressReporter.close();
                return preparedLayer;
            }
            Blob compressedBlob = Blobs.from(outputStream -> {
                try (GZIPOutputStream compressorStream = new GZIPOutputStream(outputStream);
                     NotifyingOutputStream notifyingOutputStream = new NotifyingOutputStream(compressorStream, throttledProgressReporter);){
                    Blobs.from(layerFile).writeTo(notifyingOutputStream);
                }
            }, true);
            PreparedLayer preparedLayer = new PreparedLayer.Builder(cache.writeTarLayer(diffId, compressedBlob)).build();
            throttledProgressReporter.close();
            return preparedLayer;
        }
    }

    static class LocalImage {
        final List<Future<PreparedLayer>> layers;
        final ContainerConfigurationTemplate configurationTemplate;

        LocalImage(List<Future<PreparedLayer>> layers, ContainerConfigurationTemplate configurationTemplate) {
            this.layers = layers;
            this.configurationTemplate = configurationTemplate;
        }
    }
}

