/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.trace.service;

import com.google.auth.Credentials;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.cloud.trace.GrpcSpanContextHandler;
import com.google.cloud.trace.SpanContextHandler;
import com.google.cloud.trace.SpanContextHandlerTracer;
import com.google.cloud.trace.Tracer;
import com.google.cloud.trace.core.JavaTimestampFactory;
import com.google.cloud.trace.core.RateLimitingTraceOptionsFactory;
import com.google.cloud.trace.core.SpanContextFactory;
import com.google.cloud.trace.core.TimestampFactory;
import com.google.cloud.trace.core.TraceOptionsFactory;
import com.google.cloud.trace.grpc.v1.GrpcTraceConsumer;
import com.google.cloud.trace.service.TraceService;
import com.google.cloud.trace.sink.TraceSink;
import com.google.cloud.trace.v1.TraceSinkV1;
import com.google.cloud.trace.v1.consumer.ScheduledBufferingTraceConsumer;
import com.google.cloud.trace.v1.consumer.TraceConsumer;
import com.google.cloud.trace.v1.producer.TraceProducer;
import com.google.cloud.trace.v1.util.RoughTraceSizer;
import com.google.cloud.trace.v1.util.Sizer;
import java.io.IOException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class TraceGrpcApiService
implements TraceService {
    private final Tracer tracer;
    private final SpanContextHandler handler;
    private final SpanContextFactory factory;

    public static Builder builder() {
        return new Builder();
    }

    private TraceGrpcApiService(String projectId, TraceOptionsFactory optionsFactory, int bufferSize, int scheduledDelay, GoogleCredentials credentials, ScheduledExecutorService executorService) throws IOException {
        TraceProducer traceProducer = new TraceProducer();
        GrpcTraceConsumer traceConsumer = GrpcTraceConsumer.createWithCredentials((Credentials)credentials);
        traceConsumer = new ScheduledBufferingTraceConsumer((TraceConsumer)traceConsumer, (Sizer)new RoughTraceSizer(), bufferSize, scheduledDelay, executorService);
        TraceSinkV1 traceSink = new TraceSinkV1(projectId, traceProducer, (TraceConsumer)traceConsumer);
        this.factory = new SpanContextFactory(optionsFactory);
        this.handler = new GrpcSpanContextHandler(this.factory.initialContext());
        this.tracer = new SpanContextHandlerTracer((TraceSink)traceSink, this.handler, this.factory, (TimestampFactory)new JavaTimestampFactory());
    }

    public Tracer getTracer() {
        return this.tracer;
    }

    public SpanContextHandler getSpanContextHandler() {
        return this.handler;
    }

    public SpanContextFactory getSpanContextFactory() {
        return this.factory;
    }

    public static class Builder {
        private String projectId;
        private TraceOptionsFactory optionsFactory = new RateLimitingTraceOptionsFactory(1.0, false);
        private int bufferSize = 32768;
        private int scheduledDelay = 15;
        private GoogleCredentials credentials;
        private ScheduledExecutorService executorService;

        private Builder() {
        }

        public Builder setProjectId(String projectId) {
            if (projectId == null || projectId.isEmpty()) {
                throw new IllegalArgumentException("Project id must not be empty.");
            }
            this.projectId = projectId;
            return this;
        }

        public Builder setTraceOptionsFactory(TraceOptionsFactory optionsFactory) {
            if (optionsFactory == null) {
                throw new IllegalArgumentException("TraceOptionsFactory must not be null.");
            }
            this.optionsFactory = optionsFactory;
            return this;
        }

        public Builder setBufferSize(int bufferSize) {
            if (bufferSize < 0) {
                throw new IllegalArgumentException("Buffer size must be >= 0.");
            }
            this.bufferSize = bufferSize;
            return this;
        }

        public Builder setScheduledDelay(int scheduledDelay) {
            this.scheduledDelay = scheduledDelay;
            return this;
        }

        public Builder setCredentials(GoogleCredentials credentials) {
            this.credentials = credentials;
            return this;
        }

        public Builder setScheduledExecutorService(ScheduledExecutorService scheduledExecutorService) {
            if (scheduledExecutorService == null) {
                throw new IllegalArgumentException("ScheduledExecutorService must not be null.");
            }
            this.executorService = scheduledExecutorService;
            return this;
        }

        public TraceGrpcApiService build() throws IOException {
            if (this.credentials == null) {
                this.credentials = GoogleCredentials.getApplicationDefault();
            }
            if (this.executorService == null) {
                ScheduledThreadPoolExecutor scheduledThreadPoolExecutor = new ScheduledThreadPoolExecutor(1);
                scheduledThreadPoolExecutor.setKeepAliveTime(this.scheduledDelay, TimeUnit.SECONDS);
                scheduledThreadPoolExecutor.allowCoreThreadTimeOut(true);
                this.executorService = scheduledThreadPoolExecutor;
            }
            return new TraceGrpcApiService(this.projectId, this.optionsFactory, this.bufferSize, this.scheduledDelay, this.credentials, this.executorService);
        }
    }
}

