/*
 * Decompiled with CFR 0.152.
 */
package dagger.android.processor;

import com.google.auto.common.AnnotationMirrors;
import com.google.auto.common.BasicAnnotationProcessor;
import com.google.auto.common.MoreElements;
import com.google.auto.common.MoreTypes;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.SetMultimap;
import dagger.Binds;
import dagger.android.ActivityKey;
import dagger.android.AndroidInjector;
import dagger.android.FragmentKey;
import java.lang.annotation.Annotation;
import java.util.Set;
import javax.annotation.processing.Messager;
import javax.inject.Qualifier;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;

final class AndroidMapKeyValidator
implements BasicAnnotationProcessor.ProcessingStep {
    private static final ImmutableBiMap<Class<? extends Annotation>, String> ANNOTATIONS_AND_FRAMEWORK_TYPES = ImmutableBiMap.of(ActivityKey.class, (Object)"android.app.Activity", FragmentKey.class, (Object)"android.app.Fragment", dagger.android.support.FragmentKey.class, (Object)"android.support.v4.app.Fragment");
    private static final String LINK_TO_DOCS = "google.github.io/dagger/android";
    private final Elements elements;
    private final Types types;
    private final Messager messager;

    AndroidMapKeyValidator(Elements elements, Types types, Messager messager) {
        this.elements = elements;
        this.types = types;
        this.messager = messager;
    }

    public Set<? extends Class<? extends Annotation>> annotations() {
        return ANNOTATIONS_AND_FRAMEWORK_TYPES.keySet();
    }

    public Set<Element> process(SetMultimap<Class<? extends Annotation>, Element> setMultimap) {
        setMultimap.forEach((clazz, element) -> this.validateMethod((Class<? extends Annotation>)clazz, MoreElements.asExecutable((Element)element)));
        return ImmutableSet.of();
    }

    private void validateMethod(Class<? extends Annotation> clazz, ExecutableElement executableElement) {
        if (!AnnotationMirrors.getAnnotatedAnnotations((Element)executableElement, Qualifier.class).isEmpty()) {
            return;
        }
        TypeMirror typeMirror = executableElement.getReturnType();
        if (!this.types.isAssignable(this.types.erasure(typeMirror), this.factoryElement().asType())) {
            return;
        }
        DeclaredType declaredType = this.injectorFactoryOf(this.types.getWildcardType(this.androidTypeForMapKey(clazz), null));
        if (!MoreTypes.equivalence().equivalent((Object)typeMirror, (Object)declaredType)) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, String.format("@%s methods should bind %s, not %s. See %s", clazz.getCanonicalName(), declaredType, typeMirror, LINK_TO_DOCS), executableElement);
        }
        if (MoreElements.isAnnotationPresent((Element)executableElement, Binds.class) && executableElement.getParameters().size() == 1) {
            this.validateMapKeyMatchesBindsParameter(clazz, executableElement);
        }
    }

    private void validateMapKeyMatchesBindsParameter(Class<? extends Annotation> clazz, ExecutableElement executableElement) {
        AnnotationMirror annotationMirror;
        TypeMirror typeMirror;
        TypeMirror typeMirror2 = ((VariableElement)Iterables.getOnlyElement(executableElement.getParameters())).asType();
        if (!this.types.isAssignable(typeMirror2, this.injectorFactoryOf(typeMirror = (TypeMirror)AnnotationMirrors.getAnnotationValue((AnnotationMirror)(annotationMirror = (AnnotationMirror)MoreElements.getAnnotationMirror((Element)executableElement, clazz).get()), (String)"value").getValue()))) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, String.format("%s does not implement AndroidInjector<%s>", typeMirror2, typeMirror), executableElement, annotationMirror);
        }
    }

    private DeclaredType androidTypeForMapKey(Class<? extends Annotation> clazz) {
        return this.types.getDeclaredType(this.elements.getTypeElement((CharSequence)ANNOTATIONS_AND_FRAMEWORK_TYPES.get(clazz)), new TypeMirror[0]);
    }

    private DeclaredType injectorFactoryOf(TypeMirror typeMirror) {
        return this.types.getDeclaredType(this.factoryElement(), typeMirror);
    }

    private TypeElement factoryElement() {
        return this.elements.getTypeElement(AndroidInjector.Factory.class.getCanonicalName());
    }
}

