/*
 * Decompiled with CFR 0.152.
 */
package dagger.android.processor;

import com.google.auto.common.AnnotationMirrors;
import com.google.auto.common.BasicAnnotationProcessor;
import com.google.auto.common.MoreElements;
import com.google.auto.common.MoreTypes;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.SetMultimap;
import dagger.Binds;
import dagger.MapKey;
import dagger.android.AndroidInjector;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.processing.Messager;
import javax.inject.Qualifier;
import javax.inject.Scope;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;

final class AndroidMapKeyValidator
implements BasicAnnotationProcessor.ProcessingStep {
    private static final String LINK_TO_DOCS = "google.github.io/dagger/android";
    private final Elements elements;
    private final Types types;
    private final Messager messager;
    private final ImmutableMap<Class<? extends Annotation>, TypeMirror> annotationsAndFrameworkTypes;

    AndroidMapKeyValidator(Elements elements, Types types, Messager messager) {
        this.elements = elements;
        this.types = types;
        this.messager = messager;
        this.annotationsAndFrameworkTypes = this.annotationsAndFrameworkTypes(elements);
    }

    private ImmutableMap<Class<? extends Annotation>, TypeMirror> annotationsAndFrameworkTypes(Elements elements) {
        return ImmutableMap.copyOf(Stream.of(elements.getPackageElement("dagger.android"), elements.getPackageElement("dagger.android.support")).filter(element -> element != null).flatMap(element -> element.getEnclosedElements().stream()).filter(element -> MoreElements.isAnnotationPresent((Element)element, MapKey.class)).filter(element -> element.getAnnotation(MapKey.class).unwrapValue()).flatMap(AndroidMapKeyValidator::classForAnnotationElement).collect(Collectors.toMap(key -> key, key -> AndroidMapKeyValidator.mapKeyValue(key, elements))));
    }

    private static Stream<Class<? extends Annotation>> classForAnnotationElement(Element element) {
        try {
            return Stream.of(Class.forName(MoreElements.asType((Element)element).getQualifiedName().toString()));
        }
        catch (ClassNotFoundException e) {
            return Stream.of(new Class[0]);
        }
    }

    private static TypeMirror mapKeyValue(Class<? extends Annotation> annotation, Elements elements) {
        List<ExecutableElement> mapKeyMethods = ElementFilter.methodsIn(elements.getTypeElement(annotation.getCanonicalName()).getEnclosedElements());
        TypeMirror returnType = ((ExecutableElement)Iterables.getOnlyElement(mapKeyMethods)).getReturnType();
        return ((WildcardType)Iterables.getOnlyElement(MoreTypes.asDeclared((TypeMirror)returnType).getTypeArguments())).getExtendsBound();
    }

    public Set<? extends Class<? extends Annotation>> annotations() {
        return this.annotationsAndFrameworkTypes.keySet();
    }

    public Set<Element> process(SetMultimap<Class<? extends Annotation>, Element> elementsByAnnotation) {
        elementsByAnnotation.forEach((annotation, element) -> this.validateMethod((Class<? extends Annotation>)annotation, MoreElements.asExecutable((Element)element)));
        return ImmutableSet.of();
    }

    private void validateMethod(Class<? extends Annotation> annotation, ExecutableElement method) {
        SuppressWarnings suppressedWarnings;
        if (!AnnotationMirrors.getAnnotatedAnnotations((Element)method, Qualifier.class).isEmpty()) {
            return;
        }
        TypeMirror returnType = method.getReturnType();
        if (!this.types.isAssignable(this.types.erasure(returnType), this.factoryElement().asType())) {
            return;
        }
        TypeMirror frameworkType = (TypeMirror)this.annotationsAndFrameworkTypes.get(annotation);
        if (!(AnnotationMirrors.getAnnotatedAnnotations((Element)method, Scope.class).isEmpty() || (suppressedWarnings = method.getAnnotation(SuppressWarnings.class)) != null && ImmutableSet.copyOf((Object[])suppressedWarnings.value()).contains((Object)"dagger.android.ScopedInjectorFactory"))) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, String.format("%s bindings should not be scoped. Scoping this method may leak instances of %s. ", AndroidInjector.Factory.class.getCanonicalName(), frameworkType), method);
        }
        DeclaredType intendedReturnType = this.injectorFactoryOf(this.types.getWildcardType(frameworkType, null));
        if (!MoreTypes.equivalence().equivalent((Object)returnType, (Object)intendedReturnType)) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, String.format("@%s methods should bind %s, not %s. See %s", annotation.getCanonicalName(), intendedReturnType, returnType, LINK_TO_DOCS), method);
        }
        if (MoreElements.isAnnotationPresent((Element)method, Binds.class) && method.getParameters().size() == 1) {
            this.validateMapKeyMatchesBindsParameter(annotation, method);
        }
    }

    private void validateMapKeyMatchesBindsParameter(Class<? extends Annotation> annotation, ExecutableElement method) {
        AnnotationMirror annotationMirror;
        TypeMirror mapKeyValue;
        TypeMirror parameterType = ((VariableElement)Iterables.getOnlyElement(method.getParameters())).asType();
        if (!this.types.isAssignable(parameterType, this.injectorFactoryOf(mapKeyValue = (TypeMirror)AnnotationMirrors.getAnnotationValue((AnnotationMirror)(annotationMirror = (AnnotationMirror)MoreElements.getAnnotationMirror((Element)method, annotation).get()), (String)"value").getValue()))) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, String.format("%s does not implement AndroidInjector<%s>", parameterType, mapKeyValue), method, annotationMirror);
        }
    }

    private DeclaredType injectorFactoryOf(TypeMirror implementationType) {
        return this.types.getDeclaredType(this.factoryElement(), implementationType);
    }

    private TypeElement factoryElement() {
        return this.elements.getTypeElement(AndroidInjector.Factory.class.getCanonicalName());
    }
}

