/*
 * Decompiled with CFR 0.152.
 */
package dagger.android.processor;

import com.google.common.base.CaseFormat;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.SetMultimap;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.WildcardTypeName;
import dagger.Binds;
import dagger.Module;
import dagger.Subcomponent;
import dagger.android.AndroidInjector;
import dagger.android.ContributesAndroidInjector;
import dagger.android.processor.AndroidInjectorDescriptor;
import dagger.multibindings.IntoMap;
import dagger.shaded.auto.common.BasicAnnotationProcessor;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.Set;
import javax.annotation.processing.Filer;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.util.ElementFilter;

final class ContributesAndroidInjectorGenerator
implements BasicAnnotationProcessor.ProcessingStep {
    private final Filer filer;
    private final AndroidInjectorDescriptor.Validator validator;

    ContributesAndroidInjectorGenerator(Filer filer, AndroidInjectorDescriptor.Validator validator) {
        this.filer = filer;
        this.validator = validator;
    }

    @Override
    public Set<? extends Class<? extends Annotation>> annotations() {
        return ImmutableSet.of(ContributesAndroidInjector.class);
    }

    public Set<Element> process(SetMultimap<Class<? extends Annotation>, Element> elementsByAnnotation) {
        for (ExecutableElement method : ElementFilter.methodsIn(elementsByAnnotation.values())) {
            this.validator.createIfValid(method).ifPresent(this::generate);
        }
        return ImmutableSet.of();
    }

    private void generate(AndroidInjectorDescriptor descriptor) {
        ClassName moduleName = descriptor.enclosingModule().topLevelClassName().peerClass(Joiner.on((char)'_').join((Iterable)descriptor.enclosingModule().simpleNames()) + "_" + CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, descriptor.methodName()));
        String baseName = descriptor.injectedType().simpleName();
        ClassName subcomponentName = moduleName.nestedClass(baseName + "Subcomponent");
        ClassName subcomponentBuilderName = subcomponentName.nestedClass("Builder");
        TypeSpec module = TypeSpec.classBuilder((ClassName)moduleName).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).addAnnotation(AnnotationSpec.builder(Module.class).addMember("subcomponents", "$T.class", new Object[]{subcomponentName}).build()).addMethod(this.bindAndroidInjectorFactory(descriptor, subcomponentBuilderName)).addType(this.subcomponent(descriptor, subcomponentName, subcomponentBuilderName)).addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PRIVATE}).build()).build();
        try {
            JavaFile.builder((String)moduleName.packageName(), (TypeSpec)module).skipJavaLangImports(true).build().writeTo(this.filer);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    private MethodSpec bindAndroidInjectorFactory(AndroidInjectorDescriptor descriptor, ClassName subcomponentBuilderName) {
        return MethodSpec.methodBuilder((String)"bindAndroidInjectorFactory").addAnnotation(Binds.class).addAnnotation(IntoMap.class).addAnnotation(descriptor.mapKeyAnnotation()).addModifiers(new Modifier[]{Modifier.ABSTRACT}).returns((TypeName)ContributesAndroidInjectorGenerator.parameterizedTypeName(AndroidInjector.Factory.class, new TypeName[]{WildcardTypeName.subtypeOf((TypeName)descriptor.frameworkType())})).addParameter((TypeName)subcomponentBuilderName, "builder", new Modifier[0]).build();
    }

    private TypeSpec subcomponent(AndroidInjectorDescriptor descriptor, ClassName subcomponentName, ClassName subcomponentBuilderName) {
        AnnotationSpec.Builder subcomponentAnnotation = AnnotationSpec.builder(Subcomponent.class);
        for (ClassName module : descriptor.modules()) {
            subcomponentAnnotation.addMember("modules", CodeBlock.of((String)"$T.class", (Object[])new Object[]{module}));
        }
        return TypeSpec.interfaceBuilder((ClassName)subcomponentName).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(subcomponentAnnotation.build()).addAnnotations(descriptor.scopes()).addSuperinterface((TypeName)ContributesAndroidInjectorGenerator.parameterizedTypeName(AndroidInjector.class, new TypeName[]{descriptor.injectedType()})).addType(this.subcomponentBuilder(descriptor, subcomponentBuilderName)).build();
    }

    private TypeSpec subcomponentBuilder(AndroidInjectorDescriptor descriptor, ClassName subcomponentBuilderName) {
        return TypeSpec.classBuilder((ClassName)subcomponentBuilderName).addAnnotation(Subcomponent.Builder.class).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT, Modifier.STATIC}).superclass((TypeName)ContributesAndroidInjectorGenerator.parameterizedTypeName(AndroidInjector.Builder.class, new TypeName[]{descriptor.injectedType()})).build();
    }

    private static ParameterizedTypeName parameterizedTypeName(Class<?> clazz, TypeName ... typeArguments) {
        return ParameterizedTypeName.get((ClassName)ClassName.get(clazz), (TypeName[])typeArguments);
    }
}

