
package dagger.android.processor;

import com.google.common.collect.ImmutableSet;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import javax.annotation.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
 final class AutoValue_AndroidInjectorDescriptor extends AndroidInjectorDescriptor {

  private final ClassName injectedType;
  private final ClassName frameworkType;
  private final ClassName mapKeyType;
  private final ImmutableSet<AnnotationSpec> scopes;
  private final ImmutableSet<ClassName> modules;
  private final ClassName enclosingModule;
  private final String methodName;

  private AutoValue_AndroidInjectorDescriptor(
      ClassName injectedType,
      ClassName frameworkType,
      ClassName mapKeyType,
      ImmutableSet<AnnotationSpec> scopes,
      ImmutableSet<ClassName> modules,
      ClassName enclosingModule,
      String methodName) {
    this.injectedType = injectedType;
    this.frameworkType = frameworkType;
    this.mapKeyType = mapKeyType;
    this.scopes = scopes;
    this.modules = modules;
    this.enclosingModule = enclosingModule;
    this.methodName = methodName;
  }

  @Override
  ClassName injectedType() {
    return injectedType;
  }

  @Override
  ClassName frameworkType() {
    return frameworkType;
  }

  @Override
  ClassName mapKeyType() {
    return mapKeyType;
  }

  @Override
  ImmutableSet<AnnotationSpec> scopes() {
    return scopes;
  }

  @Override
  ImmutableSet<ClassName> modules() {
    return modules;
  }

  @Override
  ClassName enclosingModule() {
    return enclosingModule;
  }

  @Override
  String methodName() {
    return methodName;
  }

  @Override
  public String toString() {
    return "AndroidInjectorDescriptor{"
        + "injectedType=" + injectedType + ", "
        + "frameworkType=" + frameworkType + ", "
        + "mapKeyType=" + mapKeyType + ", "
        + "scopes=" + scopes + ", "
        + "modules=" + modules + ", "
        + "enclosingModule=" + enclosingModule + ", "
        + "methodName=" + methodName
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof AndroidInjectorDescriptor) {
      AndroidInjectorDescriptor that = (AndroidInjectorDescriptor) o;
      return (this.injectedType.equals(that.injectedType()))
           && (this.frameworkType.equals(that.frameworkType()))
           && (this.mapKeyType.equals(that.mapKeyType()))
           && (this.scopes.equals(that.scopes()))
           && (this.modules.equals(that.modules()))
           && (this.enclosingModule.equals(that.enclosingModule()))
           && (this.methodName.equals(that.methodName()));
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h = 1;
    h *= 1000003;
    h ^= this.injectedType.hashCode();
    h *= 1000003;
    h ^= this.frameworkType.hashCode();
    h *= 1000003;
    h ^= this.mapKeyType.hashCode();
    h *= 1000003;
    h ^= this.scopes.hashCode();
    h *= 1000003;
    h ^= this.modules.hashCode();
    h *= 1000003;
    h ^= this.enclosingModule.hashCode();
    h *= 1000003;
    h ^= this.methodName.hashCode();
    return h;
  }

  static final class Builder extends AndroidInjectorDescriptor.Builder {
    private ClassName injectedType;
    private ClassName frameworkType;
    private ClassName mapKeyType;
    private ImmutableSet.Builder<AnnotationSpec> scopesBuilder$;
    private ImmutableSet<AnnotationSpec> scopes;
    private ImmutableSet.Builder<ClassName> modulesBuilder$;
    private ImmutableSet<ClassName> modules;
    private ClassName enclosingModule;
    private String methodName;
    Builder() {
      this.scopes = ImmutableSet.of();
      this.modules = ImmutableSet.of();
    }
    Builder(AndroidInjectorDescriptor source) {
      this.injectedType = source.injectedType();
      this.frameworkType = source.frameworkType();
      this.mapKeyType = source.mapKeyType();
      this.scopes = source.scopes();
      this.modules = source.modules();
      this.enclosingModule = source.enclosingModule();
      this.methodName = source.methodName();
    }
    @Override
    public AndroidInjectorDescriptor.Builder injectedType(ClassName injectedType) {
      this.injectedType = injectedType;
      return this;
    }
    @Override
    public AndroidInjectorDescriptor.Builder frameworkType(ClassName frameworkType) {
      this.frameworkType = frameworkType;
      return this;
    }
    @Override
    public AndroidInjectorDescriptor.Builder mapKeyType(ClassName mapKeyType) {
      this.mapKeyType = mapKeyType;
      return this;
    }
    @Override
    public ImmutableSet.Builder<AnnotationSpec> scopesBuilder() {
      if (scopesBuilder$ == null) {
        scopesBuilder$ = ImmutableSet.builder();
        scopesBuilder$.addAll(scopes);
        scopes = null;
      }
      return scopesBuilder$;
    }
    @Override
    public ImmutableSet.Builder<ClassName> modulesBuilder() {
      if (modulesBuilder$ == null) {
        modulesBuilder$ = ImmutableSet.builder();
        modulesBuilder$.addAll(modules);
        modules = null;
      }
      return modulesBuilder$;
    }
    @Override
    public AndroidInjectorDescriptor.Builder enclosingModule(ClassName enclosingModule) {
      this.enclosingModule = enclosingModule;
      return this;
    }
    @Override
    public AndroidInjectorDescriptor.Builder methodName(String methodName) {
      this.methodName = methodName;
      return this;
    }
    @Override
    public AndroidInjectorDescriptor build() {
      if (scopesBuilder$ != null) {
        scopes = scopesBuilder$.build();
      }
      if (modulesBuilder$ != null) {
        modules = modulesBuilder$.build();
      }
      String missing = "";
      if (injectedType == null) {
        missing += " injectedType";
      }
      if (frameworkType == null) {
        missing += " frameworkType";
      }
      if (mapKeyType == null) {
        missing += " mapKeyType";
      }
      if (enclosingModule == null) {
        missing += " enclosingModule";
      }
      if (methodName == null) {
        missing += " methodName";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_AndroidInjectorDescriptor(
          this.injectedType,
          this.frameworkType,
          this.mapKeyType,
          this.scopes,
          this.modules,
          this.enclosingModule,
          this.methodName);
    }
  }

}
