/*
 * Decompiled with CFR 0.152.
 */
package dagger.android.processor;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.SetMultimap;
import dagger.Binds;
import dagger.android.AndroidInjectionKey;
import dagger.android.AndroidInjector;
import dagger.android.processor.AndroidMapKeys;
import dagger.shaded.auto.common.AnnotationMirrors;
import dagger.shaded.auto.common.BasicAnnotationProcessor;
import dagger.shaded.auto.common.MoreElements;
import dagger.shaded.auto.common.MoreTypes;
import java.lang.annotation.Annotation;
import java.util.Set;
import javax.annotation.processing.Messager;
import javax.inject.Qualifier;
import javax.inject.Scope;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;

final class AndroidMapKeyValidator
implements BasicAnnotationProcessor.ProcessingStep {
    private final Elements elements;
    private final Types types;
    private final Messager messager;

    AndroidMapKeyValidator(Elements elements, Types types, Messager messager) {
        this.elements = elements;
        this.types = types;
        this.messager = messager;
    }

    @Override
    public Set<? extends Class<? extends Annotation>> annotations() {
        return ImmutableSet.builder().addAll((Iterable)AndroidMapKeys.annotationsAndFrameworkTypes(this.elements).keySet()).add(AndroidInjectionKey.class).build();
    }

    public Set<Element> process(SetMultimap<Class<? extends Annotation>, Element> elementsByAnnotation) {
        elementsByAnnotation.forEach((annotation, element) -> this.validateMethod((Class<? extends Annotation>)annotation, MoreElements.asExecutable(element)));
        return ImmutableSet.of();
    }

    private void validateMethod(Class<? extends Annotation> annotation, ExecutableElement method) {
        SuppressWarnings suppressedWarnings;
        if (!AnnotationMirrors.getAnnotatedAnnotations(method, Qualifier.class).isEmpty()) {
            return;
        }
        TypeMirror returnType = method.getReturnType();
        if (!this.types.isAssignable(this.types.erasure(returnType), this.factoryElement().asType())) {
            return;
        }
        TypeMirror frameworkType = this.frameworkTypeForMapKey(method, annotation);
        if (!(AnnotationMirrors.getAnnotatedAnnotations(method, Scope.class).isEmpty() || (suppressedWarnings = method.getAnnotation(SuppressWarnings.class)) != null && ImmutableSet.copyOf((Object[])suppressedWarnings.value()).contains((Object)"dagger.android.ScopedInjectorFactory"))) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, String.format("%s bindings should not be scoped. Scoping this method may leak instances of %s. ", AndroidInjector.Factory.class.getCanonicalName(), frameworkType), method);
        }
        DeclaredType intendedReturnType = this.injectorFactoryOf(this.types.getWildcardType(frameworkType, null));
        if (!MoreTypes.equivalence().equivalent((Object)returnType, (Object)intendedReturnType)) {
            String subject = annotation.equals(AndroidInjectionKey.class) ? method.toString() : String.format("@%s methods", annotation.getCanonicalName());
            this.messager.printMessage(Diagnostic.Kind.ERROR, String.format("%s should bind %s, not %s. See https://google.github.io/dagger/android", subject, intendedReturnType, returnType), method);
        }
        if (MoreElements.isAnnotationPresent(method, Binds.class) && method.getParameters().size() == 1) {
            this.validateMapKeyMatchesBindsParameter(annotation, method);
        }
    }

    private void validateMapKeyMatchesBindsParameter(Class<? extends Annotation> annotation, ExecutableElement method) {
        AnnotationMirror annotationMirror;
        TypeMirror mapKeyType;
        TypeMirror parameterType = ((VariableElement)Iterables.getOnlyElement(method.getParameters())).asType();
        if (!this.types.isAssignable(parameterType, this.injectorFactoryOf(mapKeyType = this.elements.getTypeElement(AndroidMapKeys.injectedTypeFromMapKey(annotationMirror = (AnnotationMirror)MoreElements.getAnnotationMirror(method, annotation).get()).get()).asType()))) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, String.format("%s does not implement AndroidInjector<%s>", parameterType, mapKeyType), method, annotationMirror);
        }
    }

    private TypeMirror frameworkTypeForMapKey(ExecutableElement method, Class<? extends Annotation> annotation) {
        AnnotationMirror annotationMirror = (AnnotationMirror)MoreElements.getAnnotationMirror(method, annotation).get();
        TypeMirror mapKeyType = this.elements.getTypeElement(AndroidMapKeys.injectedTypeFromMapKey(annotationMirror).get()).asType();
        return AndroidMapKeys.annotationsAndFrameworkTypes(this.elements).values().stream().filter(frameworkType -> this.types.isAssignable(mapKeyType, (TypeMirror)frameworkType)).findFirst().get();
    }

    private DeclaredType injectorFactoryOf(TypeMirror implementationType) {
        return this.types.getDeclaredType(this.factoryElement(), implementationType);
    }

    private TypeElement factoryElement() {
        return this.elements.getTypeElement(AndroidInjector.Factory.class.getCanonicalName());
    }
}

