/*
 * Decompiled with CFR 0.152.
 */
package dagger.android.processor;

import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimaps;
import dagger.MapKey;
import dagger.android.AndroidInjector;
import dagger.android.DispatchingAndroidInjector;
import dagger.android.processor.AndroidMapKeys;
import dagger.model.BindingGraph;
import dagger.model.BindingKind;
import dagger.model.Key;
import dagger.shaded.auto.common.AnnotationMirrors;
import dagger.shaded.auto.common.MoreTypes;
import dagger.spi.BindingGraphPlugin;
import dagger.spi.DiagnosticReporter;
import java.util.Formatter;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Provider;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;

public final class DuplicateAndroidInjectorsChecker
implements BindingGraphPlugin {
    private Types types;
    private Elements elements;

    public void visitGraph(BindingGraph graph, DiagnosticReporter diagnosticReporter) {
        for (BindingGraph.BindingNode node : graph.bindingNodes()) {
            if (!this.isDispatchingAndroidInjector(node)) continue;
            this.validateMapKeyUniqueness(node, graph, diagnosticReporter);
        }
    }

    private boolean isDispatchingAndroidInjector(BindingGraph.BindingNode node) {
        Key key = node.binding().key();
        return MoreTypes.isTypeOf(DispatchingAndroidInjector.class, key.type()) && !key.qualifier().isPresent();
    }

    private void validateMapKeyUniqueness(BindingGraph.BindingNode dispatchingAndroidInjectorNode, BindingGraph graph, DiagnosticReporter diagnosticReporter) {
        ImmutableSet injectorFactories = this.injectorMapDependencies(dispatchingAndroidInjectorNode, graph).flatMap(injectorFactoryMap -> this.dependencies((BindingGraph.BindingNode)injectorFactoryMap, graph)).collect(Collectors.collectingAndThen(Collectors.toList(), ImmutableSet::copyOf));
        ImmutableListMultimap.Builder mapKeyIndex = ImmutableListMultimap.builder();
        for (BindingGraph.BindingNode injectorFactory : injectorFactories) {
            AnnotationMirror mapKey = this.mapKey(injectorFactory).get();
            Optional<String> injectedType2 = AndroidMapKeys.injectedTypeFromMapKey(mapKey);
            if (injectedType2.isPresent()) {
                mapKeyIndex.put((Object)injectedType2.get(), (Object)injectorFactory);
                continue;
            }
            diagnosticReporter.reportBinding(Diagnostic.Kind.ERROR, injectorFactory, "Unrecognized class: %s", (Object)mapKey, new Object[0]);
        }
        Map duplicates = Maps.filterValues((Map)Multimaps.asMap((ListMultimap)mapKeyIndex.build()), bindingNodes -> bindingNodes.size() > 1);
        if (!duplicates.isEmpty()) {
            StringBuilder errorMessage = new StringBuilder("Multiple injector factories bound for the same type:\n");
            Formatter formatter = new Formatter(errorMessage);
            duplicates.forEach((injectedType, duplicateFactories) -> {
                formatter.format("  %s:\n", injectedType);
                duplicateFactories.forEach(duplicate -> formatter.format("    %s\n", duplicate));
            });
            diagnosticReporter.reportBinding(Diagnostic.Kind.ERROR, dispatchingAndroidInjectorNode, errorMessage.toString());
        }
    }

    private Stream<BindingGraph.BindingNode> dependencies(BindingGraph.BindingNode bindingNode, BindingGraph graph) {
        return graph.successors((Object)bindingNode).stream().filter(BindingGraph.BindingNode.class::isInstance).map(BindingGraph.BindingNode.class::cast);
    }

    private Stream<BindingGraph.BindingNode> injectorMapDependencies(BindingGraph.BindingNode bindingNode, BindingGraph graph) {
        return this.dependencies(bindingNode, graph).filter(node -> node.binding().kind().equals((Object)BindingKind.MULTIBOUND_MAP)).filter(node -> {
            TypeMirror valueType = MoreTypes.asDeclared(node.binding().key().type()).getTypeArguments().get(1);
            if (!MoreTypes.isTypeOf(Provider.class, valueType) || !valueType.getKind().equals((Object)TypeKind.DECLARED)) {
                return false;
            }
            TypeMirror providedType = MoreTypes.asDeclared(valueType).getTypeArguments().get(0);
            return MoreTypes.isTypeOf(AndroidInjector.Factory.class, providedType);
        });
    }

    private Optional<AnnotationMirror> mapKey(BindingGraph.BindingNode bindingNode) {
        return bindingNode.binding().bindingElement().map(bindingElement -> AnnotationMirrors.getAnnotatedAnnotations(bindingElement, MapKey.class)).flatMap(annotations -> annotations.isEmpty() ? Optional.empty() : Optional.of((AnnotationMirror)Iterables.getOnlyElement((Iterable)annotations)));
    }

    public String pluginName() {
        return "Dagger/Android/DuplicateAndroidInjectors";
    }

    public void initTypes(Types types) {
        this.types = types;
    }

    public void initElements(Elements elements) {
        this.elements = elements;
    }
}

