/*
 * Decompiled with CFR 0.152.
 */
package dagger.android.processor;

import com.google.common.base.Equivalence;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.SetMultimap;
import dagger.Binds;
import dagger.MapKey;
import dagger.android.AndroidInjectionKey;
import dagger.android.AndroidInjector;
import dagger.android.processor.AndroidMapKeys;
import dagger.multibindings.ClassKey;
import dagger.shaded.auto.common.AnnotationMirrors;
import dagger.shaded.auto.common.BasicAnnotationProcessor;
import dagger.shaded.auto.common.MoreElements;
import dagger.shaded.auto.common.MoreTypes;
import java.lang.annotation.Annotation;
import java.util.Set;
import javax.annotation.processing.Messager;
import javax.inject.Qualifier;
import javax.inject.Scope;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;

final class AndroidMapKeyValidator
implements BasicAnnotationProcessor.ProcessingStep {
    private final Elements elements;
    private final Types types;
    private final Messager messager;

    AndroidMapKeyValidator(Elements elements, Types types, Messager messager) {
        this.elements = elements;
        this.types = types;
        this.messager = messager;
    }

    @Override
    public Set<? extends Class<? extends Annotation>> annotations() {
        return ImmutableSet.builder().addAll((Iterable)AndroidMapKeys.frameworkTypesByMapKey(this.elements).keySet()).add(AndroidInjectionKey.class).add(ClassKey.class).build();
    }

    public Set<Element> process(SetMultimap<Class<? extends Annotation>, Element> elementsByAnnotation) {
        elementsByAnnotation.forEach((annotation, element) -> this.validateMethod((Class<? extends Annotation>)annotation, MoreElements.asExecutable(element)));
        return ImmutableSet.of();
    }

    private void validateMethod(Class<? extends Annotation> annotation, ExecutableElement method) {
        SuppressWarnings suppressedWarnings;
        if (!AnnotationMirrors.getAnnotatedAnnotations(method, Qualifier.class).isEmpty()) {
            return;
        }
        TypeMirror returnType = method.getReturnType();
        if (!this.types.isAssignable(this.types.erasure(returnType), this.factoryElement().asType())) {
            return;
        }
        if (!(AnnotationMirrors.getAnnotatedAnnotations(method, Scope.class).isEmpty() || (suppressedWarnings = method.getAnnotation(SuppressWarnings.class)) != null && ImmutableSet.copyOf((Object[])suppressedWarnings.value()).contains((Object)"dagger.android.ScopedInjectorFactory"))) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, String.format("%s bindings should not be scoped. Scoping this method may leak instances of %s. ", AndroidInjector.Factory.class.getCanonicalName(), this.frameworkTypeForMapKey(method)), method);
        }
        this.validateReturnTypeMatchesMapKey(method, annotation);
        if (MoreElements.isAnnotationPresent(method, Binds.class) && method.getParameters().size() == 1) {
            this.validateMapKeyMatchesBindsParameter(annotation, method);
        }
    }

    private void validateReturnTypeMatchesMapKey(ExecutableElement method, Class<? extends Annotation> mapKeyType) {
        WildcardType any = this.types.getWildcardType(null, null);
        WildcardType anyExtendsFrameworkType = this.types.getWildcardType(this.frameworkTypeForMapKey(method), null);
        if (mapKeyType == ClassKey.class) {
            this.validateReturnType(method, this.injectorFactoryOf(any), new DeclaredType[0]);
        } else if (mapKeyType == AndroidInjectionKey.class) {
            this.validateReturnType(method, this.injectorFactoryOf(any), this.injectorFactoryOf(anyExtendsFrameworkType));
        } else {
            this.validateReturnType(method, this.injectorFactoryOf(anyExtendsFrameworkType), new DeclaredType[0]);
        }
    }

    private void validateReturnType(ExecutableElement method, DeclaredType idealReturnType, DeclaredType ... otherPossibleReturnTypes) {
        Equivalence<TypeMirror> equivalence = MoreTypes.equivalence();
        TypeMirror returnType = method.getReturnType();
        if (Lists.asList((Object)idealReturnType, (Object[])otherPossibleReturnTypes).stream().noneMatch(validReturnType -> equivalence.equivalent(validReturnType, (Object)returnType))) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, String.format("%s should bind %s, not %s. See https://google.github.io/dagger/android", method, idealReturnType, returnType), method);
        }
    }

    private void validateMapKeyMatchesBindsParameter(Class<? extends Annotation> annotation, ExecutableElement method) {
        AnnotationMirror annotationMirror;
        TypeMirror mapKeyType;
        TypeMirror parameterType = ((VariableElement)Iterables.getOnlyElement(method.getParameters())).asType();
        if (!this.types.isAssignable(parameterType, this.injectorFactoryOf(mapKeyType = this.elements.getTypeElement(AndroidMapKeys.injectedTypeFromMapKey(annotationMirror = (AnnotationMirror)MoreElements.getAnnotationMirror(method, annotation).get()).get()).asType()))) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, String.format("%s does not implement AndroidInjector<%s>", parameterType, mapKeyType), method, annotationMirror);
        }
    }

    private TypeMirror frameworkTypeForMapKey(ExecutableElement method) {
        AnnotationMirror mapKeyAnnotation = (AnnotationMirror)Iterables.getOnlyElement(AnnotationMirrors.getAnnotatedAnnotations(method, MapKey.class));
        TypeMirror mapKeyType = this.elements.getTypeElement(AndroidMapKeys.injectedTypeFromMapKey(mapKeyAnnotation).get()).asType();
        return AndroidMapKeys.frameworkTypesByMapKey(this.elements).values().stream().filter(frameworkType -> this.types.isAssignable(mapKeyType, (TypeMirror)frameworkType)).findFirst().get();
    }

    private DeclaredType injectorFactoryOf(TypeMirror implementationType) {
        return this.types.getDeclaredType(this.factoryElement(), implementationType);
    }

    private TypeElement factoryElement() {
        return this.elements.getTypeElement(AndroidInjector.Factory.class.getCanonicalName());
    }
}

