/*
 * Decompiled with CFR 0.152.
 */
package dagger.android.processor;

import com.google.common.base.CaseFormat;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.SetMultimap;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.WildcardTypeName;
import dagger.Binds;
import dagger.Module;
import dagger.Subcomponent;
import dagger.android.AndroidInjectionKey;
import dagger.android.AndroidInjector;
import dagger.android.ContributesAndroidInjector;
import dagger.android.processor.AndroidInjectorDescriptor;
import dagger.android.processor.AndroidProcessor;
import dagger.multibindings.ClassKey;
import dagger.multibindings.IntoMap;
import dagger.shaded.auto.common.BasicAnnotationProcessor;
import dagger.shaded.auto.common.GeneratedAnnotationSpecs;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.Set;
import javax.annotation.processing.Filer;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;

final class ContributesAndroidInjectorGenerator
implements BasicAnnotationProcessor.ProcessingStep {
    private final AndroidInjectorDescriptor.Validator validator;
    private final Filer filer;
    private final Elements elements;
    private final boolean useStringKeys;
    private final SourceVersion sourceVersion;

    ContributesAndroidInjectorGenerator(AndroidInjectorDescriptor.Validator validator, boolean useStringKeys, Filer filer, Elements elements, SourceVersion sourceVersion) {
        this.validator = validator;
        this.useStringKeys = useStringKeys;
        this.filer = filer;
        this.elements = elements;
        this.sourceVersion = sourceVersion;
    }

    @Override
    public Set<? extends Class<? extends Annotation>> annotations() {
        return ImmutableSet.of(ContributesAndroidInjector.class);
    }

    public Set<Element> process(SetMultimap<Class<? extends Annotation>, Element> elementsByAnnotation) {
        ImmutableSet.Builder deferredElements = ImmutableSet.builder();
        for (ExecutableElement method : ElementFilter.methodsIn(elementsByAnnotation.values())) {
            try {
                this.validator.createIfValid(method).ifPresent(this::generate);
            }
            catch (TypeNotPresentException e) {
                deferredElements.add((Object)method);
            }
        }
        return deferredElements.build();
    }

    private void generate(AndroidInjectorDescriptor descriptor) {
        ClassName moduleName = descriptor.enclosingModule().topLevelClassName().peerClass(Joiner.on((char)'_').join((Iterable)descriptor.enclosingModule().simpleNames()) + "_" + CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, descriptor.method().getSimpleName().toString()));
        String baseName = descriptor.injectedType().simpleName();
        ClassName subcomponentName = moduleName.nestedClass(baseName + "Subcomponent");
        ClassName subcomponentFactoryName = subcomponentName.nestedClass("Factory");
        TypeSpec.Builder module = TypeSpec.classBuilder((ClassName)moduleName).addOriginatingElement((Element)descriptor.method()).addAnnotation(AnnotationSpec.builder(Module.class).addMember("subcomponents", "$T.class", new Object[]{subcomponentName}).build()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).addMethod(this.bindAndroidInjectorFactory(descriptor, subcomponentFactoryName)).addType(this.subcomponent(descriptor, subcomponentName, subcomponentFactoryName)).addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PRIVATE}).build());
        GeneratedAnnotationSpecs.generatedAnnotationSpec(this.elements, this.sourceVersion, AndroidProcessor.class).ifPresent(arg_0 -> ((TypeSpec.Builder)module).addAnnotation(arg_0));
        try {
            JavaFile.builder((String)moduleName.packageName(), (TypeSpec)module.build()).skipJavaLangImports(true).build().writeTo(this.filer);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    private MethodSpec bindAndroidInjectorFactory(AndroidInjectorDescriptor descriptor, ClassName subcomponentBuilderName) {
        return MethodSpec.methodBuilder((String)"bindAndroidInjectorFactory").addAnnotation(Binds.class).addAnnotation(IntoMap.class).addAnnotation(this.androidInjectorMapKey(descriptor)).addModifiers(new Modifier[]{Modifier.ABSTRACT}).returns((TypeName)ContributesAndroidInjectorGenerator.parameterizedTypeName(AndroidInjector.Factory.class, new TypeName[]{WildcardTypeName.subtypeOf((TypeName)TypeName.OBJECT)})).addParameter((TypeName)subcomponentBuilderName, "builder", new Modifier[0]).build();
    }

    private AnnotationSpec androidInjectorMapKey(AndroidInjectorDescriptor descriptor) {
        if (this.useStringKeys) {
            return AnnotationSpec.builder(AndroidInjectionKey.class).addMember("value", "$S", new Object[]{descriptor.injectedType().toString()}).build();
        }
        return AnnotationSpec.builder(ClassKey.class).addMember("value", "$T.class", new Object[]{descriptor.injectedType()}).build();
    }

    private TypeSpec subcomponent(AndroidInjectorDescriptor descriptor, ClassName subcomponentName, ClassName subcomponentFactoryName) {
        AnnotationSpec.Builder subcomponentAnnotation = AnnotationSpec.builder(Subcomponent.class);
        for (ClassName module : descriptor.modules()) {
            subcomponentAnnotation.addMember("modules", CodeBlock.of((String)"$T.class", (Object[])new Object[]{module}));
        }
        return TypeSpec.interfaceBuilder((ClassName)subcomponentName).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(subcomponentAnnotation.build()).addAnnotations(descriptor.scopes()).addSuperinterface((TypeName)ContributesAndroidInjectorGenerator.parameterizedTypeName(AndroidInjector.class, new TypeName[]{descriptor.injectedType()})).addType(this.subcomponentFactory(descriptor, subcomponentFactoryName)).build();
    }

    private TypeSpec subcomponentFactory(AndroidInjectorDescriptor descriptor, ClassName subcomponentFactoryName) {
        return TypeSpec.interfaceBuilder((ClassName)subcomponentFactoryName).addAnnotation(Subcomponent.Factory.class).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).addSuperinterface((TypeName)ContributesAndroidInjectorGenerator.parameterizedTypeName(AndroidInjector.Factory.class, new TypeName[]{descriptor.injectedType()})).build();
    }

    private static ParameterizedTypeName parameterizedTypeName(Class<?> clazz, TypeName ... typeArguments) {
        return ParameterizedTypeName.get((ClassName)ClassName.get(clazz), (TypeName[])typeArguments);
    }
}

