/*
 * Decompiled with CFR 0.152.
 */
package dagger.android.processor;

import com.google.common.base.Ascii;
import com.google.common.base.CaseFormat;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableSet;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.WildcardTypeName;
import dagger.android.processor.AndroidInjectorDescriptor;
import dagger.android.processor.BaseProcessingStep;
import dagger.android.processor.TypeNames;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.JavaPoetExtKt;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XFiler;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XProcessingEnv;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XTypeElement;
import javax.lang.model.element.Modifier;
import javax.tools.Diagnostic;

final class ContributesAndroidInjectorProcessingStep
extends BaseProcessingStep {
    private final AndroidInjectorDescriptor.Validator validator;
    private final XProcessingEnv processingEnv;

    ContributesAndroidInjectorProcessingStep(XProcessingEnv processingEnv) {
        this.processingEnv = processingEnv;
        this.validator = new AndroidInjectorDescriptor.Validator(processingEnv.getMessager());
    }

    public ImmutableSet<ClassName> annotationClassNames() {
        return ImmutableSet.of((Object)TypeNames.CONTRIBUTES_ANDROID_INJECTOR);
    }

    @Override
    public void process(XElement element, ImmutableSet<ClassName> annotationNames) {
        this.validator.createIfValid(XElements.asMethod((XElement)element)).ifPresent(this::generate);
    }

    private void generate(AndroidInjectorDescriptor descriptor) {
        ClassName moduleName = descriptor.enclosingModule().topLevelClassName().peerClass(Joiner.on((char)'_').join((Iterable)descriptor.enclosingModule().simpleNames()) + "_" + CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, XElements.getSimpleName((XElement)descriptor.method())));
        String baseName = descriptor.injectedType().simpleName();
        ClassName subcomponentName = moduleName.nestedClass(baseName + "Subcomponent");
        ClassName subcomponentFactoryName = subcomponentName.nestedClass("Factory");
        TypeSpec.Builder module = TypeSpec.classBuilder((ClassName)moduleName).addAnnotation(AnnotationSpec.builder((ClassName)TypeNames.MODULE).addMember("subcomponents", "$T.class", new Object[]{subcomponentName}).build()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).addMethod(this.bindAndroidInjectorFactory(descriptor, subcomponentFactoryName)).addType(this.subcomponent(descriptor, subcomponentName, subcomponentFactoryName)).addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PRIVATE}).build());
        JavaPoetExtKt.addOriginatingElement((TypeSpec.Builder)module, (XElement)descriptor.method());
        XTypeElement generatedAnnotation = this.processingEnv.findGeneratedAnnotation();
        if (generatedAnnotation != null) {
            module.addAnnotation(AnnotationSpec.builder((ClassName)generatedAnnotation.getClassName()).addMember("value", "$S", new Object[]{ClassName.get((String)"dagger.android.processor", (String)"AndroidProcessor", (String[])new String[0])}).build());
        }
        this.processingEnv.getFiler().write(JavaFile.builder((String)moduleName.packageName(), (TypeSpec)module.build()).skipJavaLangImports(true).build(), XFiler.Mode.Isolating);
    }

    private static boolean useStringKeys(XProcessingEnv processingEnv) {
        if (!processingEnv.getOptions().containsKey("dagger.android.experimentalUseStringKeys")) {
            return false;
        }
        String flagValue = (String)processingEnv.getOptions().get("dagger.android.experimentalUseStringKeys");
        if (flagValue == null || Ascii.equalsIgnoreCase((CharSequence)flagValue, (CharSequence)"true")) {
            return true;
        }
        if (Ascii.equalsIgnoreCase((CharSequence)flagValue, (CharSequence)"false")) {
            return false;
        }
        processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, String.format("Unknown flag value: %s. %s must be set to either 'true' or 'false'.", flagValue, "dagger.android.experimentalUseStringKeys"));
        return false;
    }

    private MethodSpec bindAndroidInjectorFactory(AndroidInjectorDescriptor descriptor, ClassName subcomponentBuilderName) {
        return MethodSpec.methodBuilder((String)"bindAndroidInjectorFactory").addAnnotation(TypeNames.BINDS).addAnnotation(TypeNames.INTO_MAP).addAnnotation(this.androidInjectorMapKey(descriptor)).addModifiers(new Modifier[]{Modifier.ABSTRACT}).returns((TypeName)ParameterizedTypeName.get((ClassName)TypeNames.ANDROID_INJECTOR_FACTORY, (TypeName[])new TypeName[]{WildcardTypeName.subtypeOf((TypeName)TypeName.OBJECT)})).addParameter((TypeName)subcomponentBuilderName, "builder", new Modifier[0]).build();
    }

    private AnnotationSpec androidInjectorMapKey(AndroidInjectorDescriptor descriptor) {
        if (ContributesAndroidInjectorProcessingStep.useStringKeys(this.processingEnv)) {
            return AnnotationSpec.builder((ClassName)TypeNames.ANDROID_INJECTION_KEY).addMember("value", "$S", new Object[]{descriptor.injectedType().toString()}).build();
        }
        return AnnotationSpec.builder((ClassName)TypeNames.CLASS_KEY).addMember("value", "$T.class", new Object[]{descriptor.injectedType()}).build();
    }

    private TypeSpec subcomponent(AndroidInjectorDescriptor descriptor, ClassName subcomponentName, ClassName subcomponentFactoryName) {
        AnnotationSpec.Builder subcomponentAnnotation = AnnotationSpec.builder((ClassName)TypeNames.SUBCOMPONENT);
        for (ClassName module : descriptor.modules()) {
            subcomponentAnnotation.addMember("modules", "$T.class", new Object[]{module});
        }
        return TypeSpec.interfaceBuilder((ClassName)subcomponentName).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(subcomponentAnnotation.build()).addAnnotations(descriptor.scopes()).addSuperinterface((TypeName)ParameterizedTypeName.get((ClassName)TypeNames.ANDROID_INJECTOR, (TypeName[])new TypeName[]{descriptor.injectedType()})).addType(this.subcomponentFactory(descriptor, subcomponentFactoryName)).build();
    }

    private TypeSpec subcomponentFactory(AndroidInjectorDescriptor descriptor, ClassName subcomponentFactoryName) {
        return TypeSpec.interfaceBuilder((ClassName)subcomponentFactoryName).addAnnotation(TypeNames.SUBCOMPONENT_FACTORY).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).addSuperinterface((TypeName)ParameterizedTypeName.get((ClassName)TypeNames.ANDROID_INJECTOR_FACTORY, (TypeName[])new TypeName[]{descriptor.injectedType()})).build();
    }
}

