/*
 * Decompiled with CFR 0.152.
 */
package dagger.android.support;

import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.util.Log;
import dagger.android.AndroidInjector;
import dagger.android.support.HasSupportFragmentInjector;
import dagger.internal.Preconditions;

public final class AndroidSupportInjection {
    private static final String TAG = "dagger.android.support";

    public static void inject(Fragment fragment) {
        Preconditions.checkNotNull((Object)fragment, (String)"fragment");
        HasSupportFragmentInjector hasSupportFragmentInjector = AndroidSupportInjection.findHasFragmentInjector(fragment);
        Log.d((String)TAG, (String)String.format("An injector for %s was found in %s", fragment.getClass().getCanonicalName(), hasSupportFragmentInjector.getClass().getCanonicalName()));
        AndroidInjector<Fragment> fragmentInjector = hasSupportFragmentInjector.supportFragmentInjector();
        Preconditions.checkNotNull(fragmentInjector, (String)"%s.supportFragmentInjector() returned null", (Object)hasSupportFragmentInjector.getClass().getCanonicalName());
        fragmentInjector.inject((Object)fragment);
    }

    private static HasSupportFragmentInjector findHasFragmentInjector(Fragment fragment) {
        Fragment parentFragment = fragment;
        while ((parentFragment = parentFragment.getParentFragment()) != null) {
            if (!(parentFragment instanceof HasSupportFragmentInjector)) continue;
            return (HasSupportFragmentInjector)parentFragment;
        }
        FragmentActivity activity = fragment.getActivity();
        if (activity instanceof HasSupportFragmentInjector) {
            return (HasSupportFragmentInjector)activity;
        }
        if (activity.getApplication() instanceof HasSupportFragmentInjector) {
            return (HasSupportFragmentInjector)activity.getApplication();
        }
        throw new IllegalArgumentException(String.format("No injector was found for %s", fragment.getClass().getCanonicalName()));
    }

    private AndroidSupportInjection() {
    }
}

