/*
 * Decompiled with CFR 0.152.
 */
package dagger.android;

import android.app.Activity;
import android.app.Application;
import android.app.Fragment;
import android.util.Log;
import dagger.android.DispatchingAndroidInjector;
import dagger.android.HasDispatchingActivityInjector;
import dagger.android.HasDispatchingFragmentInjector;
import dagger.internal.Preconditions;

public final class AndroidInjection {
    private static final String TAG = "dagger.android";

    public static void inject(Activity activity) {
        Preconditions.checkNotNull((Object)activity, (String)"activity");
        Application application = activity.getApplication();
        if (!(application instanceof HasDispatchingActivityInjector)) {
            throw new RuntimeException(String.format("%s does not implement %s", application.getClass().getCanonicalName(), HasDispatchingActivityInjector.class.getCanonicalName()));
        }
        DispatchingAndroidInjector<Activity> dispatchingAndroidInjector = ((HasDispatchingActivityInjector)application).activityInjector();
        Preconditions.checkNotNull(dispatchingAndroidInjector, (String)"%s.activityInjector() returned null", (Object)application.getClass().getCanonicalName());
        dispatchingAndroidInjector.inject(activity);
    }

    public static void inject(Fragment fragment) {
        Preconditions.checkNotNull((Object)fragment, (String)"fragment");
        HasDispatchingFragmentInjector hasDispatchingFragmentInjector = AndroidInjection.findHasFragmentInjector(fragment);
        Log.d((String)TAG, (String)String.format("An injector for %s was found in %s", fragment.getClass().getCanonicalName(), hasDispatchingFragmentInjector.getClass().getCanonicalName()));
        DispatchingAndroidInjector<Fragment> dispatchingAndroidInjector = hasDispatchingFragmentInjector.fragmentInjector();
        Preconditions.checkNotNull(dispatchingAndroidInjector, (String)"%s.fragmentInjector() returned null", (Object)hasDispatchingFragmentInjector.getClass().getCanonicalName());
        dispatchingAndroidInjector.inject(fragment);
    }

    private static HasDispatchingFragmentInjector findHasFragmentInjector(Fragment fragment) {
        Fragment fragment2 = fragment;
        while ((fragment2 = fragment2.getParentFragment()) != null) {
            if (!(fragment2 instanceof HasDispatchingFragmentInjector)) continue;
            return (HasDispatchingFragmentInjector)fragment2;
        }
        Activity activity = fragment.getActivity();
        if (activity instanceof HasDispatchingFragmentInjector) {
            return (HasDispatchingFragmentInjector)activity;
        }
        if (activity.getApplication() instanceof HasDispatchingFragmentInjector) {
            return (HasDispatchingFragmentInjector)activity.getApplication();
        }
        throw new IllegalArgumentException(String.format("No injector was found for %s", fragment.getClass().getCanonicalName()));
    }

    private AndroidInjection() {
    }
}

