/*
 * Decompiled with CFR 0.152.
 */
package dagger.android;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import dagger.android.AndroidInjector;
import dagger.internal.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Provider;

public final class DispatchingAndroidInjector<T>
implements AndroidInjector<T> {
    private static final String NO_SUPERTYPES_BOUND_FORMAT = "No injector factory bound for Class<%s>";
    private static final String SUPERTYPES_BOUND_FORMAT = "No injector factory bound for Class<%1$s>. Injector factories were bound for supertypes of %1$s: %2$s. Did you mean to bind an injector factory for the subtype?";
    private final Map<Class<? extends T>, Provider<AndroidInjector.Factory<? extends T>>> injectorFactories;

    @Inject
    DispatchingAndroidInjector(Map<Class<? extends T>, Provider<AndroidInjector.Factory<? extends T>>> injectorFactories) {
        this.injectorFactories = injectorFactories;
    }

    @CanIgnoreReturnValue
    public boolean maybeInject(T instance) {
        Provider<AndroidInjector.Factory<? extends T>> factoryProvider = this.injectorFactories.get(instance.getClass());
        if (factoryProvider == null) {
            return false;
        }
        AndroidInjector.Factory factory = (AndroidInjector.Factory)factoryProvider.get();
        try {
            AndroidInjector injector = (AndroidInjector)Preconditions.checkNotNull(factory.create(instance), (String)"%s.create(I) should not return null.", (Object)factory.getClass().getCanonicalName());
            injector.inject(instance);
            return true;
        }
        catch (ClassCastException e) {
            throw new InvalidInjectorBindingException(String.format("%s does not implement AndroidInjector.Factory<%s>", factory.getClass().getCanonicalName(), instance.getClass().getCanonicalName()), e);
        }
    }

    @Override
    public void inject(T instance) {
        boolean wasInjected = this.maybeInject(instance);
        if (!wasInjected) {
            throw new IllegalArgumentException(this.errorMessageSuggestions(instance));
        }
    }

    private String errorMessageSuggestions(T instance) {
        ArrayList<String> suggestions = new ArrayList<String>();
        for (Class<T> activityClass : this.injectorFactories.keySet()) {
            if (!activityClass.isInstance(instance)) continue;
            suggestions.add(activityClass.getCanonicalName());
        }
        Collections.sort(suggestions);
        return String.format(suggestions.isEmpty() ? NO_SUPERTYPES_BOUND_FORMAT : SUPERTYPES_BOUND_FORMAT, instance.getClass().getCanonicalName(), suggestions);
    }

    public static final class InvalidInjectorBindingException
    extends RuntimeException {
        InvalidInjectorBindingException(String message, ClassCastException cause) {
            super(message, cause);
        }
    }
}

