
package dagger.internal.codegen;

import java.util.Optional;
import javax.annotation.Generated;
import javax.lang.model.element.Element;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
 final class AutoValue_DependencyRequest extends DependencyRequest {

  private final DependencyRequest.Kind kind;
  private final Key key;
  private final Optional<Element> requestElement;
  private final boolean isNullable;
  private final Optional<String> overriddenVariableName;

  private AutoValue_DependencyRequest(
      DependencyRequest.Kind kind,
      Key key,
      Optional<Element> requestElement,
      boolean isNullable,
      Optional<String> overriddenVariableName) {
    this.kind = kind;
    this.key = key;
    this.requestElement = requestElement;
    this.isNullable = isNullable;
    this.overriddenVariableName = overriddenVariableName;
  }

  @Override
  DependencyRequest.Kind kind() {
    return kind;
  }

  @Override
  Key key() {
    return key;
  }

  @Override
  Optional<Element> requestElement() {
    return requestElement;
  }

  @Override
  boolean isNullable() {
    return isNullable;
  }

  @Override
  Optional<String> overriddenVariableName() {
    return overriddenVariableName;
  }

  @Override
  public String toString() {
    return "DependencyRequest{"
        + "kind=" + kind + ", "
        + "key=" + key + ", "
        + "requestElement=" + requestElement + ", "
        + "isNullable=" + isNullable + ", "
        + "overriddenVariableName=" + overriddenVariableName
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof DependencyRequest) {
      DependencyRequest that = (DependencyRequest) o;
      return (this.kind.equals(that.kind()))
           && (this.key.equals(that.key()))
           && (this.requestElement.equals(that.requestElement()))
           && (this.isNullable == that.isNullable())
           && (this.overriddenVariableName.equals(that.overriddenVariableName()));
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h = 1;
    h *= 1000003;
    h ^= this.kind.hashCode();
    h *= 1000003;
    h ^= this.key.hashCode();
    h *= 1000003;
    h ^= this.requestElement.hashCode();
    h *= 1000003;
    h ^= this.isNullable ? 1231 : 1237;
    h *= 1000003;
    h ^= this.overriddenVariableName.hashCode();
    return h;
  }

  static final class Builder extends DependencyRequest.Builder {
    private DependencyRequest.Kind kind;
    private Key key;
    private Optional<Element> requestElement = Optional.empty();
    private Boolean isNullable;
    private Optional<String> overriddenVariableName = Optional.empty();
    Builder() {
    }
    Builder(DependencyRequest source) {
      this.kind = source.kind();
      this.key = source.key();
      this.requestElement = source.requestElement();
      this.isNullable = source.isNullable();
      this.overriddenVariableName = source.overriddenVariableName();
    }
    @Override
    public DependencyRequest.Builder kind(DependencyRequest.Kind kind) {
      this.kind = kind;
      return this;
    }
    @Override
    public DependencyRequest.Builder key(Key key) {
      this.key = key;
      return this;
    }
    @Override
    public DependencyRequest.Builder requestElement(Element requestElement) {
      this.requestElement = Optional.of(requestElement);
      return this;
    }
    @Override
    public DependencyRequest.Builder isNullable(boolean isNullable) {
      this.isNullable = isNullable;
      return this;
    }
    @Override
    public DependencyRequest.Builder overriddenVariableName(Optional<String> overriddenVariableName) {
      this.overriddenVariableName = overriddenVariableName;
      return this;
    }
    @Override
    public DependencyRequest build() {
      String missing = "";
      if (kind == null) {
        missing += " kind";
      }
      if (key == null) {
        missing += " key";
      }
      if (isNullable == null) {
        missing += " isNullable";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_DependencyRequest(
          this.kind,
          this.key,
          this.requestElement,
          this.isNullable,
          this.overriddenVariableName);
    }
  }

}
