/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.CaseFormat;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import dagger.internal.codegen.Accessibility;
import dagger.internal.codegen.AnnotationSpecs;
import dagger.internal.codegen.BindingKey;
import dagger.internal.codegen.CodeBlocks;
import dagger.internal.codegen.DependencyRequest;
import dagger.internal.codegen.FrameworkField;
import dagger.internal.codegen.InjectValidator;
import dagger.internal.codegen.MembersInjectionBinding;
import dagger.internal.codegen.SourceFileGenerator;
import dagger.internal.codegen.SourceFiles;
import dagger.internal.codegen.TypeNames;
import dagger.internal.codegen.UniqueNameSet;
import dagger.shaded.auto.common.MoreElements;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.processing.Filer;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;

final class MembersInjectorGenerator
extends SourceFileGenerator<MembersInjectionBinding> {
    private final InjectValidator injectValidator;

    MembersInjectorGenerator(Filer filer, Elements elements, InjectValidator injectValidator) {
        super(filer, elements);
        this.injectValidator = injectValidator;
    }

    @Override
    ClassName nameGeneratedType(MembersInjectionBinding binding) {
        return SourceFiles.membersInjectorNameForType(binding.membersInjectedType());
    }

    @Override
    Optional<? extends Element> getElementForErrorReporting(MembersInjectionBinding binding) {
        return Optional.of(binding.membersInjectedType());
    }

    @Override
    Optional<TypeSpec.Builder> write(ClassName generatedTypeName, MembersInjectionBinding binding) {
        if (binding.injectionSites().isEmpty()) {
            return Optional.empty();
        }
        if (!this.injectValidator.isValidType(binding.key().type())) {
            return Optional.empty();
        }
        Preconditions.checkState((!binding.unresolved().isPresent() ? 1 : 0) != 0, (String)"tried to generate a MembersInjector for a binding of a resolved generic type: %s", (Object)binding);
        ImmutableList<TypeVariableName> typeParameters = SourceFiles.bindingTypeElementTypeVariableNames(binding);
        TypeSpec.Builder injectorTypeBuilder = TypeSpec.classBuilder((ClassName)generatedTypeName).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addTypeVariables(typeParameters);
        TypeName injectedTypeName = TypeName.get((TypeMirror)binding.key().type());
        ParameterizedTypeName implementedType = TypeNames.membersInjectorOf(injectedTypeName);
        injectorTypeBuilder.addSuperinterface((TypeName)implementedType);
        MethodSpec.Builder injectMembersBuilder = MethodSpec.methodBuilder((String)"injectMembers").returns(TypeName.VOID).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).addParameter(injectedTypeName, "instance", new Modifier[0]).addCode("if (instance == null) {", new Object[0]).addStatement("throw new $T($S)", new Object[]{NullPointerException.class, "Cannot inject members into a null reference"}).addCode("}", new Object[0]);
        ImmutableMap<BindingKey, FrameworkField> fields = SourceFiles.generateBindingFieldsForDependencies(binding);
        ImmutableMap.Builder dependencyFieldsBuilder = ImmutableMap.builder();
        MethodSpec.Builder constructorBuilder = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC});
        MethodSpec.Builder createMethodBuilder = MethodSpec.methodBuilder((String)"create").returns((TypeName)implementedType).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).addTypeVariables(typeParameters);
        createMethodBuilder.addCode("return new $T(", new Object[]{SourceFiles.parameterizedGeneratedTypeNameForBinding(binding)});
        ImmutableList.Builder constructorInvocationParameters = ImmutableList.builder();
        boolean usesRawFrameworkTypes = false;
        UniqueNameSet fieldNames = new UniqueNameSet();
        for (Map.Entry fieldEntry : fields.entrySet()) {
            BindingKey dependencyBindingKey = (BindingKey)fieldEntry.getKey();
            FrameworkField bindingField = (FrameworkField)fieldEntry.getValue();
            boolean useRawFrameworkType = !Accessibility.isTypeAccessibleFrom(dependencyBindingKey.key().type(), generatedTypeName.packageName());
            String fieldName = fieldNames.getUniqueName(bindingField.name());
            ParameterizedTypeName fieldType = useRawFrameworkType ? bindingField.type().rawType : bindingField.type();
            FieldSpec.Builder fieldBuilder = FieldSpec.builder((TypeName)fieldType, (String)fieldName, (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL});
            ParameterSpec.Builder parameterBuilder = ParameterSpec.builder((TypeName)fieldType, (String)fieldName, (Modifier[])new Modifier[0]);
            if (useRawFrameworkType) {
                usesRawFrameworkTypes = true;
                fieldBuilder.addAnnotation(AnnotationSpecs.suppressWarnings(AnnotationSpecs.Suppression.RAWTYPES, new AnnotationSpecs.Suppression[0]));
                parameterBuilder.addAnnotation(AnnotationSpecs.suppressWarnings(AnnotationSpecs.Suppression.RAWTYPES, new AnnotationSpecs.Suppression[0]));
            }
            constructorBuilder.addParameter(parameterBuilder.build());
            createMethodBuilder.addParameter(parameterBuilder.build());
            FieldSpec field = fieldBuilder.build();
            injectorTypeBuilder.addField(field);
            constructorBuilder.addStatement("assert $N != null", new Object[]{field});
            constructorBuilder.addStatement("this.$N = $N", new Object[]{field, field});
            dependencyFieldsBuilder.put((Object)dependencyBindingKey, (Object)field);
            constructorInvocationParameters.add((Object)CodeBlock.of((String)"$N", (Object[])new Object[]{field}));
        }
        createMethodBuilder.addCode(constructorInvocationParameters.build().stream().collect(CodeBlocks.toParametersCodeBlock()));
        createMethodBuilder.addCode(");", new Object[0]);
        injectorTypeBuilder.addMethod(constructorBuilder.build());
        injectorTypeBuilder.addMethod(createMethodBuilder.build());
        HashSet<String> delegateMethods = new HashSet<String>();
        ImmutableMap dependencyFields = dependencyFieldsBuilder.build();
        ArrayList<MethodSpec> injectMethodsForSubclasses = new ArrayList<MethodSpec>();
        for (MembersInjectionBinding.InjectionSite injectionSite : binding.injectionSites()) {
            injectMembersBuilder.addCode(Accessibility.isElementAccessibleFrom(injectionSite.element(), generatedTypeName.packageName()) ? this.directInjectMemberCodeBlock(binding, (ImmutableMap<BindingKey, FieldSpec>)dependencyFields, injectionSite) : this.delegateInjectMemberCodeBlock((ImmutableMap<BindingKey, FieldSpec>)dependencyFields, injectionSite));
            if (injectionSite.element().getModifiers().contains((Object)Modifier.PUBLIC) || !injectionSite.element().getEnclosingElement().equals(binding.membersInjectedType()) || !delegateMethods.add(MembersInjectorGenerator.injectionSiteDelegateMethodName(injectionSite.element()))) continue;
            injectMethodsForSubclasses.add(this.injectorMethodForSubclasses((ImmutableMap<BindingKey, FieldSpec>)dependencyFields, (List<TypeVariableName>)typeParameters, injectedTypeName, injectionSite.element(), injectionSite.dependencies()));
        }
        if (usesRawFrameworkTypes) {
            injectMembersBuilder.addAnnotation(AnnotationSpecs.suppressWarnings(AnnotationSpecs.Suppression.UNCHECKED, new AnnotationSpecs.Suppression[0]));
        }
        injectorTypeBuilder.addMethod(injectMembersBuilder.build());
        injectMethodsForSubclasses.forEach(arg_0 -> ((TypeSpec.Builder)injectorTypeBuilder).addMethod(arg_0));
        return Optional.of(injectorTypeBuilder);
    }

    private CodeBlock directInjectMemberCodeBlock(MembersInjectionBinding binding, ImmutableMap<BindingKey, FieldSpec> dependencyFields, MembersInjectionBinding.InjectionSite injectionSite) {
        return CodeBlock.of((String)(injectionSite.element().getKind().isField() ? "$L.$L = $L;" : "$L.$L($L);"), (Object[])new Object[]{this.getInstanceCodeBlockWithPotentialCast(injectionSite.element().getEnclosingElement(), binding.membersInjectedType()), injectionSite.element().getSimpleName(), CodeBlocks.makeParametersCodeBlock(this.parameterCodeBlocks(dependencyFields, injectionSite.dependencies(), true))});
    }

    private CodeBlock delegateInjectMemberCodeBlock(ImmutableMap<BindingKey, FieldSpec> dependencyFields, MembersInjectionBinding.InjectionSite injectionSite) {
        return CodeBlock.of((String)"$L.$L($L);", (Object[])new Object[]{SourceFiles.membersInjectorNameForType(MoreElements.asType(injectionSite.element().getEnclosingElement())), MembersInjectorGenerator.injectionSiteDelegateMethodName(injectionSite.element()), CodeBlocks.makeParametersCodeBlock((Iterable<CodeBlock>)new ImmutableList.Builder().add((Object)CodeBlock.of((String)"instance", (Object[])new Object[0])).addAll(this.parameterCodeBlocks(dependencyFields, injectionSite.dependencies(), false)).build())});
    }

    private ImmutableList<CodeBlock> parameterCodeBlocks(ImmutableMap<BindingKey, FieldSpec> dependencyFields, ImmutableSet<DependencyRequest> dependencies, boolean passValue) {
        ImmutableList.Builder parameters = ImmutableList.builder();
        for (DependencyRequest dependency : dependencies) {
            CodeBlock fieldCodeBlock = CodeBlock.of((String)"$L", (Object[])new Object[]{((FieldSpec)dependencyFields.get((Object)dependency.bindingKey())).name});
            parameters.add((Object)(passValue ? SourceFiles.frameworkTypeUsageStatement(fieldCodeBlock, dependency.kind()) : fieldCodeBlock));
        }
        return parameters.build();
    }

    private CodeBlock getInstanceCodeBlockWithPotentialCast(Element injectionSiteElement, Element bindingElement) {
        if (injectionSiteElement.equals(bindingElement)) {
            return CodeBlock.of((String)"instance", (Object[])new Object[0]);
        }
        TypeName injectionSiteName = TypeName.get((TypeMirror)injectionSiteElement.asType());
        if (injectionSiteName instanceof ParameterizedTypeName) {
            injectionSiteName = ((ParameterizedTypeName)injectionSiteName).rawType;
        }
        return CodeBlock.of((String)"(($T) instance)", (Object[])new Object[]{injectionSiteName});
    }

    private static String injectionSiteDelegateMethodName(Element injectionSiteElement) {
        return "inject" + CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, injectionSiteElement.getSimpleName().toString());
    }

    private MethodSpec injectorMethodForSubclasses(ImmutableMap<BindingKey, FieldSpec> dependencyFields, List<TypeVariableName> typeParameters, TypeName injectedTypeName, Element injectionElement, ImmutableSet<DependencyRequest> dependencies) {
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)MembersInjectorGenerator.injectionSiteDelegateMethodName(injectionElement)).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).addParameter(injectedTypeName, "instance", new Modifier[0]).addTypeVariables(typeParameters);
        ImmutableList.Builder providedParameters = ImmutableList.builder();
        HashSet<String> parameterNames = new HashSet<String>();
        for (DependencyRequest dependency : dependencies) {
            FieldSpec field = (FieldSpec)dependencyFields.get((Object)dependency.bindingKey());
            ParameterSpec parameter = ParameterSpec.builder((TypeName)field.type, (String)this.staticInjectMethodDependencyParameterName(parameterNames, dependency, field), (Modifier[])new Modifier[0]).build();
            methodBuilder.addParameter(parameter);
            providedParameters.add((Object)SourceFiles.frameworkTypeUsageStatement(CodeBlock.of((String)"$N", (Object[])new Object[]{parameter}), dependency.kind()));
        }
        if (injectionElement.getKind().isField()) {
            methodBuilder.addStatement("instance.$L = $L", new Object[]{injectionElement.getSimpleName(), Iterables.getOnlyElement((Iterable)providedParameters.build())});
        } else {
            methodBuilder.addStatement("instance.$L($L)", new Object[]{injectionElement.getSimpleName(), CodeBlocks.makeParametersCodeBlock((Iterable<CodeBlock>)providedParameters.build())});
        }
        return methodBuilder.build();
    }

    private String staticInjectMethodDependencyParameterName(Set<String> parameterNames, DependencyRequest dependency, FieldSpec field) {
        StringBuilder parameterName = new StringBuilder(dependency.requestElement().get().getSimpleName().toString());
        switch (dependency.kind()) {
            case LAZY: 
            case INSTANCE: 
            case FUTURE: {
                String suffix = ((ParameterizedTypeName)field.type).rawType.simpleName();
                if (parameterName.length() > suffix.length() && parameterName.substring(parameterName.length() - suffix.length()).equals(suffix)) break;
                parameterName.append(suffix);
                break;
            }
        }
        int baseLength = parameterName.length();
        int i = 2;
        while (!parameterNames.add(parameterName.toString())) {
            parameterName.replace(baseLength, parameterName.length(), String.valueOf(i));
            ++i;
        }
        return parameterName.toString();
    }
}

