/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.graph.MutableNetwork;
import com.google.common.graph.Network;
import com.google.common.graph.NetworkBuilder;
import dagger.internal.codegen.Binding;
import dagger.internal.codegen.BindingDeclaration;
import dagger.internal.codegen.BindingDeclarationFormatter;
import dagger.internal.codegen.BindingGraph;
import dagger.internal.codegen.BindingNodeImpl;
import dagger.internal.codegen.CompilerOptions;
import dagger.internal.codegen.ComponentDescriptor;
import dagger.internal.codegen.ComponentNodeImpl;
import dagger.internal.codegen.ComponentTreeTraverser;
import dagger.internal.codegen.DaggerStreams;
import dagger.internal.codegen.ResolvedBindings;
import dagger.model.BindingGraph;
import dagger.model.BindingGraphProxies;
import dagger.model.BindingKind;
import dagger.model.DependencyRequest;
import dagger.shaded.auto.common.MoreTypes;
import javax.inject.Inject;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;

final class BindingGraphConverter {
    private final BindingDeclarationFormatter bindingDeclarationFormatter;
    private final CompilerOptions compilerOptions;

    @Inject
    BindingGraphConverter(BindingDeclarationFormatter bindingDeclarationFormatter, CompilerOptions compilerOptions) {
        this.bindingDeclarationFormatter = bindingDeclarationFormatter;
        this.compilerOptions = compilerOptions;
    }

    dagger.model.BindingGraph convert(BindingGraph rootGraph) {
        Traverser traverser = new Traverser(rootGraph);
        traverser.traverseComponents();
        return BindingGraphProxies.bindingGraph((Network<BindingGraph.Node, BindingGraph.Edge>)traverser.network);
    }

    private final class Traverser
    extends ComponentTreeTraverser {
        private final MutableNetwork<BindingGraph.Node, BindingGraph.Edge> network;
        private BindingGraph.ComponentNode parentComponent;
        private BindingGraph.ComponentNode currentComponent;

        Traverser(BindingGraph graph) {
            super(graph, BindingGraphConverter.this.compilerOptions);
            this.network = NetworkBuilder.directed().allowsParallelEdges(true).allowsSelfLoops(true).build();
        }

        @Override
        protected void visitComponent(BindingGraph graph) {
            BindingGraph.ComponentNode grandparentComponent = this.parentComponent;
            this.parentComponent = this.currentComponent;
            this.currentComponent = ComponentNodeImpl.create(this.componentTreePath().toComponentPath(), graph.componentDescriptor());
            this.network.addNode((Object)this.currentComponent);
            for (ComponentDescriptor.ComponentMethodDescriptor method : graph.componentDescriptor().entryPointMethods()) {
                this.addDependencyEdges((BindingGraph.Node)this.currentComponent, method.dependencyRequest().get());
            }
            for (ResolvedBindings resolvedBindings : graph.resolvedBindings()) {
                for (BindingGraph.BindingNode node : this.bindingNodes(resolvedBindings)) {
                    this.addBindingNode(node);
                    if (!node.binding().kind().equals((Object)BindingKind.SUBCOMPONENT_BUILDER) || !node.componentPath().equals(this.currentComponent.componentPath())) continue;
                    this.network.addEdge((Object)node, (Object)this.subcomponentNode(node.binding().key().type(), graph), (Object)BindingGraphProxies.subcomponentBuilderBindingEdge(this.subcomponentDeclaringModules(resolvedBindings)));
                }
            }
            super.visitComponent(graph);
            this.currentComponent = this.parentComponent;
            this.parentComponent = grandparentComponent;
        }

        @Override
        protected void visitSubcomponentFactoryMethod(BindingGraph graph, BindingGraph parent, ExecutableElement factoryMethod) {
            this.network.addEdge((Object)this.parentComponent, (Object)this.currentComponent, (Object)BindingGraphProxies.childFactoryMethodEdge(factoryMethod));
            super.visitSubcomponentFactoryMethod(graph, parent, factoryMethod);
        }

        private void addDependencyEdges(BindingGraph.Node source, DependencyRequest dependencyRequest) {
            ResolvedBindings dependencies = this.resolvedDependencies(source, dependencyRequest);
            if (dependencies.isEmpty()) {
                this.addDependencyEdge(source, dependencyRequest, (BindingGraph.Node)this.missingBindingNode(dependencies));
            } else {
                for (BindingGraph.BindingNode dependency : this.bindingNodes(dependencies)) {
                    this.addDependencyEdge(source, dependencyRequest, (BindingGraph.Node)dependency);
                }
            }
        }

        private void addDependencyEdge(BindingGraph.Node source, DependencyRequest dependencyRequest, BindingGraph.Node dependency) {
            this.network.addNode((Object)dependency);
            if (!this.hasDependencyEdge(source, dependency, dependencyRequest)) {
                this.network.addEdge((Object)source, (Object)dependency, (Object)BindingGraphProxies.dependencyEdge(dependencyRequest, source instanceof BindingGraph.ComponentNode));
            }
        }

        private boolean hasDependencyEdge(BindingGraph.Node source, BindingGraph.Node dependency, DependencyRequest dependencyRequest) {
            return this.network.edgesConnecting((Object)source, (Object)dependency).stream().flatMap(DaggerStreams.instancesOf(BindingGraph.DependencyEdge.class)).anyMatch(edge -> edge.dependencyRequest().equals(dependencyRequest));
        }

        private ResolvedBindings resolvedDependencies(BindingGraph.Node source, DependencyRequest dependencyRequest) {
            return this.componentTreePath().pathFromRootToAncestor(source.componentPath().currentComponent()).currentGraph().resolvedBindings(dependencyRequest.kind(), dependencyRequest.key());
        }

        private void addBindingNode(BindingGraph.BindingNode node) {
            this.network.addNode((Object)node);
            for (DependencyRequest dependencyRequest : node.binding().dependencies()) {
                this.addDependencyEdges((BindingGraph.Node)node, dependencyRequest);
            }
        }

        private ImmutableSet<BindingGraph.BindingNode> bindingNodes(ResolvedBindings resolvedBindings) {
            ImmutableSet.Builder bindingNodes = ImmutableSet.builder();
            resolvedBindings.allBindings().asMap().forEach((component, bindings) -> {
                for (Binding binding : bindings) {
                    bindingNodes.add((Object)this.bindingNode(resolvedBindings, binding, (ComponentDescriptor)component));
                }
            });
            return bindingNodes.build();
        }

        private BindingGraph.BindingNode bindingNode(ResolvedBindings resolvedBindings, Binding binding, ComponentDescriptor owningComponent) {
            return BindingNodeImpl.create(this.componentTreePath().pathFromRootToAncestor(owningComponent.componentDefinitionType()).toComponentPath(), binding, this.associatedDeclaringElements(resolvedBindings), () -> BindingGraphConverter.this.bindingDeclarationFormatter.format(binding));
        }

        private Iterable<BindingDeclaration> associatedDeclaringElements(ResolvedBindings resolvedBindings) {
            return Iterables.concat(resolvedBindings.multibindingDeclarations(), resolvedBindings.optionalBindingDeclarations(), resolvedBindings.subcomponentDeclarations());
        }

        private BindingGraph.MissingBindingNode missingBindingNode(ResolvedBindings dependencies) {
            return BindingGraphProxies.missingBindingNode(this.componentTreePath().pathFromRootToAncestor(dependencies.owningComponent().componentDefinitionType()).toComponentPath(), dependencies.key());
        }

        private BindingGraph.ComponentNode subcomponentNode(TypeMirror subcomponentBuilderType, BindingGraph graph) {
            TypeElement subcomponentBuilderElement = MoreTypes.asTypeElement(subcomponentBuilderType);
            ComponentDescriptor subcomponent = (ComponentDescriptor)graph.componentDescriptor().subcomponentsByBuilderType().get((Object)subcomponentBuilderElement);
            return ComponentNodeImpl.create(this.componentTreePath().childPath(subcomponent.componentDefinitionType()).toComponentPath(), subcomponent);
        }

        private ImmutableSet<TypeElement> subcomponentDeclaringModules(ResolvedBindings resolvedBindings) {
            return resolvedBindings.subcomponentDeclarations().stream().map(BindingDeclaration::contributingModule).flatMap(DaggerStreams.presentValues()).collect(DaggerStreams.toImmutableSet());
        }
    }
}

