/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import dagger.internal.codegen.DaggerStreams;
import dagger.internal.codegen.DiagnosticReporterFactory;
import dagger.model.BindingGraph;
import dagger.spi.BindingGraphPlugin;
import dagger.spi.DiagnosticReporter;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.Filer;
import javax.inject.Qualifier;
import javax.inject.Singleton;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;

@Singleton
final class BindingGraphPlugins {
    private final ImmutableSet<BindingGraphPlugin> plugins;
    private final Filer filer;
    private final Types types;
    private final Elements elements;
    private final Map<String, String> processingOptions;
    private final DiagnosticReporterFactory diagnosticReporterFactory;

    BindingGraphPlugins(Iterable<BindingGraphPlugin> plugins, Filer filer, Types types, Elements elements, Map<String, String> processingOptions, DiagnosticReporterFactory diagnosticReporterFactory) {
        this.plugins = ImmutableSet.copyOf(plugins);
        this.filer = (Filer)Preconditions.checkNotNull((Object)filer);
        this.types = (Types)Preconditions.checkNotNull((Object)types);
        this.elements = (Elements)Preconditions.checkNotNull((Object)elements);
        this.processingOptions = (Map)Preconditions.checkNotNull(processingOptions);
        this.diagnosticReporterFactory = (DiagnosticReporterFactory)Preconditions.checkNotNull((Object)diagnosticReporterFactory);
    }

    ImmutableSet<String> allSupportedOptions() {
        return this.plugins.stream().flatMap(plugin -> plugin.supportedOptions().stream()).collect(DaggerStreams.toImmutableSet());
    }

    void initializePlugins() {
        this.plugins.forEach(this::initializePlugin);
    }

    private void initializePlugin(BindingGraphPlugin plugin) {
        plugin.initFiler(this.filer);
        plugin.initTypes(this.types);
        plugin.initElements(this.elements);
        Set supportedOptions = plugin.supportedOptions();
        if (!supportedOptions.isEmpty()) {
            plugin.initOptions(Maps.filterKeys(this.processingOptions, supportedOptions::contains));
        }
    }

    ImmutableSet<Diagnostic.Kind> visitGraph(BindingGraph graph) {
        ImmutableSet.Builder diagnosticKinds = ImmutableSet.builder();
        for (BindingGraphPlugin plugin : this.plugins) {
            DiagnosticReporterFactory.DiagnosticReporterImpl reporter = this.diagnosticReporterFactory.reporter(graph, plugin);
            plugin.visitGraph(graph, (DiagnosticReporter)reporter);
            diagnosticKinds.addAll(reporter.reportedDiagnosticKinds());
        }
        return diagnosticKinds.build();
    }

    boolean pluginsReportErrors(BindingGraph graph) {
        return this.visitGraph(graph).contains((Object)Diagnostic.Kind.ERROR);
    }

    @Qualifier
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD})
    static @interface TestingPlugins {
    }
}

