/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.collect.ImmutableSet;
import dagger.BindsOptionalOf;
import dagger.Module;
import dagger.internal.codegen.BindingMethodValidator;
import dagger.internal.codegen.DaggerElements;
import dagger.internal.codegen.InjectionAnnotations;
import dagger.internal.codegen.Keys;
import dagger.internal.codegen.Scopes;
import dagger.internal.codegen.ValidationReport;
import dagger.model.Scope;
import dagger.producers.ProducerModule;
import dagger.shaded.auto.common.MoreElements;
import dagger.shaded.auto.common.MoreTypes;
import java.lang.annotation.Annotation;
import javax.inject.Inject;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;

final class BindsOptionalOfMethodValidator
extends BindingMethodValidator {
    private final Types types;

    @Inject
    BindsOptionalOfMethodValidator(DaggerElements elements, Types types) {
        super(elements, types, BindsOptionalOf.class, (Iterable<? extends Class<? extends Annotation>>)ImmutableSet.of(Module.class, ProducerModule.class), BindingMethodValidator.Abstractness.MUST_BE_ABSTRACT, BindingMethodValidator.ExceptionSuperclass.NO_EXCEPTIONS, BindingMethodValidator.AllowsMultibindings.NO_MULTIBINDINGS);
        this.types = types;
    }

    @Override
    protected void checkMethod(ValidationReport.Builder<ExecutableElement> builder) {
        super.checkMethod(builder);
        this.checkParameters(builder);
    }

    @Override
    protected void checkKeyType(ValidationReport.Builder<ExecutableElement> builder, TypeMirror keyType) {
        super.checkKeyType(builder, keyType);
        if (Keys.isValidImplicitProvisionKey(InjectionAnnotations.getQualifiers(builder.getSubject()).stream().findFirst(), keyType, this.types) && !InjectionAnnotations.injectedConstructors(MoreElements.asType(MoreTypes.asDeclared(keyType).asElement())).isEmpty()) {
            builder.addError("@BindsOptionalOf methods cannot return unqualified types that have an @Inject-annotated constructor because those are always present");
        }
    }

    private void checkParameters(ValidationReport.Builder<ExecutableElement> builder) {
        if (!builder.getSubject().getParameters().isEmpty()) {
            builder.addError("@BindsOptionalOf methods cannot have parameters");
        }
    }

    @Override
    protected void checkScopes(ValidationReport.Builder<ExecutableElement> builder) {
        for (Scope scope : Scopes.scopesOf(builder.getSubject())) {
            builder.addError("@BindsOptionalOf methods cannot be scoped", builder.getSubject(), scope.scopeAnnotation());
        }
    }
}

