/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.collect.ImmutableSet;
import dagger.internal.codegen.Accessibility;
import dagger.internal.codegen.CompilerOptions;
import dagger.internal.codegen.DaggerElements;
import dagger.internal.codegen.ErrorMessages;
import dagger.internal.codegen.FrameworkTypes;
import dagger.internal.codegen.InjectionAnnotations;
import dagger.internal.codegen.Scopes;
import dagger.internal.codegen.ValidationReport;
import dagger.model.Scope;
import dagger.shaded.auto.common.MoreElements;
import dagger.shaded.auto.common.MoreTypes;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;

final class InjectValidator {
    private final Types types;
    private final DaggerElements elements;
    private final CompilerOptions compilerOptions;
    private final Optional<Diagnostic.Kind> privateAndStaticInjectionDiagnosticKind;

    @Inject
    InjectValidator(Types types, DaggerElements elements, CompilerOptions compilerOptions) {
        this(types, elements, compilerOptions, Optional.empty());
    }

    private InjectValidator(Types types, DaggerElements elements, CompilerOptions compilerOptions, Optional<Diagnostic.Kind> privateAndStaticInjectionDiagnosticKind) {
        this.types = types;
        this.elements = elements;
        this.compilerOptions = compilerOptions;
        this.privateAndStaticInjectionDiagnosticKind = privateAndStaticInjectionDiagnosticKind;
    }

    InjectValidator whenGeneratingCode() {
        return this.compilerOptions.ignorePrivateAndStaticInjectionForComponent() ? new InjectValidator(this.types, this.elements, this.compilerOptions, Optional.of(Diagnostic.Kind.ERROR)) : this;
    }

    ValidationReport<TypeElement> validateConstructor(ExecutableElement constructorElement) {
        ImmutableSet<Scope> scopes;
        ImmutableSet<ExecutableElement> injectConstructors;
        ValidationReport.Builder<TypeElement> builder = ValidationReport.about(MoreElements.asType(constructorElement.getEnclosingElement()));
        if (constructorElement.getModifiers().contains((Object)Modifier.PRIVATE)) {
            builder.addError("Dagger does not support injection into private constructors", constructorElement);
        }
        for (AnnotationMirror qualifier : InjectionAnnotations.getQualifiers(constructorElement)) {
            builder.addError("@Qualifier annotations are not allowed on @Inject constructors", constructorElement, qualifier);
        }
        for (Scope scope : Scopes.scopesOf(constructorElement)) {
            builder.addError("@Scope annotations are not allowed on @Inject constructors; annotate the class instead", constructorElement, scope.scopeAnnotation());
        }
        for (VariableElement parameter : constructorElement.getParameters()) {
            this.checkMultipleQualifiers(constructorElement, parameter, builder);
            if (!FrameworkTypes.isProducerType(parameter.asType())) continue;
            builder.addError(ErrorMessages.provisionMayNotDependOnProducerType(parameter.asType()), parameter);
        }
        if (this.throwsCheckedExceptions(constructorElement)) {
            builder.addItem("Dagger does not support checked exceptions on @Inject constructors", this.privateAndStaticInjectionDiagnosticKind.orElse(this.compilerOptions.privateMemberValidationKind()), constructorElement);
        }
        this.checkInjectIntoPrivateClass(constructorElement, builder);
        TypeElement enclosingElement = MoreElements.asType(constructorElement.getEnclosingElement());
        Set<Modifier> typeModifiers = enclosingElement.getModifiers();
        if (typeModifiers.contains((Object)Modifier.ABSTRACT)) {
            builder.addError("@Inject is nonsense on the constructor of an abstract class", constructorElement);
        }
        if (enclosingElement.getNestingKind().isNested() && !typeModifiers.contains((Object)Modifier.STATIC)) {
            builder.addError("@Inject constructors are invalid on inner classes. Did you mean to make the class static?", constructorElement);
        }
        if ((injectConstructors = InjectionAnnotations.injectedConstructors(enclosingElement)).size() > 1) {
            builder.addError("Types may only contain one @Inject constructor", constructorElement);
        }
        if ((scopes = Scopes.scopesOf(enclosingElement)).size() > 1) {
            for (Scope scope : scopes) {
                builder.addError("A single binding may not declare more than one @Scope", enclosingElement, scope.scopeAnnotation());
            }
        }
        return builder.build();
    }

    private ValidationReport<VariableElement> validateField(VariableElement fieldElement) {
        ValidationReport.Builder<VariableElement> builder = ValidationReport.about(fieldElement);
        Set<Modifier> modifiers = fieldElement.getModifiers();
        if (modifiers.contains((Object)Modifier.FINAL)) {
            builder.addError("@Inject fields may not be final", fieldElement);
        }
        if (modifiers.contains((Object)Modifier.PRIVATE)) {
            builder.addItem("Dagger does not support injection into private fields", this.privateAndStaticInjectionDiagnosticKind.orElse(this.compilerOptions.privateMemberValidationKind()), fieldElement);
        }
        if (modifiers.contains((Object)Modifier.STATIC)) {
            builder.addItem("Dagger does not support injection into static fields", this.privateAndStaticInjectionDiagnosticKind.orElse(this.compilerOptions.staticMemberValidationKind()), fieldElement);
        }
        this.checkMultipleQualifiers(fieldElement, fieldElement, builder);
        if (FrameworkTypes.isProducerType(fieldElement.asType())) {
            builder.addError(ErrorMessages.provisionMayNotDependOnProducerType(fieldElement.asType()), fieldElement);
        }
        return builder.build();
    }

    private ValidationReport<ExecutableElement> validateMethod(ExecutableElement methodElement) {
        ValidationReport.Builder<ExecutableElement> builder = ValidationReport.about(methodElement);
        Set<Modifier> modifiers = methodElement.getModifiers();
        if (modifiers.contains((Object)Modifier.ABSTRACT)) {
            builder.addError("Methods with @Inject may not be abstract", methodElement);
        }
        if (modifiers.contains((Object)Modifier.PRIVATE)) {
            builder.addItem("Dagger does not support injection into private methods", this.privateAndStaticInjectionDiagnosticKind.orElse(this.compilerOptions.privateMemberValidationKind()), methodElement);
        }
        if (modifiers.contains((Object)Modifier.STATIC)) {
            builder.addItem("Dagger does not support injection into static methods", this.privateAndStaticInjectionDiagnosticKind.orElse(this.compilerOptions.staticMemberValidationKind()), methodElement);
        }
        if (!methodElement.getTypeParameters().isEmpty()) {
            builder.addError("Methods with @Inject may not declare type parameters", methodElement);
        }
        for (VariableElement variableElement : methodElement.getParameters()) {
            this.checkMultipleQualifiers(methodElement, variableElement, builder);
            if (!FrameworkTypes.isProducerType(variableElement.asType())) continue;
            builder.addError(ErrorMessages.provisionMayNotDependOnProducerType(variableElement.asType()), variableElement);
        }
        return builder.build();
    }

    ValidationReport<TypeElement> validateMembersInjectionType(TypeElement typeElement) {
        ValidationReport<TypeElement> validationReport;
        TypeMirror superclass;
        ValidationReport.Builder<TypeElement> builder = ValidationReport.about(typeElement);
        boolean hasInjectedMembers = false;
        for (VariableElement variableElement : ElementFilter.fieldsIn(typeElement.getEnclosedElements())) {
            if (!MoreElements.isAnnotationPresent(variableElement, Inject.class)) continue;
            hasInjectedMembers = true;
            ValidationReport<VariableElement> report2 = this.validateField(variableElement);
            if (report2.isClean()) continue;
            builder.addSubreport(report2);
        }
        for (ExecutableElement executableElement : ElementFilter.methodsIn(typeElement.getEnclosedElements())) {
            if (!MoreElements.isAnnotationPresent(executableElement, Inject.class)) continue;
            hasInjectedMembers = true;
            ValidationReport<ExecutableElement> report = this.validateMethod(executableElement);
            if (report.isClean()) continue;
            builder.addSubreport(report);
        }
        if (hasInjectedMembers) {
            this.checkInjectIntoPrivateClass(typeElement, builder);
        }
        if (!(superclass = typeElement.getSuperclass()).getKind().equals((Object)TypeKind.NONE) && !(validationReport = this.validateType(MoreTypes.asTypeElement(superclass))).isClean()) {
            builder.addSubreport(validationReport);
        }
        return builder.build();
    }

    ValidationReport<TypeElement> validateType(TypeElement typeElement) {
        ValidationReport.Builder<TypeElement> builder = ValidationReport.about(typeElement);
        ValidationReport<TypeElement> membersInjectionReport = this.validateMembersInjectionType(typeElement);
        if (!membersInjectionReport.isClean()) {
            builder.addSubreport(membersInjectionReport);
        }
        for (ExecutableElement element : ElementFilter.constructorsIn(typeElement.getEnclosedElements())) {
            ValidationReport<TypeElement> report;
            if (!MoreElements.isAnnotationPresent(element, Inject.class) || (report = this.validateConstructor(element)).isClean()) continue;
            builder.addSubreport(report);
        }
        return builder.build();
    }

    boolean isValidType(TypeMirror type) {
        if (!type.getKind().equals((Object)TypeKind.DECLARED)) {
            return true;
        }
        return this.validateType(MoreTypes.asTypeElement(type)).isClean();
    }

    private boolean throwsCheckedExceptions(ExecutableElement methodElement) {
        TypeMirror runtimeExceptionType = this.elements.getTypeElement(RuntimeException.class).asType();
        TypeMirror errorType = this.elements.getTypeElement(Error.class).asType();
        for (TypeMirror typeMirror : methodElement.getThrownTypes()) {
            if (this.types.isSubtype(typeMirror, runtimeExceptionType) || this.types.isSubtype(typeMirror, errorType)) continue;
            return true;
        }
        return false;
    }

    private void checkMultipleQualifiers(Element errorElement, Element qualifiedElement, ValidationReport.Builder<?> builder) {
        ImmutableSet<? extends AnnotationMirror> qualifiers = InjectionAnnotations.getQualifiers(qualifiedElement);
        if (qualifiers.size() > 1) {
            for (AnnotationMirror qualifier : qualifiers) {
                builder.addError("A single injection site may not use more than one @Qualifier", errorElement, qualifier);
            }
        }
    }

    private void checkInjectIntoPrivateClass(Element element, ValidationReport.Builder<TypeElement> builder) {
        if (!Accessibility.isElementAccessibleFromOwnPackage(DaggerElements.closestEnclosingTypeElement(element))) {
            builder.addItem("Dagger does not support injection into private classes", this.privateAndStaticInjectionDiagnosticKind.orElse(this.compilerOptions.privateMemberValidationKind()), element);
        }
    }
}

