/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.SetMultimap;
import dagger.MapKey;
import dagger.internal.codegen.AnnotationCreatorGenerator;
import dagger.internal.codegen.MapKeyValidator;
import dagger.internal.codegen.MapKeys;
import dagger.internal.codegen.UnwrappedMapKeyGenerator;
import dagger.internal.codegen.ValidationReport;
import dagger.shaded.auto.common.BasicAnnotationProcessor;
import dagger.shaded.auto.common.MoreTypes;
import java.lang.annotation.Annotation;
import java.util.Set;
import javax.annotation.processing.Messager;
import javax.inject.Inject;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Types;

public class MapKeyProcessingStep
implements BasicAnnotationProcessor.ProcessingStep {
    private final Messager messager;
    private final Types types;
    private final MapKeyValidator mapKeyValidator;
    private final AnnotationCreatorGenerator annotationCreatorGenerator;
    private final UnwrappedMapKeyGenerator unwrappedMapKeyGenerator;

    @Inject
    MapKeyProcessingStep(Messager messager, Types types, MapKeyValidator mapKeyValidator, AnnotationCreatorGenerator annotationCreatorGenerator, UnwrappedMapKeyGenerator unwrappedMapKeyGenerator) {
        this.messager = messager;
        this.types = types;
        this.mapKeyValidator = mapKeyValidator;
        this.annotationCreatorGenerator = annotationCreatorGenerator;
        this.unwrappedMapKeyGenerator = unwrappedMapKeyGenerator;
    }

    public Set<Class<? extends Annotation>> annotations() {
        return ImmutableSet.of(MapKey.class);
    }

    public Set<Element> process(SetMultimap<Class<? extends Annotation>, Element> elementsByAnnotation) {
        for (TypeElement mapKeyAnnotationType : ElementFilter.typesIn(elementsByAnnotation.get(MapKey.class))) {
            ValidationReport<Element> mapKeyReport = this.mapKeyValidator.validate(mapKeyAnnotationType);
            mapKeyReport.printMessagesTo(this.messager);
            if (!mapKeyReport.isClean()) continue;
            MapKey mapkey = mapKeyAnnotationType.getAnnotation(MapKey.class);
            if (!mapkey.unwrapValue()) {
                this.annotationCreatorGenerator.generate(mapKeyAnnotationType, this.messager);
                continue;
            }
            if (!this.unwrappedValueKind(mapKeyAnnotationType).equals((Object)ElementKind.ANNOTATION_TYPE)) continue;
            this.unwrappedMapKeyGenerator.generate(mapKeyAnnotationType, this.messager);
        }
        return ImmutableSet.of();
    }

    private ElementKind unwrappedValueKind(TypeElement mapKeyAnnotationType) {
        DeclaredType unwrappedMapKeyType = MapKeys.getUnwrappedMapKeyType(MoreTypes.asDeclared(mapKeyAnnotationType.asType()), this.types);
        return unwrappedMapKeyType.asElement().getKind();
    }
}

