/*
 * Decompiled with CFR 0.152.
 */
package dagger.errorprone;

import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import dagger.multibindings.ClassKey;
import dagger.multibindings.IntoMap;

@BugPattern(name="AndroidInjectorBindingMigrator", providesFix=BugPattern.ProvidesFix.REQUIRES_HUMAN_ATTENTION, summary="A refactoring to update AndroidInjector bindings to their new form.", explanation="dagger.android is migrating the mechanism used to bind AndroidInjectors. This refactoring will migrate usages of the `dagger.android` class-based map keys to `@dagger.multibindings.ClassKey` and also modify the return type of those binding methods to AndroidInjector.Factory<?> (from AndroidInjector.Factory<? extends Activity>).", severity=BugPattern.SeverityLevel.SUGGESTION)
public final class AndroidInjectorBindingMigrator
extends BugChecker
implements BugChecker.MethodTreeMatcher {
    private static final String ANDROID_INJECTOR_FACTORY = "dagger.android.AndroidInjector$Factory";
    private static final String CLASS_KEY = ClassKey.class.getName();
    private static final String ANDROID_INJECTION_KEY = "dagger.android.AndroidInjectionKey";

    public Description matchMethod(MethodTree tree, VisitorState state) {
        Type typeParameter;
        if (!ASTHelpers.hasAnnotation((Tree)tree, IntoMap.class, (VisitorState)state)) {
            return Description.NO_MATCH;
        }
        Symbol androidInjectorFactory = state.getSymbolFromString(ANDROID_INJECTOR_FACTORY);
        if (androidInjectorFactory == null) {
            return Description.NO_MATCH;
        }
        SuggestedFix.Builder suggestedFix = SuggestedFix.builder();
        Types types = state.getTypes();
        if (!androidInjectorFactory.equals(ASTHelpers.getSymbol((Tree)tree.getReturnType()))) {
            return Description.NO_MATCH;
        }
        Type.ClassType bindingType = (Type.ClassType)ASTHelpers.getType((Tree)tree.getReturnType());
        if (bindingType.isParameterized() && (typeParameter = (Type)Iterables.getOnlyElement((Iterable)bindingType.getTypeArguments())) instanceof Type.WildcardType && ((Type.WildcardType)typeParameter).getExtendsBound() != null) {
            suggestedFix.replace(tree.getReturnType(), "AndroidInjector.Factory<?>");
        }
        Type classKey = state.getTypeFromString(CLASS_KEY);
        Type androidInjectionKey = state.getTypeFromString(ANDROID_INJECTION_KEY);
        for (AnnotationTree annotationTree : tree.getModifiers().getAnnotations()) {
            Type annotationType = ASTHelpers.getType((Tree)annotationTree.getAnnotationType());
            if (!ASTHelpers.hasAnnotation((Symbol)annotationType.tsym, (String)"dagger.MapKey", (VisitorState)state) || types.isSameType(annotationType, classKey) || types.isSameType(annotationType, androidInjectionKey)) continue;
            suggestedFix.replace(annotationTree.getAnnotationType(), "ClassKey").addImport(CLASS_KEY);
        }
        if (suggestedFix.isEmpty()) {
            return Description.NO_MATCH;
        }
        return this.buildDescription(tree).addFix((Fix)suggestedFix.build()).build();
    }
}

