/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimaps;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import dagger.internal.codegen.AnnotationSpecs;
import dagger.internal.codegen.BindingGraph;
import dagger.internal.codegen.BindingGraphFactory;
import dagger.internal.codegen.CodeBlocks;
import dagger.internal.codegen.CompilerOptions;
import dagger.internal.codegen.ComponentBindingExpressions;
import dagger.internal.codegen.ComponentDescriptor;
import dagger.internal.codegen.ComponentGenerator;
import dagger.internal.codegen.ComponentRequirementFields;
import dagger.internal.codegen.DaggerElements;
import dagger.internal.codegen.DaggerStreams;
import dagger.internal.codegen.DaggerTypes;
import dagger.internal.codegen.GeneratedComponentBuilderModel;
import dagger.internal.codegen.GeneratedComponentModel;
import dagger.internal.codegen.KeyFactory;
import dagger.internal.codegen.MethodSignature;
import dagger.internal.codegen.ModifiableBindingMethods;
import dagger.internal.codegen.ModifiableBindingType;
import dagger.internal.codegen.OptionalFactories;
import dagger.producers.CancellationPolicy;
import dagger.producers.internal.CancellationListener;
import dagger.shaded.auto.common.MoreElements;
import dagger.shaded.auto.common.MoreTypes;
import java.util.List;
import java.util.Optional;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.util.Types;

abstract class ComponentModelBuilder {
    private final DaggerElements elements;
    private final DaggerTypes types;
    private final KeyFactory keyFactory;
    private final BindingGraph graph;
    private final ComponentBindingExpressions bindingExpressions;
    private final ComponentRequirementFields componentRequirementFields;
    private final GeneratedComponentModel generatedComponentModel;
    private final OptionalFactories optionalFactories;
    private final Optional<GeneratedComponentBuilderModel> generatedComponentBuilderModel;
    private final BindingGraphFactory bindingGraphFactory;
    private final CompilerOptions compilerOptions;
    private boolean done;
    private static final int STATEMENTS_PER_METHOD = 100;
    private static final String CANCELLATION_LISTENER_METHOD_NAME = "onProducerFutureCancelled";

    static GeneratedComponentModel buildComponentModel(DaggerTypes types, DaggerElements elements, KeyFactory keyFactory, CompilerOptions compilerOptions, ClassName name, BindingGraph graph, BindingGraphFactory bindingGraphFactory) {
        GeneratedComponentModel generatedComponentModel = GeneratedComponentModel.create(name, graph, keyFactory);
        OptionalFactories optionalFactories = new OptionalFactories(generatedComponentModel);
        Optional<GeneratedComponentBuilderModel> generatedComponentBuilderModel = GeneratedComponentBuilderModel.create(generatedComponentModel, graph, elements, types);
        ComponentRequirementFields componentRequirementFields = new ComponentRequirementFields(graph, generatedComponentModel, generatedComponentBuilderModel);
        ComponentBindingExpressions bindingExpressions = new ComponentBindingExpressions(graph, generatedComponentModel, componentRequirementFields, optionalFactories, types, elements, compilerOptions);
        if (generatedComponentModel.isAbstract()) {
            Preconditions.checkState((boolean)compilerOptions.aheadOfTimeSubcomponents(), (String)"Calling 'buildComponentModel()' on %s when not generating ahead-of-time subcomponents.", (Object)graph.componentDescriptor().componentDefinitionType());
            return new SubComponentModelBuilder(Optional.empty(), types, elements, keyFactory, graph, generatedComponentModel, optionalFactories, bindingExpressions, componentRequirementFields, generatedComponentBuilderModel, bindingGraphFactory, compilerOptions).build();
        }
        return new RootComponentModelBuilder(types, elements, keyFactory, graph, generatedComponentModel, optionalFactories, bindingExpressions, componentRequirementFields, generatedComponentBuilderModel, bindingGraphFactory, compilerOptions).build();
    }

    private ComponentModelBuilder(DaggerTypes types, DaggerElements elements, KeyFactory keyFactory, BindingGraph graph, GeneratedComponentModel generatedComponentModel, OptionalFactories optionalFactories, ComponentBindingExpressions bindingExpressions, ComponentRequirementFields componentRequirementFields, Optional<GeneratedComponentBuilderModel> generatedComponentBuilderModel, BindingGraphFactory bindingGraphFactory, CompilerOptions compilerOptions) {
        this.types = types;
        this.elements = elements;
        this.keyFactory = keyFactory;
        this.graph = graph;
        this.generatedComponentModel = generatedComponentModel;
        this.optionalFactories = optionalFactories;
        this.bindingExpressions = bindingExpressions;
        this.componentRequirementFields = componentRequirementFields;
        this.generatedComponentBuilderModel = generatedComponentBuilderModel;
        this.bindingGraphFactory = bindingGraphFactory;
        this.compilerOptions = compilerOptions;
    }

    protected final GeneratedComponentModel build() {
        Preconditions.checkState((!this.done ? 1 : 0) != 0, (String)"ComponentModelBuilder has already built the GeneratedComponentModel for [%s].", (Object)this.generatedComponentModel.name());
        this.setSupertype();
        this.generatedComponentBuilderModel.map(GeneratedComponentBuilderModel::typeSpec).ifPresent(this::addBuilderClass);
        MoreElements.getLocalAndInheritedMethods(this.graph.componentDescriptor().componentDefinitionType(), this.types, this.elements).forEach(method -> this.generatedComponentModel.claimMethodName(method.getSimpleName()));
        this.addFactoryMethods();
        this.addInterfaceMethods();
        this.addSubcomponents();
        this.addConstructor();
        if (this.graph.componentDescriptor().kind().isProducer()) {
            this.addCancellationListenerImplementation();
        }
        this.done = true;
        return this.generatedComponentModel;
    }

    private void setSupertype() {
        if (this.generatedComponentModel.supermodel().isPresent()) {
            this.generatedComponentModel.addSuperclass(this.generatedComponentModel.supermodel().get().name());
        } else {
            this.generatedComponentModel.addSupertype(this.graph.componentType());
        }
    }

    protected abstract void addBuilderClass(TypeSpec var1);

    protected abstract void addFactoryMethods();

    protected void addInterfaceMethods() {
        ImmutableListMultimap componentMethodsBySignature = Multimaps.index(this.graph.componentDescriptor().entryPointMethods(), this::getMethodSignature);
        for (List methodsWithSameSignature : Multimaps.asMap((ListMultimap)componentMethodsBySignature).values()) {
            ComponentDescriptor.ComponentMethodDescriptor anyOneMethod = (ComponentDescriptor.ComponentMethodDescriptor)methodsWithSameSignature.stream().findAny().get();
            MethodSpec methodSpec = this.bindingExpressions.getComponentMethod(anyOneMethod);
            ModifiableBindingType modifiableBindingType = this.bindingExpressions.modifiableBindingExpressions().registerComponentMethodIfModifiable(anyOneMethod, methodSpec);
            if (!modifiableBindingType.hasBaseClassImplementation()) continue;
            this.generatedComponentModel.addMethod(GeneratedComponentModel.MethodSpecKind.COMPONENT_METHOD, methodSpec);
        }
    }

    private void addCancellationListenerImplementation() {
        this.generatedComponentModel.addSupertype(this.elements.getTypeElement(CancellationListener.class));
        this.generatedComponentModel.claimMethodName(CANCELLATION_LISTENER_METHOD_NAME);
        ImmutableList cancellationStatements = this.generatedComponentModel.getCancellations().reverse();
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)CANCELLATION_LISTENER_METHOD_NAME).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).addParameter(Boolean.TYPE, "mayInterruptIfRunning", new Modifier[0]);
        if (this.generatedComponentModel.supermodel().isPresent()) {
            methodBuilder.addStatement("super.$L($L)", new Object[]{CANCELLATION_LISTENER_METHOD_NAME, "mayInterruptIfRunning"});
        }
        if (cancellationStatements.size() < 100) {
            methodBuilder.addCode(CodeBlocks.concat((Iterable<CodeBlock>)cancellationStatements)).build();
        } else {
            List partitions = Lists.partition((List)cancellationStatements, (int)100);
            for (List partition : partitions) {
                String methodName = this.generatedComponentModel.getUniqueMethodName("cancelProducers");
                MethodSpec method = MethodSpec.methodBuilder((String)methodName).addModifiers(new Modifier[]{Modifier.PRIVATE}).addParameter(Boolean.TYPE, "mayInterruptIfRunning", new Modifier[0]).addCode(CodeBlocks.concat(partition)).build();
                methodBuilder.addStatement("$N($L)", new Object[]{method, "mayInterruptIfRunning"});
                this.generatedComponentModel.addMethod(GeneratedComponentModel.MethodSpecKind.CANCELLATION_LISTENER_METHOD, method);
            }
        }
        this.addCancelParentStatement(methodBuilder);
        this.generatedComponentModel.addMethod(GeneratedComponentModel.MethodSpecKind.CANCELLATION_LISTENER_METHOD, methodBuilder.build());
    }

    protected void addCancelParentStatement(MethodSpec.Builder methodBuilder) {
    }

    private MethodSignature getMethodSignature(ComponentDescriptor.ComponentMethodDescriptor method) {
        return MethodSignature.forComponentMethod(method, MoreTypes.asDeclared(this.graph.componentType().asType()), this.types);
    }

    private void addSubcomponents() {
        for (BindingGraph subgraph : this.graph.subgraphs()) {
            this.generatedComponentModel.addSubcomponent(subgraph.componentDescriptor(), this.buildSubcomponentModel(subgraph));
        }
    }

    private GeneratedComponentModel getSubcomponentSupermodel(ComponentDescriptor subcomponent) {
        if (this.generatedComponentModel.supermodel().isPresent()) {
            Optional<GeneratedComponentModel> supermodel = this.generatedComponentModel.supermodel().get().subcomponentModel(subcomponent);
            Preconditions.checkState((boolean)supermodel.isPresent(), (String)"Attempting to generate an implementation of a subcomponent [%s] whose parent is a subcomponent [%s], but whose supermodel is not present on the parent's supermodel.", (Object)subcomponent.componentDefinitionType(), (Object)this.graph.componentType());
            return supermodel.get();
        }
        BindingGraph truncatedBindingGraph = this.bindingGraphFactory.create(subcomponent);
        return ComponentModelBuilder.buildComponentModel(this.types, this.elements, this.keyFactory, this.compilerOptions, ComponentGenerator.componentName(truncatedBindingGraph.componentType()), truncatedBindingGraph, this.bindingGraphFactory);
    }

    private GeneratedComponentModel buildSubcomponentModel(BindingGraph childGraph) {
        GeneratedComponentModel childModel = this.compilerOptions.aheadOfTimeSubcomponents() ? GeneratedComponentModel.forSubcomponent(childGraph.componentDescriptor(), this.generatedComponentModel, this.getSubcomponentSupermodel(childGraph.componentDescriptor())) : GeneratedComponentModel.forSubcomponent(childGraph.componentDescriptor(), this.generatedComponentModel);
        Optional<GeneratedComponentBuilderModel> childBuilderModel = GeneratedComponentBuilderModel.create(childModel, childGraph, this.elements, this.types);
        ComponentRequirementFields childComponentRequirementFields = this.componentRequirementFields.forChildComponent(childGraph, childModel, childBuilderModel);
        ComponentBindingExpressions childBindingExpressions = this.bindingExpressions.forChildComponent(childGraph, childModel, childComponentRequirementFields);
        return new SubComponentModelBuilder(Optional.of(this), this.types, this.elements, this.keyFactory, childGraph, childModel, this.optionalFactories, childBindingExpressions, childComponentRequirementFields, childBuilderModel, this.bindingGraphFactory, this.compilerOptions).build();
    }

    private void addConstructor() {
        List partitions = Lists.partition(this.generatedComponentModel.getInitializations(), (int)100);
        ImmutableList<ParameterSpec> constructorParameters = this.constructorParameters();
        MethodSpec.Builder constructor = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{this.generatedComponentModel.isAbstract() ? Modifier.PROTECTED : Modifier.PRIVATE}).addParameters(constructorParameters);
        this.generatedComponentModel.setConstructorParameters(constructorParameters);
        this.generatedComponentModel.supermodel().ifPresent(supermodel -> constructor.addStatement(CodeBlock.of((String)"super($L)", (Object[])new Object[]{supermodel.constructorParameters().stream().map(param -> CodeBlock.of((String)"$N", (Object[])new Object[]{param})).collect(CodeBlocks.toParametersCodeBlock())})));
        ImmutableList<ParameterSpec> initializeParameters = this.initializeParameters();
        CodeBlock initializeParametersCodeBlock = constructorParameters.stream().map(param -> CodeBlock.of((String)"$N", (Object[])new Object[]{param})).collect(CodeBlocks.toParametersCodeBlock());
        for (List partition : partitions) {
            String methodName = this.generatedComponentModel.getUniqueMethodName("initialize");
            MethodSpec.Builder initializeMethod = MethodSpec.methodBuilder((String)methodName).addModifiers(new Modifier[]{Modifier.PRIVATE}).addAnnotation(AnnotationSpecs.suppressWarnings(AnnotationSpecs.Suppression.UNCHECKED, new AnnotationSpecs.Suppression[0])).addCode(CodeBlocks.concat(partition));
            initializeMethod.addParameters(initializeParameters);
            constructor.addStatement("$L($L)", new Object[]{methodName, initializeParametersCodeBlock});
            this.generatedComponentModel.addMethod(GeneratedComponentModel.MethodSpecKind.INITIALIZE_METHOD, initializeMethod.build());
        }
        this.generatedComponentModel.addMethod(GeneratedComponentModel.MethodSpecKind.CONSTRUCTOR, constructor.build());
    }

    private ImmutableList<ParameterSpec> initializeParameters() {
        return this.constructorParameters().stream().map(param -> param.toBuilder().addModifiers(new Modifier[]{Modifier.FINAL}).build()).collect(DaggerStreams.toImmutableList());
    }

    private ImmutableList<ParameterSpec> constructorParameters() {
        if (this.generatedComponentBuilderModel.isPresent()) {
            return ImmutableList.of((Object)ParameterSpec.builder((TypeName)this.generatedComponentBuilderModel.get().name(), (String)"builder", (Modifier[])new Modifier[0]).build());
        }
        if (this.generatedComponentModel.isAbstract() && this.generatedComponentModel.isNested()) {
            return ImmutableList.of();
        }
        if (this.graph.factoryMethod().isPresent()) {
            return ComponentModelBuilder.getFactoryMethodParameterSpecs(this.graph);
        }
        if (this.generatedComponentModel.isAbstract()) {
            return ImmutableList.of();
        }
        throw new AssertionError((Object)"Expected either a component builder or factory method but found neither.");
    }

    private static ImmutableList<ParameterSpec> getFactoryMethodParameterSpecs(BindingGraph graph) {
        return graph.factoryMethodParameters().values().stream().map(ParameterSpec::get).collect(DaggerStreams.toImmutableList());
    }

    private static final class SubComponentModelBuilder
    extends ComponentModelBuilder {
        private final Optional<ComponentModelBuilder> parent;
        private final GeneratedComponentModel generatedComponentModel;
        private final ComponentBindingExpressions bindingExpressions;

        SubComponentModelBuilder(Optional<ComponentModelBuilder> parent, DaggerTypes types, DaggerElements elements, KeyFactory keyFactory, BindingGraph graph, GeneratedComponentModel generatedComponentModel, OptionalFactories optionalFactories, ComponentBindingExpressions bindingExpressions, ComponentRequirementFields componentRequirementFields, Optional<GeneratedComponentBuilderModel> builder, BindingGraphFactory bindingGraphFactory, CompilerOptions compilerOptions) {
            super(types, elements, keyFactory, graph, generatedComponentModel, optionalFactories, bindingExpressions, componentRequirementFields, builder, bindingGraphFactory, compilerOptions);
            this.parent = parent;
            this.generatedComponentModel = generatedComponentModel;
            this.bindingExpressions = bindingExpressions;
        }

        @Override
        protected void addBuilderClass(TypeSpec builder) {
            if (this.parent.isPresent()) {
                this.parent.get().generatedComponentModel.addType(GeneratedComponentModel.TypeSpecKind.SUBCOMPONENT, builder);
            } else {
                this.generatedComponentModel.addType(GeneratedComponentModel.TypeSpecKind.SUBCOMPONENT, builder);
            }
        }

        @Override
        protected void addFactoryMethods() {
            if (!this.generatedComponentModel.isAbstract()) {
                ((ComponentModelBuilder)this).graph.factoryMethod().ifPresent(this::createSubcomponentFactoryMethod);
            }
        }

        private void createSubcomponentFactoryMethod(ExecutableElement factoryMethod) {
            Preconditions.checkState((boolean)this.parent.isPresent());
            this.parent.get().generatedComponentModel.addMethod(GeneratedComponentModel.MethodSpecKind.COMPONENT_METHOD, MethodSpec.overriding((ExecutableElement)factoryMethod, (DeclaredType)this.parentType(), (Types)((ComponentModelBuilder)this).types).addStatement("return new $T($L)", new Object[]{this.generatedComponentModel.name(), ComponentModelBuilder.getFactoryMethodParameterSpecs(((ComponentModelBuilder)this).graph).stream().map(param -> CodeBlock.of((String)"$N", (Object[])new Object[]{param})).collect(CodeBlocks.toParametersCodeBlock())}).build());
        }

        private DeclaredType parentType() {
            return MoreTypes.asDeclared(this.parent.get().graph.componentType().asType());
        }

        @Override
        protected void addInterfaceMethods() {
            if (this.generatedComponentModel.supermodel().isPresent()) {
                for (ModifiableBindingMethods.ModifiableBindingMethod modifiableBindingMethod : this.generatedComponentModel.getModifiableBindingMethods()) {
                    this.bindingExpressions.modifiableBindingExpressions().getModifiableBindingMethod(modifiableBindingMethod).ifPresent(method -> this.generatedComponentModel.addImplementedModifiableBindingMethod((ModifiableBindingMethods.ModifiableBindingMethod)method));
                }
            } else {
                super.addInterfaceMethods();
            }
        }

        @Override
        protected void addCancelParentStatement(MethodSpec.Builder methodBuilder) {
            if (this.shouldPropagateCancellationToParent()) {
                methodBuilder.addStatement("$T.this.$L($L)", new Object[]{this.parent.get().generatedComponentModel.name(), ComponentModelBuilder.CANCELLATION_LISTENER_METHOD_NAME, "mayInterruptIfRunning"});
            }
        }

        private boolean shouldPropagateCancellationToParent() {
            return this.parent.isPresent() && this.parent.get().generatedComponentModel.componentDescriptor().cancellationPolicy().map(policy -> policy.fromSubcomponents().equals((Object)CancellationPolicy.Propagation.PROPAGATE)).orElse(false) != false;
        }
    }

    private static final class RootComponentModelBuilder
    extends ComponentModelBuilder {
        RootComponentModelBuilder(DaggerTypes types, DaggerElements elements, KeyFactory keyFactory, BindingGraph graph, GeneratedComponentModel generatedComponentModel, OptionalFactories optionalFactories, ComponentBindingExpressions bindingExpressions, ComponentRequirementFields componentRequirementFields, Optional<GeneratedComponentBuilderModel> generatedComponentBuilderModel, BindingGraphFactory bindingGraphFactory, CompilerOptions compilerOptions) {
            super(types, elements, keyFactory, graph, generatedComponentModel, optionalFactories, bindingExpressions, componentRequirementFields, generatedComponentBuilderModel, bindingGraphFactory, compilerOptions);
        }

        @Override
        protected void addBuilderClass(TypeSpec builder) {
            ((ComponentModelBuilder)this).generatedComponentModel.addType(GeneratedComponentModel.TypeSpecKind.COMPONENT_BUILDER, builder);
        }

        @Override
        protected void addFactoryMethods() {
            MethodSpec builderFactoryMethod = MethodSpec.methodBuilder((String)"builder").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns((TypeName)(this.builderSpec().isPresent() ? ClassName.get((TypeElement)this.builderSpec().get().builderDefinitionType()) : ((GeneratedComponentBuilderModel)((ComponentModelBuilder)this).generatedComponentBuilderModel.get()).name())).addStatement("return new $T()", new Object[]{((GeneratedComponentBuilderModel)((ComponentModelBuilder)this).generatedComponentBuilderModel.get()).name()}).build();
            ((ComponentModelBuilder)this).generatedComponentModel.addMethod(GeneratedComponentModel.MethodSpecKind.BUILDER_METHOD, builderFactoryMethod);
            if (this.canInstantiateAllRequirements()) {
                String buildMethodName = this.builderSpec().isPresent() ? this.builderSpec().get().buildMethod().getSimpleName() : "build";
                ((ComponentModelBuilder)this).generatedComponentModel.addMethod(GeneratedComponentModel.MethodSpecKind.BUILDER_METHOD, MethodSpec.methodBuilder((String)"create").returns((TypeName)ClassName.get((TypeElement)((ComponentModelBuilder)this).graph.componentType())).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).addStatement("return new Builder().$L()", new Object[]{buildMethodName}).build());
            }
        }

        private Optional<ComponentDescriptor.BuilderSpec> builderSpec() {
            return ((ComponentModelBuilder)this).graph.componentDescriptor().builderSpec();
        }

        private boolean canInstantiateAllRequirements() {
            return !Iterables.any(((ComponentModelBuilder)this).graph.componentRequirements(), dependency -> dependency.requiresAPassedInstance(((ComponentModelBuilder)this).elements, ((ComponentModelBuilder)this).types));
        }
    }
}

