/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.SetMultimap;
import com.google.common.graph.EndpointPair;
import com.google.common.graph.Graph;
import com.google.common.graph.Graphs;
import com.google.common.graph.ImmutableGraph;
import com.google.common.graph.ImmutableNetwork;
import com.google.common.graph.MutableNetwork;
import com.google.common.graph.Network;
import com.google.common.graph.NetworkBuilder;
import dagger.Binds;
import dagger.internal.codegen.CompilerOptions;
import dagger.internal.codegen.ContributionBinding;
import dagger.internal.codegen.Validation;
import dagger.model.BindingGraph;
import dagger.model.ComponentPath;
import dagger.multibindings.IntoSet;
import dagger.spi.BindingGraphPlugin;
import dagger.spi.DiagnosticReporter;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.tools.Diagnostic;

@Singleton
final class IncorrectlyInstalledBindsMethodsValidator
implements BindingGraphPlugin {
    private final SetMultimap<ComponentPath, ContributionBinding> incorrectlyInstalledBindingsCache = MultimapBuilder.hashKeys().linkedHashSetValues().build();
    private final CompilerOptions compilerOptions;

    @Inject
    IncorrectlyInstalledBindsMethodsValidator(CompilerOptions compilerOptions) {
        this.compilerOptions = compilerOptions;
    }

    public void visitGraph(BindingGraph graph, DiagnosticReporter diagnosticReporter) {
        Preconditions.checkState((this.compilerOptions.floatingBindsMethods() || this.incorrectlyInstalledBindingsCache.isEmpty() ? 1 : 0) != 0);
        for (Map.Entry entry : this.incorrectlyInstalledBindingsCache.entries()) {
            ComponentPath idealComponentPath = (ComponentPath)entry.getKey();
            ContributionBinding incorrectlyInstalledBinding = (ContributionBinding)entry.getValue();
            graph.bindingNodes(incorrectlyInstalledBinding.key()).stream().filter(bindingNode -> bindingNode.binding().equals(incorrectlyInstalledBinding)).forEach(bindingNode -> this.report((BindingGraph.BindingNode)bindingNode, idealComponentPath, graph, diagnosticReporter));
        }
    }

    private void report(BindingGraph.BindingNode incompatiblyInstalledBinding, ComponentPath idealComponentPath, BindingGraph graph, DiagnosticReporter diagnosticReporter) {
        ImmutableGraph dependencyGraph = this.dependencyGraph(graph).asGraph();
        Set culpableDependencies = Graphs.reachableNodes((Graph)dependencyGraph, (Object)incompatiblyInstalledBinding).stream().filter(node -> this.isChild(idealComponentPath, node.componentPath())).filter(node -> !node.equals(incompatiblyInstalledBinding)).collect(Collectors.toCollection(LinkedHashSet::new));
        if (culpableDependencies.isEmpty()) {
            return;
        }
        StringBuilder warning = new StringBuilder().append("Floating @Binds method detected:\n  ").append(incompatiblyInstalledBinding).append("\n  It is installed in:       ").append(idealComponentPath).append("\n  But is being resolved in: ").append(incompatiblyInstalledBinding.componentPath()).append("\n  This is because it depends transitively on:");
        while (!culpableDependencies.isEmpty()) {
            BindingGraph.BindingNode culpableDependency = (BindingGraph.BindingNode)Iterables.get((Iterable)culpableDependencies, (int)0);
            warning.append("\n      ").append(culpableDependency).append(", resolved in: ").append(culpableDependency.componentPath());
            culpableDependencies.removeAll(Graphs.reachableNodes((Graph)dependencyGraph, (Object)culpableDependency));
        }
        diagnosticReporter.reportComponent(Diagnostic.Kind.WARNING, graph.rootComponentNode(), warning.toString());
    }

    private boolean isChild(ComponentPath possibleParent, ComponentPath possibleChild) {
        return !possibleParent.equals(possibleChild) && possibleChild.components().containsAll((Collection)possibleParent.components());
    }

    private ImmutableNetwork<BindingGraph.Node, BindingGraph.Edge> dependencyGraph(BindingGraph graph) {
        MutableNetwork dependencyGraph = NetworkBuilder.from((Network)graph.network()).build();
        for (BindingGraph.DependencyEdge dependencyEdge : graph.dependencyEdges()) {
            EndpointPair endpoint = graph.network().incidentNodes((Object)dependencyEdge);
            dependencyGraph.addEdge((Object)((BindingGraph.Node)endpoint.source()), (Object)((BindingGraph.Node)endpoint.target()), (Object)dependencyEdge);
        }
        return ImmutableNetwork.copyOf((Network)dependencyGraph);
    }

    void recordBinding(ComponentPath componentPath, ContributionBinding binding) {
        this.incorrectlyInstalledBindingsCache.put((Object)componentPath, (Object)binding);
    }

    @dagger.Module
    static interface Module {
        @Binds
        @IntoSet
        @Validation
        public BindingGraphPlugin validator(IncorrectlyInstalledBindsMethodsValidator var1);
    }
}

