/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Preconditions;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.TypeName;
import dagger.internal.codegen.ComponentDescriptor;
import dagger.internal.codegen.DaggerElements;
import dagger.internal.codegen.DaggerTypes;
import dagger.internal.codegen.Expression;
import dagger.internal.codegen.FrameworkInstanceBindingExpression;
import dagger.internal.codegen.FrameworkInstanceSupplier;
import dagger.internal.codegen.FrameworkType;
import dagger.internal.codegen.GeneratedComponentModel;
import dagger.internal.codegen.ResolvedBindings;
import dagger.producers.Producer;
import dagger.producers.internal.Producers;
import javax.lang.model.element.Modifier;
import javax.lang.model.type.TypeMirror;

final class ProducerNodeInstanceBindingExpression
extends FrameworkInstanceBindingExpression {
    static final String MAY_INTERRUPT_IF_RUNNING = "mayInterruptIfRunning";
    private final GeneratedComponentModel generatedComponentModel;
    private final TypeMirror type;
    private boolean addedCancellationStatement = false;

    ProducerNodeInstanceBindingExpression(ResolvedBindings resolvedBindings, FrameworkInstanceSupplier frameworkInstanceSupplier, DaggerTypes types, DaggerElements elements, GeneratedComponentModel generatedComponentModel) {
        super(resolvedBindings, frameworkInstanceSupplier, types, elements);
        this.generatedComponentModel = (GeneratedComponentModel)Preconditions.checkNotNull((Object)generatedComponentModel);
        this.type = types.wrapType(resolvedBindings.key().type(), Producer.class);
    }

    @Override
    protected FrameworkType frameworkType() {
        return FrameworkType.PRODUCER_NODE;
    }

    @Override
    Expression getDependencyExpression(ClassName requestingClass) {
        Expression result = super.getDependencyExpression(requestingClass);
        if (!this.addedCancellationStatement) {
            CodeBlock cancel = CodeBlock.of((String)"$T.cancel($L, $L);", (Object[])new Object[]{Producers.class, result.codeBlock(), MAY_INTERRUPT_IF_RUNNING});
            this.generatedComponentModel.addCancellation(cancel);
            this.addedCancellationStatement = true;
        }
        return result;
    }

    @Override
    Expression getDependencyExpressionForComponentMethod(ComponentDescriptor.ComponentMethodDescriptor componentMethod, GeneratedComponentModel component) {
        if (component.componentDescriptor().kind().isProducer()) {
            return Expression.create(this.type, "$N", this.createField(componentMethod, component));
        }
        return super.getDependencyExpressionForComponentMethod(componentMethod, component);
    }

    private FieldSpec createField(ComponentDescriptor.ComponentMethodDescriptor componentMethod, GeneratedComponentModel component) {
        String methodName = componentMethod.methodElement().getSimpleName().toString();
        FieldSpec field = FieldSpec.builder((TypeName)TypeName.get((TypeMirror)this.type), (String)component.getUniqueFieldName(methodName + "EntryPoint"), (Modifier[])new Modifier[]{Modifier.PRIVATE}).build();
        component.addField(GeneratedComponentModel.FieldSpecKind.FRAMEWORK_FIELD, field);
        CodeBlock fieldInitialization = CodeBlock.of((String)"this.$N = $T.entryPointViewOf($L, this);", (Object[])new Object[]{field, Producers.class, this.getDependencyExpression(component.name()).codeBlock()});
        component.addInitialization(fieldInitialization);
        return field;
    }
}

