/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.collect.ImmutableList;
import com.squareup.javapoet.ArrayTypeName;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import dagger.internal.codegen.BindingRequest;
import dagger.internal.codegen.CodeBlocks;
import dagger.internal.codegen.ComponentBindingExpressions;
import dagger.internal.codegen.ContributionBinding;
import dagger.internal.codegen.DaggerTypes;
import dagger.internal.codegen.Expression;
import dagger.internal.codegen.FrameworkDependency;
import dagger.internal.codegen.FrameworkFieldInitializer;
import dagger.internal.codegen.GeneratedComponentModel;
import dagger.internal.codegen.SourceFiles;
import dagger.internal.codegen.SwitchingProviders;
import dagger.model.Key;
import java.util.stream.Stream;
import javax.inject.Provider;
import javax.lang.model.element.Modifier;
import javax.lang.model.type.TypeMirror;

final class StaticSwitchingProviders
extends SwitchingProviders {
    private final DaggerTypes types;
    private final ClassName owningComponent;

    StaticSwitchingProviders(GeneratedComponentModel generatedComponentModel, DaggerTypes types) {
        super(generatedComponentModel, types);
        this.types = types;
        this.owningComponent = generatedComponentModel.name();
    }

    FrameworkFieldInitializer.FrameworkInstanceCreationExpression newCreationExpression(final ContributionBinding binding, final ComponentBindingExpressions componentBindingExpressions) {
        return new FrameworkFieldInitializer.FrameworkInstanceCreationExpression(){

            @Override
            public CodeBlock creationExpression() {
                return StaticSwitchingProviders.this.getProviderExpression(new SwitchCase(binding, componentBindingExpressions)).codeBlock();
            }
        };
    }

    @Override
    protected TypeSpec createSwitchingProviderType(TypeSpec.Builder builder) {
        return builder.addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.FINAL, Modifier.STATIC}).addField(TypeName.INT, "id", new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).addField((TypeName)ArrayTypeName.of((TypeName)ClassName.OBJECT), "dependencies", new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).addMethod(MethodSpec.constructorBuilder().addParameter(TypeName.INT, "id", new Modifier[0]).addParameter((TypeName)ArrayTypeName.of((TypeName)ClassName.OBJECT), "dependencies", new Modifier[0]).varargs().addStatement("this.id = id", new Object[0]).addStatement("this.dependencies = dependencies", new Object[0]).build()).build();
    }

    private final class SwitchCase
    implements SwitchingProviders.SwitchCase {
        private final ComponentBindingExpressions componentBindingExpressions;
        private final ContributionBinding binding;

        SwitchCase(ContributionBinding binding, ComponentBindingExpressions componentBindingExpressions) {
            this.binding = binding;
            this.componentBindingExpressions = componentBindingExpressions;
        }

        @Override
        public Key key() {
            return this.binding.key();
        }

        @Override
        public Expression getProviderExpression(ClassName switchingProviderClass, int switchId) {
            TypeMirror accessibleType = StaticSwitchingProviders.this.types.accessibleType(this.binding.contributedType(), StaticSwitchingProviders.this.owningComponent);
            CodeBlock typeParameter = CodeBlock.of((String)"$T", (Object[])new Object[]{accessibleType});
            CodeBlock arguments = Stream.of(CodeBlock.of((String)"$L", (Object[])new Object[]{switchId}), this.componentBindingExpressions.getCreateMethodArgumentsCodeBlock(this.binding)).filter(codeBlock -> !codeBlock.isEmpty()).collect(CodeBlocks.toParametersCodeBlock());
            return Expression.create(StaticSwitchingProviders.this.types.wrapType(accessibleType, Provider.class), CodeBlock.of((String)"new $T<$L>($L)", (Object[])new Object[]{switchingProviderClass, typeParameter, arguments}));
        }

        @Override
        public Expression getReturnExpression(ClassName switchingProviderClass) {
            return Expression.create(this.binding.contributedType(), CodeBlock.of((String)"$T.provideInstance($L)", (Object[])new Object[]{SourceFiles.generatedClassNameForBinding(this.binding), this.getMethodArguments(switchingProviderClass)}));
        }

        private CodeBlock getMethodArguments(ClassName switchingProviderClass) {
            int i = 0;
            ImmutableList.Builder arguments = ImmutableList.builder();
            if (this.binding.requiresModuleInstance()) {
                arguments.add((Object)this.argument(this.binding.contributingModule().get().asType(), i++));
            }
            for (FrameworkDependency dependency : this.binding.frameworkDependencies()) {
                TypeMirror type = this.componentBindingExpressions.getDependencyExpression(BindingRequest.bindingRequest(dependency), switchingProviderClass).type();
                arguments.add((Object)this.argument(type, i++));
            }
            return CodeBlocks.makeParametersCodeBlock((Iterable<CodeBlock>)arguments.build());
        }

        private CodeBlock argument(TypeMirror type, int index) {
            CodeBlock.Builder builder = CodeBlock.builder();
            TypeName accessibleType = TypeName.get((TypeMirror)StaticSwitchingProviders.this.types.accessibleType(type, StaticSwitchingProviders.this.owningComponent));
            if (!accessibleType.equals((Object)ClassName.OBJECT)) {
                builder.add("($T) ", new Object[]{accessibleType});
            }
            return builder.add("dependencies[$L]", new Object[]{index}).build();
        }
    }
}

