package dagger.internal.codegen;

import dagger.internal.Factory;
import dagger.internal.Preconditions;
import dagger.spi.BindingGraphPlugin;
import java.util.Map;
import java.util.Set;
import javax.annotation.Generated;
import javax.annotation.processing.Filer;
import javax.inject.Provider;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

@Generated(
  value = "dagger.internal.codegen.ComponentProcessor",
  comments = "https://google.github.io/dagger"
)
public final class BindingGraphValidationModule_ModuleValidationPluginsFactory
    implements Factory<BindingGraphPlugins> {
  private final Provider<Set<BindingGraphPlugin>> validationPluginsProvider;

  private final Provider<Filer> filerProvider;

  private final Provider<Types> typesProvider;

  private final Provider<Elements> elementsProvider;

  private final Provider<Map<String, String>> processingOptionsProvider;

  private final Provider<DiagnosticReporterFactory> diagnosticReporterFactoryProvider;

  private final Provider<CompilerOptions> compilerOptionsProvider;

  public BindingGraphValidationModule_ModuleValidationPluginsFactory(
      Provider<Set<BindingGraphPlugin>> validationPluginsProvider,
      Provider<Filer> filerProvider,
      Provider<Types> typesProvider,
      Provider<Elements> elementsProvider,
      Provider<Map<String, String>> processingOptionsProvider,
      Provider<DiagnosticReporterFactory> diagnosticReporterFactoryProvider,
      Provider<CompilerOptions> compilerOptionsProvider) {
    this.validationPluginsProvider = validationPluginsProvider;
    this.filerProvider = filerProvider;
    this.typesProvider = typesProvider;
    this.elementsProvider = elementsProvider;
    this.processingOptionsProvider = processingOptionsProvider;
    this.diagnosticReporterFactoryProvider = diagnosticReporterFactoryProvider;
    this.compilerOptionsProvider = compilerOptionsProvider;
  }

  @Override
  public BindingGraphPlugins get() {
    return Preconditions.checkNotNull(
        BindingGraphValidationModule.moduleValidationPlugins(
            validationPluginsProvider.get(),
            filerProvider.get(),
            typesProvider.get(),
            elementsProvider.get(),
            processingOptionsProvider.get(),
            diagnosticReporterFactoryProvider.get(),
            compilerOptionsProvider.get()),
        "Cannot return null from a non-@Nullable @Provides method");
  }

  public static BindingGraphValidationModule_ModuleValidationPluginsFactory create(
      Provider<Set<BindingGraphPlugin>> validationPluginsProvider,
      Provider<Filer> filerProvider,
      Provider<Types> typesProvider,
      Provider<Elements> elementsProvider,
      Provider<Map<String, String>> processingOptionsProvider,
      Provider<DiagnosticReporterFactory> diagnosticReporterFactoryProvider,
      Provider<CompilerOptions> compilerOptionsProvider) {
    return new BindingGraphValidationModule_ModuleValidationPluginsFactory(
        validationPluginsProvider,
        filerProvider,
        typesProvider,
        elementsProvider,
        processingOptionsProvider,
        diagnosticReporterFactoryProvider,
        compilerOptionsProvider);
  }

  public static BindingGraphPlugins proxyModuleValidationPlugins(
      Set<BindingGraphPlugin> validationPlugins,
      Filer filer,
      Types types,
      Elements elements,
      Map<String, String> processingOptions,
      Object diagnosticReporterFactory,
      Object compilerOptions) {
    return Preconditions.checkNotNull(
        BindingGraphValidationModule.moduleValidationPlugins(
            validationPlugins,
            filer,
            types,
            elements,
            processingOptions,
            (DiagnosticReporterFactory) diagnosticReporterFactory,
            (CompilerOptions) compilerOptions),
        "Cannot return null from a non-@Nullable @Provides method");
  }
}
