package dagger.internal.codegen;

import com.google.auto.common.BasicAnnotationProcessor;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import dagger.internal.DoubleCheck;
import dagger.internal.InstanceFactory;
import dagger.internal.Preconditions;
import dagger.internal.SetFactory;
import dagger.internal.SingleCheck;
import dagger.spi.BindingGraphPlugin;
import java.lang.annotation.Annotation;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Generated;
import javax.annotation.processing.Filer;
import javax.inject.Provider;

@Generated(
  value = "dagger.internal.codegen.ComponentProcessor",
  comments = "https://google.github.io/dagger"
)
public final class DaggerComponentProcessor_ProcessorComponent
    implements ComponentProcessor.ProcessorComponent {
  private SourceFileGeneratorsModule.ProvisionModule provisionModule;

  private ProcessingEnvironmentModule processingEnvironmentModule;

  private SourceFileGeneratorsModule.MembersInjectionModule membersInjectionModule;

  private SourceFileGeneratorsModule.ProductionModule productionModule;

  private SourceFileGeneratorsModule.ComponentModule componentModule;

  private ProcessingEnvironmentModule_DaggerElementsFactory daggerElementsProvider;

  private ProcessingEnvironmentModule_TypesFactory typesProvider;

  private DaggerTypes_Factory daggerTypesProvider;

  private ProcessingEnvironmentModule_MessagerFactory messagerProvider;

  private DependencyRequestValidator_Factory dependencyRequestValidatorProvider;

  private Provider<CompilerOptions> compilerOptionsProvider;

  private InjectValidator_Factory injectValidatorProvider;

  private KeyFactory_Factory keyFactoryProvider;

  private DependencyRequestFactory_Factory dependencyRequestFactoryProvider;

  private BindingFactory_Factory bindingFactoryProvider;

  private Provider<InjectBindingRegistryImpl> injectBindingRegistryImplProvider;

  private ProvidesMethodValidator_Factory providesMethodValidatorProvider;

  private ProducesMethodValidator_Factory producesMethodValidatorProvider;

  private BindsMethodValidator_Factory bindsMethodValidatorProvider;

  private MultibindsMethodValidator_Factory multibindsMethodValidatorProvider;

  private BindsOptionalOfMethodValidator_Factory bindsOptionalOfMethodValidatorProvider;

  private Provider<Set<BindingMethodValidator>> setOfBindingMethodValidatorProvider;

  private BindingMethodValidatorsModule_IndexValidatorsFactory indexValidatorsProvider;

  private AnyBindingMethodValidator_Factory anyBindingMethodValidatorProvider;

  private MethodSignatureFormatter_Factory methodSignatureFormatterProvider;

  private MultibindingDeclaration_Factory_Factory factoryProvider;

  private DelegateDeclaration_Factory_Factory factoryProvider2;

  private SubcomponentDeclaration_Factory_Factory factoryProvider3;

  private OptionalBindingDeclaration_Factory_Factory factoryProvider4;

  private ModuleDescriptor_Factory_Factory factoryProvider5;

  private ComponentDescriptor_Factory_Factory factoryProvider6;

  private BindingGraphFactory_Factory bindingGraphFactoryProvider;

  private BindingDeclarationFormatter_Factory bindingDeclarationFormatterProvider;

  private BindingGraphConverter_Factory bindingGraphConverterProvider;

  private DependencyRequestFormatter_Factory dependencyRequestFormatterProvider;

  private DependencyCycleValidator_Factory dependencyCycleValidatorProvider;

  private DependsOnProductionExecutorValidator_Factory dependsOnProductionExecutorValidatorProvider;

  private DuplicateBindingsValidator_Factory duplicateBindingsValidatorProvider;

  private IncompatiblyScopedBindingsValidator_Factory incompatiblyScopedBindingsValidatorProvider;

  private InjectBindingValidator_Factory injectBindingValidatorProvider;

  private MapMultibindingValidator_Factory mapMultibindingValidatorProvider;

  private MissingBindingValidator_Factory missingBindingValidatorProvider;

  private NullableBindingValidator_Factory nullableBindingValidatorProvider;

  private SubcomponentFactoryMethodValidator_Factory subcomponentFactoryMethodValidatorProvider;

  private Provider<Set<BindingGraphPlugin>> validationSetOfBindingGraphPluginProvider;

  private ProcessingEnvironmentModule_FilerFactory filerProvider;

  private ProcessingEnvironmentModule_ProcessingOptionsFactory processingOptionsProvider;

  private DiagnosticReporterFactory_Factory diagnosticReporterFactoryProvider;

  private Provider<BindingGraphPlugins> moduleValidationPluginsProvider;

  private Provider<Optional<ImmutableSet<BindingGraphPlugin>>> testingPluginsProvider;

  private Provider<BindingGraphPlugins> spiPluginsProvider;

  private Provider<ModuleValidator> moduleValidatorProvider;

  private Provider<BindingGraphPlugins> validationPluginsProvider;

  private Provider<DaggerStatistics> daggerStatisticsProvider;

  private DaggerComponentProcessor_ProcessorComponent(Builder builder) {
    initialize(builder);
  }

  public static ComponentProcessor.ProcessorComponent.Builder builder() {
    return new Builder();
  }

  private Filer getFiler() {
    return ProcessingEnvironmentModule_FilerFactory.proxyFiler(
        processingEnvironmentModule, compilerOptionsProvider.get());
  }

  private FactoryGenerator getFactoryGenerator() {
    return new FactoryGenerator(
        getFiler(),
        ProcessingEnvironmentModule_DaggerElementsFactory.proxyDaggerElements(
            processingEnvironmentModule),
        ProcessingEnvironmentModule_SourceVersionFactory.proxySourceVersion(
            processingEnvironmentModule),
        ProcessingEnvironmentModule_TypesFactory.proxyTypes(processingEnvironmentModule),
        compilerOptionsProvider.get());
  }

  private SourceFileGenerator<ProvisionBinding> getSourceFileGeneratorOfProvisionBinding() {
    return SourceFileGeneratorsModule_GeneratorModule_GeneratorFactory.proxyGenerator(
        provisionModule, getFactoryGenerator(), compilerOptionsProvider.get());
  }

  private MembersInjectorGenerator getMembersInjectorGenerator() {
    return new MembersInjectorGenerator(
        getFiler(),
        ProcessingEnvironmentModule_DaggerElementsFactory.proxyDaggerElements(
            processingEnvironmentModule),
        ProcessingEnvironmentModule_SourceVersionFactory.proxySourceVersion(
            processingEnvironmentModule),
        ProcessingEnvironmentModule_TypesFactory.proxyTypes(processingEnvironmentModule));
  }

  private SourceFileGenerator<MembersInjectionBinding>
      getSourceFileGeneratorOfMembersInjectionBinding() {
    return SourceFileGeneratorsModule_GeneratorModule_GeneratorFactory.proxyGenerator(
        membersInjectionModule, getMembersInjectorGenerator(), compilerOptionsProvider.get());
  }

  private MapKeyValidator getMapKeyValidator() {
    return new MapKeyValidator(
        ProcessingEnvironmentModule_DaggerElementsFactory.proxyDaggerElements(
            processingEnvironmentModule));
  }

  private AnnotationCreatorGenerator getAnnotationCreatorGenerator() {
    return new AnnotationCreatorGenerator(
        getFiler(),
        ProcessingEnvironmentModule_DaggerElementsFactory.proxyDaggerElements(
            processingEnvironmentModule),
        ProcessingEnvironmentModule_SourceVersionFactory.proxySourceVersion(
            processingEnvironmentModule));
  }

  private UnwrappedMapKeyGenerator getUnwrappedMapKeyGenerator() {
    return new UnwrappedMapKeyGenerator(
        getFiler(),
        ProcessingEnvironmentModule_DaggerElementsFactory.proxyDaggerElements(
            processingEnvironmentModule),
        ProcessingEnvironmentModule_SourceVersionFactory.proxySourceVersion(
            processingEnvironmentModule));
  }

  private MapKeyProcessingStep getMapKeyProcessingStep() {
    return new MapKeyProcessingStep(
        ProcessingEnvironmentModule_MessagerFactory.proxyMessager(processingEnvironmentModule),
        ProcessingEnvironmentModule_TypesFactory.proxyTypes(processingEnvironmentModule),
        getMapKeyValidator(),
        getAnnotationCreatorGenerator(),
        getUnwrappedMapKeyGenerator());
  }

  private InjectProcessingStep getInjectProcessingStep() {
    return new InjectProcessingStep(injectBindingRegistryImplProvider.get());
  }

  private MonitoringModuleGenerator getMonitoringModuleGenerator() {
    return new MonitoringModuleGenerator(
        getFiler(),
        ProcessingEnvironmentModule_DaggerElementsFactory.proxyDaggerElements(
            processingEnvironmentModule),
        ProcessingEnvironmentModule_SourceVersionFactory.proxySourceVersion(
            processingEnvironmentModule));
  }

  private MonitoringModuleProcessingStep getMonitoringModuleProcessingStep() {
    return new MonitoringModuleProcessingStep(
        ProcessingEnvironmentModule_MessagerFactory.proxyMessager(processingEnvironmentModule),
        getMonitoringModuleGenerator());
  }

  private DependencyRequestValidator getDependencyRequestValidator() {
    return new DependencyRequestValidator(new MembersInjectionValidator());
  }

  private ProvidesMethodValidator getProvidesMethodValidator() {
    return new ProvidesMethodValidator(
        ProcessingEnvironmentModule_DaggerElementsFactory.proxyDaggerElements(
            processingEnvironmentModule),
        ProcessingEnvironmentModule_TypesFactory.proxyTypes(processingEnvironmentModule),
        getDependencyRequestValidator());
  }

  private ProducesMethodValidator getProducesMethodValidator() {
    return new ProducesMethodValidator(
        ProcessingEnvironmentModule_DaggerElementsFactory.proxyDaggerElements(
            processingEnvironmentModule),
        ProcessingEnvironmentModule_TypesFactory.proxyTypes(processingEnvironmentModule),
        getDependencyRequestValidator());
  }

  private BindsMethodValidator getBindsMethodValidator() {
    return new BindsMethodValidator(
        ProcessingEnvironmentModule_DaggerElementsFactory.proxyDaggerElements(
            processingEnvironmentModule),
        ProcessingEnvironmentModule_TypesFactory.proxyTypes(processingEnvironmentModule),
        getDependencyRequestValidator());
  }

  private MultibindsMethodValidator getMultibindsMethodValidator() {
    return new MultibindsMethodValidator(
        ProcessingEnvironmentModule_DaggerElementsFactory.proxyDaggerElements(
            processingEnvironmentModule),
        ProcessingEnvironmentModule_TypesFactory.proxyTypes(processingEnvironmentModule),
        getDependencyRequestValidator());
  }

  private BindsOptionalOfMethodValidator getBindsOptionalOfMethodValidator() {
    return new BindsOptionalOfMethodValidator(
        ProcessingEnvironmentModule_DaggerElementsFactory.proxyDaggerElements(
            processingEnvironmentModule),
        ProcessingEnvironmentModule_TypesFactory.proxyTypes(processingEnvironmentModule),
        getDependencyRequestValidator());
  }

  private Set<BindingMethodValidator> getSetOfBindingMethodValidator() {
    return ImmutableSet.<BindingMethodValidator>of(
        getProvidesMethodValidator(),
        getProducesMethodValidator(),
        getBindsMethodValidator(),
        getMultibindsMethodValidator(),
        getBindsOptionalOfMethodValidator());
  }

  private ImmutableMap<Class<? extends Annotation>, BindingMethodValidator>
      getImmutableMapOfClassOfAndBindingMethodValidator() {
    return BindingMethodValidatorsModule_IndexValidatorsFactory.proxyIndexValidators(
        getSetOfBindingMethodValidator());
  }

  private AnyBindingMethodValidator getAnyBindingMethodValidator() {
    return new AnyBindingMethodValidator(getImmutableMapOfClassOfAndBindingMethodValidator());
  }

  private MultibindingAnnotationsProcessingStep getMultibindingAnnotationsProcessingStep() {
    return new MultibindingAnnotationsProcessingStep(
        getAnyBindingMethodValidator(),
        ProcessingEnvironmentModule_MessagerFactory.proxyMessager(processingEnvironmentModule));
  }

  private BindsInstanceProcessingStep getBindsInstanceProcessingStep() {
    return new BindsInstanceProcessingStep(
        ProcessingEnvironmentModule_MessagerFactory.proxyMessager(processingEnvironmentModule));
  }

  private DaggerTypes getDaggerTypes() {
    return new DaggerTypes(
        ProcessingEnvironmentModule_TypesFactory.proxyTypes(processingEnvironmentModule),
        ProcessingEnvironmentModule_DaggerElementsFactory.proxyDaggerElements(
            processingEnvironmentModule));
  }

  private KeyFactory getKeyFactory() {
    return new KeyFactory(
        getDaggerTypes(),
        ProcessingEnvironmentModule_DaggerElementsFactory.proxyDaggerElements(
            processingEnvironmentModule));
  }

  private DependencyRequestFactory getDependencyRequestFactory() {
    return new DependencyRequestFactory(getKeyFactory(), getDaggerTypes());
  }

  private BindingFactory getBindingFactory() {
    return new BindingFactory(
        getDaggerTypes(),
        ProcessingEnvironmentModule_DaggerElementsFactory.proxyDaggerElements(
            processingEnvironmentModule),
        getKeyFactory(),
        getDependencyRequestFactory());
  }

  private ProducerFactoryGenerator getProducerFactoryGenerator() {
    return new ProducerFactoryGenerator(
        getFiler(),
        ProcessingEnvironmentModule_DaggerElementsFactory.proxyDaggerElements(
            processingEnvironmentModule),
        ProcessingEnvironmentModule_SourceVersionFactory.proxySourceVersion(
            processingEnvironmentModule),
        compilerOptionsProvider.get(),
        getKeyFactory());
  }

  private SourceFileGenerator<ProductionBinding> getSourceFileGeneratorOfProductionBinding() {
    return SourceFileGeneratorsModule_GeneratorModule_GeneratorFactory.proxyGenerator(
        productionModule, getProducerFactoryGenerator(), compilerOptionsProvider.get());
  }

  private InaccessibleMapKeyProxyGenerator getInaccessibleMapKeyProxyGenerator() {
    return new InaccessibleMapKeyProxyGenerator(
        getFiler(),
        getDaggerTypes(),
        ProcessingEnvironmentModule_DaggerElementsFactory.proxyDaggerElements(
            processingEnvironmentModule),
        ProcessingEnvironmentModule_SourceVersionFactory.proxySourceVersion(
            processingEnvironmentModule));
  }

  private DelegateDeclaration.Factory getFactory() {
    return new DelegateDeclaration.Factory(
        ProcessingEnvironmentModule_TypesFactory.proxyTypes(processingEnvironmentModule),
        getKeyFactory(),
        getDependencyRequestFactory());
  }

  private ModuleProcessingStep getModuleProcessingStep() {
    return new ModuleProcessingStep(
        ProcessingEnvironmentModule_MessagerFactory.proxyMessager(processingEnvironmentModule),
        moduleValidatorProvider.get(),
        getBindingFactory(),
        getSourceFileGeneratorOfProvisionBinding(),
        getSourceFileGeneratorOfProductionBinding(),
        getInaccessibleMapKeyProxyGenerator(),
        getFactory());
  }

  private ComponentCreatorValidator getComponentCreatorValidator() {
    return new ComponentCreatorValidator(
        ProcessingEnvironmentModule_DaggerElementsFactory.proxyDaggerElements(
            processingEnvironmentModule),
        ProcessingEnvironmentModule_TypesFactory.proxyTypes(processingEnvironmentModule));
  }

  private MethodSignatureFormatter getMethodSignatureFormatter() {
    return new MethodSignatureFormatter(
        ProcessingEnvironmentModule_TypesFactory.proxyTypes(processingEnvironmentModule));
  }

  private ComponentValidator getComponentValidator() {
    return new ComponentValidator(
        ProcessingEnvironmentModule_DaggerElementsFactory.proxyDaggerElements(
            processingEnvironmentModule),
        ProcessingEnvironmentModule_TypesFactory.proxyTypes(processingEnvironmentModule),
        moduleValidatorProvider.get(),
        getComponentCreatorValidator(),
        getDependencyRequestValidator(),
        new MembersInjectionValidator(),
        getMethodSignatureFormatter(),
        getDependencyRequestFactory());
  }

  private ComponentHierarchyValidator getComponentHierarchyValidator() {
    return new ComponentHierarchyValidator(compilerOptionsProvider.get());
  }

  private ComponentDescriptorValidator getComponentDescriptorValidator() {
    return new ComponentDescriptorValidator(
        ProcessingEnvironmentModule_DaggerElementsFactory.proxyDaggerElements(
            processingEnvironmentModule),
        getDaggerTypes(),
        compilerOptionsProvider.get(),
        getMethodSignatureFormatter(),
        getComponentHierarchyValidator());
  }

  private MultibindingDeclaration.Factory getFactory4() {
    return new MultibindingDeclaration.Factory(
        ProcessingEnvironmentModule_TypesFactory.proxyTypes(processingEnvironmentModule),
        getKeyFactory());
  }

  private SubcomponentDeclaration.Factory getFactory5() {
    return new SubcomponentDeclaration.Factory(getKeyFactory());
  }

  private OptionalBindingDeclaration.Factory getFactory6() {
    return new OptionalBindingDeclaration.Factory(getKeyFactory());
  }

  private ModuleDescriptor.Factory getFactory3() {
    return new ModuleDescriptor.Factory(
        ProcessingEnvironmentModule_DaggerElementsFactory.proxyDaggerElements(
            processingEnvironmentModule),
        getBindingFactory(),
        getFactory4(),
        getFactory(),
        getFactory5(),
        getFactory6());
  }

  private ComponentDescriptor.Factory getFactory2() {
    return new ComponentDescriptor.Factory(
        ProcessingEnvironmentModule_DaggerElementsFactory.proxyDaggerElements(
            processingEnvironmentModule),
        getDaggerTypes(),
        getDependencyRequestFactory(),
        getFactory3(),
        compilerOptionsProvider.get());
  }

  private BindingGraphFactory getBindingGraphFactory() {
    return new BindingGraphFactory(
        ProcessingEnvironmentModule_DaggerElementsFactory.proxyDaggerElements(
            processingEnvironmentModule),
        injectBindingRegistryImplProvider.get(),
        getKeyFactory(),
        getBindingFactory(),
        getFactory3(),
        compilerOptionsProvider.get());
  }

  private ComponentImplementationFactory getComponentImplementationFactory() {
    return new ComponentImplementationFactory(
        getDaggerTypes(),
        ProcessingEnvironmentModule_DaggerElementsFactory.proxyDaggerElements(
            processingEnvironmentModule),
        getKeyFactory(),
        compilerOptionsProvider.get(),
        getBindingGraphFactory());
  }

  private ComponentGenerator getComponentGenerator() {
    return new ComponentGenerator(
        getFiler(),
        ProcessingEnvironmentModule_DaggerElementsFactory.proxyDaggerElements(
            processingEnvironmentModule),
        ProcessingEnvironmentModule_SourceVersionFactory.proxySourceVersion(
            processingEnvironmentModule),
        getComponentImplementationFactory());
  }

  private SourceFileGenerator<BindingGraph> getSourceFileGeneratorOfBindingGraph() {
    return SourceFileGeneratorsModule_GeneratorModule_GeneratorFactory.proxyGenerator(
        componentModule, getComponentGenerator(), compilerOptionsProvider.get());
  }

  private BindingDeclarationFormatter getBindingDeclarationFormatter() {
    return new BindingDeclarationFormatter(getMethodSignatureFormatter());
  }

  private BindingGraphConverter getBindingGraphConverter() {
    return new BindingGraphConverter(
        getBindingDeclarationFormatter(), compilerOptionsProvider.get());
  }

  private ComponentProcessingStep getComponentProcessingStep() {
    return new ComponentProcessingStep(
        ProcessingEnvironmentModule_MessagerFactory.proxyMessager(processingEnvironmentModule),
        getComponentValidator(),
        getComponentCreatorValidator(),
        getComponentDescriptorValidator(),
        getFactory2(),
        getBindingGraphFactory(),
        getSourceFileGeneratorOfBindingGraph(),
        getBindingGraphConverter(),
        validationPluginsProvider.get(),
        spiPluginsProvider.get(),
        compilerOptionsProvider.get());
  }

  private ComponentHjarProcessingStep getComponentHjarProcessingStep() {
    return new ComponentHjarProcessingStep(
        ProcessingEnvironmentModule_DaggerElementsFactory.proxyDaggerElements(
            processingEnvironmentModule),
        ProcessingEnvironmentModule_SourceVersionFactory.proxySourceVersion(
            processingEnvironmentModule),
        ProcessingEnvironmentModule_TypesFactory.proxyTypes(processingEnvironmentModule),
        getFiler(),
        ProcessingEnvironmentModule_MessagerFactory.proxyMessager(processingEnvironmentModule),
        getComponentValidator(),
        getFactory2());
  }

  private BindingMethodProcessingStep getBindingMethodProcessingStep() {
    return new BindingMethodProcessingStep(
        ProcessingEnvironmentModule_MessagerFactory.proxyMessager(processingEnvironmentModule),
        getAnyBindingMethodValidator());
  }

  private ImmutableList<BasicAnnotationProcessor.ProcessingStep>
      getImmutableListOfProcessingStep() {
    return ComponentProcessor_ProcessingStepsModule_ProcessingStepsFactory.proxyProcessingSteps(
        getMapKeyProcessingStep(),
        getInjectProcessingStep(),
        getMonitoringModuleProcessingStep(),
        getMultibindingAnnotationsProcessingStep(),
        getBindsInstanceProcessingStep(),
        getModuleProcessingStep(),
        getComponentProcessingStep(),
        getComponentHjarProcessingStep(),
        getBindingMethodProcessingStep(),
        compilerOptionsProvider.get());
  }

  @SuppressWarnings("unchecked")
  private void initialize(final Builder builder) {
    this.daggerElementsProvider =
        ProcessingEnvironmentModule_DaggerElementsFactory.create(
            builder.processingEnvironmentModule);
    this.typesProvider =
        ProcessingEnvironmentModule_TypesFactory.create(builder.processingEnvironmentModule);
    this.daggerTypesProvider = DaggerTypes_Factory.create(typesProvider, daggerElementsProvider);
    this.messagerProvider =
        ProcessingEnvironmentModule_MessagerFactory.create(builder.processingEnvironmentModule);
    this.dependencyRequestValidatorProvider =
        DependencyRequestValidator_Factory.create(MembersInjectionValidator_Factory.create());
    this.compilerOptionsProvider =
        SingleCheck.provider(
            ProcessingEnvironmentModule_CompilerOptionsFactory.create(
                builder.processingEnvironmentModule));
    this.injectValidatorProvider =
        InjectValidator_Factory.create(
            typesProvider,
            daggerElementsProvider,
            dependencyRequestValidatorProvider,
            compilerOptionsProvider);
    this.keyFactoryProvider =
        KeyFactory_Factory.create(daggerTypesProvider, daggerElementsProvider);
    this.dependencyRequestFactoryProvider =
        DependencyRequestFactory_Factory.create(keyFactoryProvider, daggerTypesProvider);
    this.bindingFactoryProvider =
        BindingFactory_Factory.create(
            daggerTypesProvider,
            daggerElementsProvider,
            keyFactoryProvider,
            dependencyRequestFactoryProvider);
    this.injectBindingRegistryImplProvider =
        DoubleCheck.provider(
            InjectBindingRegistryImpl_Factory.create(
                (Provider) daggerElementsProvider,
                daggerTypesProvider,
                messagerProvider,
                injectValidatorProvider,
                keyFactoryProvider,
                bindingFactoryProvider,
                compilerOptionsProvider));
    this.provisionModule = builder.provisionModule;
    this.processingEnvironmentModule = builder.processingEnvironmentModule;
    this.membersInjectionModule = builder.membersInjectionModule;
    this.providesMethodValidatorProvider =
        ProvidesMethodValidator_Factory.create(
            daggerElementsProvider, typesProvider, dependencyRequestValidatorProvider);
    this.producesMethodValidatorProvider =
        ProducesMethodValidator_Factory.create(
            daggerElementsProvider, typesProvider, dependencyRequestValidatorProvider);
    this.bindsMethodValidatorProvider =
        BindsMethodValidator_Factory.create(
            daggerElementsProvider, typesProvider, dependencyRequestValidatorProvider);
    this.multibindsMethodValidatorProvider =
        MultibindsMethodValidator_Factory.create(
            daggerElementsProvider, typesProvider, dependencyRequestValidatorProvider);
    this.bindsOptionalOfMethodValidatorProvider =
        BindsOptionalOfMethodValidator_Factory.create(
            daggerElementsProvider, typesProvider, dependencyRequestValidatorProvider);
    this.setOfBindingMethodValidatorProvider =
        SetFactory.<BindingMethodValidator>builder(5, 0)
            .addProvider((Provider) providesMethodValidatorProvider)
            .addProvider((Provider) producesMethodValidatorProvider)
            .addProvider((Provider) bindsMethodValidatorProvider)
            .addProvider((Provider) multibindsMethodValidatorProvider)
            .addProvider((Provider) bindsOptionalOfMethodValidatorProvider)
            .build();
    this.indexValidatorsProvider =
        BindingMethodValidatorsModule_IndexValidatorsFactory.create(
            setOfBindingMethodValidatorProvider);
    this.anyBindingMethodValidatorProvider =
        AnyBindingMethodValidator_Factory.create(indexValidatorsProvider);
    this.methodSignatureFormatterProvider = MethodSignatureFormatter_Factory.create(typesProvider);
    this.factoryProvider =
        MultibindingDeclaration_Factory_Factory.create(typesProvider, keyFactoryProvider);
    this.factoryProvider2 =
        DelegateDeclaration_Factory_Factory.create(
            typesProvider, keyFactoryProvider, dependencyRequestFactoryProvider);
    this.factoryProvider3 = SubcomponentDeclaration_Factory_Factory.create(keyFactoryProvider);
    this.factoryProvider4 = OptionalBindingDeclaration_Factory_Factory.create(keyFactoryProvider);
    this.factoryProvider5 =
        ModuleDescriptor_Factory_Factory.create(
            daggerElementsProvider,
            bindingFactoryProvider,
            factoryProvider,
            factoryProvider2,
            factoryProvider3,
            factoryProvider4);
    this.factoryProvider6 =
        ComponentDescriptor_Factory_Factory.create(
            daggerElementsProvider,
            daggerTypesProvider,
            dependencyRequestFactoryProvider,
            factoryProvider5,
            compilerOptionsProvider);
    this.bindingGraphFactoryProvider =
        BindingGraphFactory_Factory.create(
            daggerElementsProvider,
            (Provider) injectBindingRegistryImplProvider,
            keyFactoryProvider,
            bindingFactoryProvider,
            factoryProvider5,
            compilerOptionsProvider);
    this.bindingDeclarationFormatterProvider =
        BindingDeclarationFormatter_Factory.create(methodSignatureFormatterProvider);
    this.bindingGraphConverterProvider =
        BindingGraphConverter_Factory.create(
            bindingDeclarationFormatterProvider, compilerOptionsProvider);
    this.dependencyRequestFormatterProvider =
        DependencyRequestFormatter_Factory.create(daggerTypesProvider);
    this.dependencyCycleValidatorProvider =
        DependencyCycleValidator_Factory.create(dependencyRequestFormatterProvider);
    this.dependsOnProductionExecutorValidatorProvider =
        DependsOnProductionExecutorValidator_Factory.create(
            compilerOptionsProvider, keyFactoryProvider);
    this.duplicateBindingsValidatorProvider =
        DuplicateBindingsValidator_Factory.create(bindingDeclarationFormatterProvider);
    this.incompatiblyScopedBindingsValidatorProvider =
        IncompatiblyScopedBindingsValidator_Factory.create(
            methodSignatureFormatterProvider, compilerOptionsProvider);
    this.injectBindingValidatorProvider =
        InjectBindingValidator_Factory.create(injectValidatorProvider);
    this.mapMultibindingValidatorProvider =
        MapMultibindingValidator_Factory.create(
            bindingDeclarationFormatterProvider, keyFactoryProvider);
    this.missingBindingValidatorProvider =
        MissingBindingValidator_Factory.create(
            daggerTypesProvider, (Provider) injectBindingRegistryImplProvider);
    this.nullableBindingValidatorProvider =
        NullableBindingValidator_Factory.create(compilerOptionsProvider);
    this.subcomponentFactoryMethodValidatorProvider =
        SubcomponentFactoryMethodValidator_Factory.create(daggerTypesProvider);
    this.validationSetOfBindingGraphPluginProvider =
        SetFactory.<BindingGraphPlugin>builder(10, 0)
            .addProvider((Provider) dependencyCycleValidatorProvider)
            .addProvider((Provider) dependsOnProductionExecutorValidatorProvider)
            .addProvider((Provider) duplicateBindingsValidatorProvider)
            .addProvider((Provider) incompatiblyScopedBindingsValidatorProvider)
            .addProvider((Provider) injectBindingValidatorProvider)
            .addProvider((Provider) mapMultibindingValidatorProvider)
            .addProvider((Provider) missingBindingValidatorProvider)
            .addProvider((Provider) nullableBindingValidatorProvider)
            .addProvider((Provider) ProvisionDependencyOnProducerBindingValidator_Factory.create())
            .addProvider((Provider) subcomponentFactoryMethodValidatorProvider)
            .build();
    this.filerProvider =
        ProcessingEnvironmentModule_FilerFactory.create(
            builder.processingEnvironmentModule, compilerOptionsProvider);
    this.processingOptionsProvider =
        ProcessingEnvironmentModule_ProcessingOptionsFactory.create(
            builder.processingEnvironmentModule);
    this.diagnosticReporterFactoryProvider =
        DiagnosticReporterFactory_Factory.create(
            daggerTypesProvider, messagerProvider, dependencyRequestFormatterProvider);
    this.moduleValidationPluginsProvider =
        DoubleCheck.provider(
            BindingGraphValidationModule_ModuleValidationPluginsFactory.create(
                validationSetOfBindingGraphPluginProvider,
                filerProvider,
                typesProvider,
                (Provider) daggerElementsProvider,
                processingOptionsProvider,
                diagnosticReporterFactoryProvider,
                compilerOptionsProvider));
    this.testingPluginsProvider = InstanceFactory.create(builder.testingPlugins);
    this.spiPluginsProvider =
        DoubleCheck.provider(
            SpiModule_SpiPluginsFactory.create(
                testingPluginsProvider,
                filerProvider,
                typesProvider,
                (Provider) daggerElementsProvider,
                processingOptionsProvider,
                diagnosticReporterFactoryProvider));
    this.moduleValidatorProvider =
        DoubleCheck.provider(
            ModuleValidator_Factory.create(
                typesProvider,
                daggerElementsProvider,
                anyBindingMethodValidatorProvider,
                methodSignatureFormatterProvider,
                factoryProvider6,
                bindingGraphFactoryProvider,
                bindingGraphConverterProvider,
                moduleValidationPluginsProvider,
                spiPluginsProvider,
                compilerOptionsProvider));
    this.productionModule = builder.productionModule;
    this.componentModule = builder.componentModule;
    this.validationPluginsProvider =
        DoubleCheck.provider(
            BindingGraphValidationModule_ValidationPluginsFactory.create(
                validationSetOfBindingGraphPluginProvider,
                filerProvider,
                typesProvider,
                (Provider) daggerElementsProvider,
                processingOptionsProvider,
                diagnosticReporterFactoryProvider));
    this.daggerStatisticsProvider =
        DoubleCheck.provider(
            DaggerStatistics_Factory.create(SystemComponentsModule_TickerFactory.create()));
  }

  @Override
  public void inject(ComponentProcessor processor) {
    injectComponentProcessor(processor);
  }

  @CanIgnoreReturnValue
  private ComponentProcessor injectComponentProcessor(ComponentProcessor instance) {
    ComponentProcessor_MembersInjector.injectInjectBindingRegistry(
        instance, injectBindingRegistryImplProvider.get());
    ComponentProcessor_MembersInjector.injectFactoryGenerator(
        instance, getSourceFileGeneratorOfProvisionBinding());
    ComponentProcessor_MembersInjector.injectMembersInjectorGenerator(
        instance, getSourceFileGeneratorOfMembersInjectionBinding());
    ComponentProcessor_MembersInjector.injectProcessingSteps(
        instance, getImmutableListOfProcessingStep());
    ComponentProcessor_MembersInjector.injectSpiPlugins(instance, spiPluginsProvider.get());
    ComponentProcessor_MembersInjector.injectCompilerOptions(
        instance, compilerOptionsProvider.get());
    ComponentProcessor_MembersInjector.injectValidationPlugins(
        instance, validationPluginsProvider.get());
    ComponentProcessor_MembersInjector.injectDaggerStatistics(
        instance, daggerStatisticsProvider.get());
    return instance;
  }

  private static final class Builder implements ComponentProcessor.ProcessorComponent.Builder {
    private ProcessingEnvironmentModule processingEnvironmentModule;

    private SourceFileGeneratorsModule.ProvisionModule provisionModule;

    private SourceFileGeneratorsModule.MembersInjectionModule membersInjectionModule;

    private SourceFileGeneratorsModule.ProductionModule productionModule;

    private SourceFileGeneratorsModule.ComponentModule componentModule;

    private Optional<ImmutableSet<BindingGraphPlugin>> testingPlugins;

    @Override
    public ComponentProcessor.ProcessorComponent build() {
      if (processingEnvironmentModule == null) {
        throw new IllegalStateException(
            ProcessingEnvironmentModule.class.getCanonicalName() + " must be set");
      }
      if (provisionModule == null) {
        this.provisionModule = new SourceFileGeneratorsModule.ProvisionModule();
      }
      if (membersInjectionModule == null) {
        this.membersInjectionModule = new SourceFileGeneratorsModule.MembersInjectionModule();
      }
      if (productionModule == null) {
        this.productionModule = new SourceFileGeneratorsModule.ProductionModule();
      }
      if (componentModule == null) {
        this.componentModule = new SourceFileGeneratorsModule.ComponentModule();
      }
      if (testingPlugins == null) {
        throw new IllegalStateException(Optional.class.getCanonicalName() + " must be set");
      }
      return new DaggerComponentProcessor_ProcessorComponent(this);
    }

    @Override
    public Builder processingEnvironmentModule(ProcessingEnvironmentModule module) {
      this.processingEnvironmentModule = Preconditions.checkNotNull(module);
      return this;
    }

    @Override
    public Builder testingPlugins(Optional<ImmutableSet<BindingGraphPlugin>> testingPlugins) {
      this.testingPlugins = Preconditions.checkNotNull(testingPlugins);
      return this;
    }
  }
}
