package dagger.internal.codegen;

import com.google.common.collect.ImmutableSet;
import dagger.internal.Factory;
import dagger.internal.Preconditions;
import dagger.spi.BindingGraphPlugin;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import javax.annotation.processing.Filer;
import javax.inject.Provider;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

@Generated(
  value = "dagger.internal.codegen.ComponentProcessor",
  comments = "https://google.github.io/dagger"
)
public final class SpiModule_SpiPluginsFactory implements Factory<BindingGraphPlugins> {
  private final Provider<Optional<ImmutableSet<BindingGraphPlugin>>> testingPluginsProvider;

  private final Provider<Filer> filerProvider;

  private final Provider<Types> typesProvider;

  private final Provider<Elements> elementsProvider;

  private final Provider<Map<String, String>> processingOptionsProvider;

  private final Provider<DiagnosticReporterFactory> diagnosticReporterFactoryProvider;

  public SpiModule_SpiPluginsFactory(
      Provider<Optional<ImmutableSet<BindingGraphPlugin>>> testingPluginsProvider,
      Provider<Filer> filerProvider,
      Provider<Types> typesProvider,
      Provider<Elements> elementsProvider,
      Provider<Map<String, String>> processingOptionsProvider,
      Provider<DiagnosticReporterFactory> diagnosticReporterFactoryProvider) {
    this.testingPluginsProvider = testingPluginsProvider;
    this.filerProvider = filerProvider;
    this.typesProvider = typesProvider;
    this.elementsProvider = elementsProvider;
    this.processingOptionsProvider = processingOptionsProvider;
    this.diagnosticReporterFactoryProvider = diagnosticReporterFactoryProvider;
  }

  @Override
  public BindingGraphPlugins get() {
    return Preconditions.checkNotNull(
        SpiModule.spiPlugins(
            testingPluginsProvider.get(),
            filerProvider.get(),
            typesProvider.get(),
            elementsProvider.get(),
            processingOptionsProvider.get(),
            diagnosticReporterFactoryProvider.get()),
        "Cannot return null from a non-@Nullable @Provides method");
  }

  public static SpiModule_SpiPluginsFactory create(
      Provider<Optional<ImmutableSet<BindingGraphPlugin>>> testingPluginsProvider,
      Provider<Filer> filerProvider,
      Provider<Types> typesProvider,
      Provider<Elements> elementsProvider,
      Provider<Map<String, String>> processingOptionsProvider,
      Provider<DiagnosticReporterFactory> diagnosticReporterFactoryProvider) {
    return new SpiModule_SpiPluginsFactory(
        testingPluginsProvider,
        filerProvider,
        typesProvider,
        elementsProvider,
        processingOptionsProvider,
        diagnosticReporterFactoryProvider);
  }

  public static BindingGraphPlugins proxySpiPlugins(
      Optional<ImmutableSet<BindingGraphPlugin>> testingPlugins,
      Filer filer,
      Types types,
      Elements elements,
      Map<String, String> processingOptions,
      Object diagnosticReporterFactory) {
    return Preconditions.checkNotNull(
        SpiModule.spiPlugins(
            testingPlugins,
            filer,
            types,
            elements,
            processingOptions,
            (DiagnosticReporterFactory) diagnosticReporterFactory),
        "Cannot return null from a non-@Nullable @Provides method");
  }
}
