
package dagger.internal.codegen;

import com.google.common.base.Equivalence;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import dagger.model.BindingKind;
import dagger.model.DependencyRequest;
import dagger.model.Key;
import dagger.model.Scope;
import java.util.Optional;
import javax.annotation.Generated;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
 abstract class $$AutoValue_ProvisionBinding extends ProvisionBinding {

  private final ContributionType contributionType;
  private final Key key;
  private final Optional<Element> bindingElement;
  private final Optional<TypeElement> contributingModule;
  private final BindingKind kind;
  private final Optional<DeclaredType> nullableType;
  private final Optional<Equivalence.Wrapper<AnnotationMirror>> wrappedMapKeyAnnotation;
  private final ImmutableSet<DependencyRequest> provisionDependencies;
  private final ImmutableSortedSet<MembersInjectionBinding.InjectionSite> injectionSites;
  private final Optional<ProvisionBinding> unresolved;
  private final Optional<Scope> scope;

  $$AutoValue_ProvisionBinding(
      ContributionType contributionType,
      Key key,
      Optional<Element> bindingElement,
      Optional<TypeElement> contributingModule,
      BindingKind kind,
      Optional<DeclaredType> nullableType,
      Optional<Equivalence.Wrapper<AnnotationMirror>> wrappedMapKeyAnnotation,
      ImmutableSet<DependencyRequest> provisionDependencies,
      ImmutableSortedSet<MembersInjectionBinding.InjectionSite> injectionSites,
      Optional<ProvisionBinding> unresolved,
      Optional<Scope> scope) {
    if (contributionType == null) {
      throw new NullPointerException("Null contributionType");
    }
    this.contributionType = contributionType;
    if (key == null) {
      throw new NullPointerException("Null key");
    }
    this.key = key;
    if (bindingElement == null) {
      throw new NullPointerException("Null bindingElement");
    }
    this.bindingElement = bindingElement;
    if (contributingModule == null) {
      throw new NullPointerException("Null contributingModule");
    }
    this.contributingModule = contributingModule;
    if (kind == null) {
      throw new NullPointerException("Null kind");
    }
    this.kind = kind;
    if (nullableType == null) {
      throw new NullPointerException("Null nullableType");
    }
    this.nullableType = nullableType;
    if (wrappedMapKeyAnnotation == null) {
      throw new NullPointerException("Null wrappedMapKeyAnnotation");
    }
    this.wrappedMapKeyAnnotation = wrappedMapKeyAnnotation;
    if (provisionDependencies == null) {
      throw new NullPointerException("Null provisionDependencies");
    }
    this.provisionDependencies = provisionDependencies;
    if (injectionSites == null) {
      throw new NullPointerException("Null injectionSites");
    }
    this.injectionSites = injectionSites;
    if (unresolved == null) {
      throw new NullPointerException("Null unresolved");
    }
    this.unresolved = unresolved;
    if (scope == null) {
      throw new NullPointerException("Null scope");
    }
    this.scope = scope;
  }

  @Override
  public ContributionType contributionType() {
    return contributionType;
  }

  @Override
  Key key() {
    return key;
  }

  @Override
  Optional<Element> bindingElement() {
    return bindingElement;
  }

  @Override
  Optional<TypeElement> contributingModule() {
    return contributingModule;
  }

  @Override
  BindingKind kind() {
    return kind;
  }

  @Override
  Optional<DeclaredType> nullableType() {
    return nullableType;
  }

  @Override
  Optional<Equivalence.Wrapper<AnnotationMirror>> wrappedMapKeyAnnotation() {
    return wrappedMapKeyAnnotation;
  }

  @Override
  ImmutableSet<DependencyRequest> provisionDependencies() {
    return provisionDependencies;
  }

  @Override
  ImmutableSortedSet<MembersInjectionBinding.InjectionSite> injectionSites() {
    return injectionSites;
  }

  @Override
  Optional<ProvisionBinding> unresolved() {
    return unresolved;
  }

  @Override
  public Optional<Scope> scope() {
    return scope;
  }

  @Override
  public String toString() {
    return "ProvisionBinding{"
        + "contributionType=" + contributionType + ", "
        + "key=" + key + ", "
        + "bindingElement=" + bindingElement + ", "
        + "contributingModule=" + contributingModule + ", "
        + "kind=" + kind + ", "
        + "nullableType=" + nullableType + ", "
        + "wrappedMapKeyAnnotation=" + wrappedMapKeyAnnotation + ", "
        + "provisionDependencies=" + provisionDependencies + ", "
        + "injectionSites=" + injectionSites + ", "
        + "unresolved=" + unresolved + ", "
        + "scope=" + scope
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof ProvisionBinding) {
      ProvisionBinding that = (ProvisionBinding) o;
      return (this.contributionType.equals(that.contributionType()))
           && (this.key.equals(that.key()))
           && (this.bindingElement.equals(that.bindingElement()))
           && (this.contributingModule.equals(that.contributingModule()))
           && (this.kind.equals(that.kind()))
           && (this.nullableType.equals(that.nullableType()))
           && (this.wrappedMapKeyAnnotation.equals(that.wrappedMapKeyAnnotation()))
           && (this.provisionDependencies.equals(that.provisionDependencies()))
           && (this.injectionSites.equals(that.injectionSites()))
           && (this.unresolved.equals(that.unresolved()))
           && (this.scope.equals(that.scope()));
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h = 1;
    h *= 1000003;
    h ^= this.contributionType.hashCode();
    h *= 1000003;
    h ^= this.key.hashCode();
    h *= 1000003;
    h ^= this.bindingElement.hashCode();
    h *= 1000003;
    h ^= this.contributingModule.hashCode();
    h *= 1000003;
    h ^= this.kind.hashCode();
    h *= 1000003;
    h ^= this.nullableType.hashCode();
    h *= 1000003;
    h ^= this.wrappedMapKeyAnnotation.hashCode();
    h *= 1000003;
    h ^= this.provisionDependencies.hashCode();
    h *= 1000003;
    h ^= this.injectionSites.hashCode();
    h *= 1000003;
    h ^= this.unresolved.hashCode();
    h *= 1000003;
    h ^= this.scope.hashCode();
    return h;
  }

  @Override
  public ProvisionBinding.Builder toBuilder() {
    return new Builder(this);
  }

  static final class Builder extends ProvisionBinding.Builder {
    private ContributionType contributionType;
    private Key key;
    private Optional<Element> bindingElement = Optional.empty();
    private Optional<TypeElement> contributingModule = Optional.empty();
    private BindingKind kind;
    private Optional<DeclaredType> nullableType = Optional.empty();
    private Optional<Equivalence.Wrapper<AnnotationMirror>> wrappedMapKeyAnnotation = Optional.empty();
    private ImmutableSet<DependencyRequest> provisionDependencies;
    private ImmutableSortedSet<MembersInjectionBinding.InjectionSite> injectionSites;
    private Optional<ProvisionBinding> unresolved = Optional.empty();
    private Optional<Scope> scope = Optional.empty();
    Builder() {
    }
    Builder(ProvisionBinding source) {
      this.contributionType = source.contributionType();
      this.key = source.key();
      this.bindingElement = source.bindingElement();
      this.contributingModule = source.contributingModule();
      this.kind = source.kind();
      this.nullableType = source.nullableType();
      this.wrappedMapKeyAnnotation = source.wrappedMapKeyAnnotation();
      this.provisionDependencies = source.provisionDependencies();
      this.injectionSites = source.injectionSites();
      this.unresolved = source.unresolved();
      this.scope = source.scope();
    }
    @Override
    public ProvisionBinding.Builder contributionType(ContributionType contributionType) {
      this.contributionType = contributionType;
      return this;
    }
    @Override
    public ProvisionBinding.Builder key(Key key) {
      this.key = key;
      return this;
    }
    @Override
    public ProvisionBinding.Builder bindingElement(Element bindingElement) {
      this.bindingElement = Optional.of(bindingElement);
      return this;
    }
    @Override
    public ProvisionBinding.Builder contributingModule(TypeElement contributingModule) {
      this.contributingModule = Optional.of(contributingModule);
      return this;
    }
    @Override
    public ProvisionBinding.Builder kind(BindingKind kind) {
      this.kind = kind;
      return this;
    }
    @Override
    public ProvisionBinding.Builder nullableType(Optional<DeclaredType> nullableType) {
      this.nullableType = nullableType;
      return this;
    }
    @Override
    public ProvisionBinding.Builder wrappedMapKeyAnnotation(Optional<Equivalence.Wrapper<AnnotationMirror>> wrappedMapKeyAnnotation) {
      this.wrappedMapKeyAnnotation = wrappedMapKeyAnnotation;
      return this;
    }
    @Override
    public ProvisionBinding.Builder provisionDependencies(Iterable<DependencyRequest> provisionDependencies) {
      this.provisionDependencies = ImmutableSet.copyOf(provisionDependencies);
      return this;
    }
    @Override
    public ProvisionBinding.Builder injectionSites(ImmutableSortedSet<MembersInjectionBinding.InjectionSite> injectionSites) {
      this.injectionSites = injectionSites;
      return this;
    }
    @Override
    public ProvisionBinding.Builder unresolved(ProvisionBinding unresolved) {
      this.unresolved = Optional.of(unresolved);
      return this;
    }
    @Override
    public ProvisionBinding.Builder scope(Optional<Scope> scope) {
      this.scope = scope;
      return this;
    }
    @Override
    public ProvisionBinding build() {
      String missing = "";
      if (contributionType == null) {
        missing += " contributionType";
      }
      if (key == null) {
        missing += " key";
      }
      if (kind == null) {
        missing += " kind";
      }
      if (provisionDependencies == null) {
        missing += " provisionDependencies";
      }
      if (injectionSites == null) {
        missing += " injectionSites";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_ProvisionBinding(
          this.contributionType,
          this.key,
          this.bindingElement,
          this.contributingModule,
          this.kind,
          this.nullableType,
          this.wrappedMapKeyAnnotation,
          this.provisionDependencies,
          this.injectionSites,
          this.unresolved,
          this.scope);
    }
  }

}
