package dagger.internal.codegen;

import com.google.common.collect.ImmutableSet;
import dagger.internal.Factory;
import dagger.internal.Preconditions;
import dagger.spi.BindingGraphPlugin;
import java.util.Set;
import javax.annotation.Generated;
import javax.inject.Provider;

@Generated(
  value = "dagger.internal.codegen.ComponentProcessor",
  comments = "https://google.github.io/dagger"
)
public final class BindingGraphValidationModule_ModuleBindingGraphValidatorFactory
    implements Factory<BindingGraphValidator> {
  private final Provider<Set<BindingGraphPlugin>> validationPluginsProvider;

  private final Provider<ImmutableSet<BindingGraphPlugin>> externalPluginsProvider;

  private final Provider<DiagnosticReporterFactory> diagnosticReporterFactoryProvider;

  public BindingGraphValidationModule_ModuleBindingGraphValidatorFactory(
      Provider<Set<BindingGraphPlugin>> validationPluginsProvider,
      Provider<ImmutableSet<BindingGraphPlugin>> externalPluginsProvider,
      Provider<DiagnosticReporterFactory> diagnosticReporterFactoryProvider) {
    this.validationPluginsProvider = validationPluginsProvider;
    this.externalPluginsProvider = externalPluginsProvider;
    this.diagnosticReporterFactoryProvider = diagnosticReporterFactoryProvider;
  }

  @Override
  public BindingGraphValidator get() {
    return Preconditions.checkNotNull(
        BindingGraphValidationModule.moduleBindingGraphValidator(
            validationPluginsProvider.get(),
            externalPluginsProvider.get(),
            diagnosticReporterFactoryProvider.get()),
        "Cannot return null from a non-@Nullable @Provides method");
  }

  public static BindingGraphValidationModule_ModuleBindingGraphValidatorFactory create(
      Provider<Set<BindingGraphPlugin>> validationPluginsProvider,
      Provider<ImmutableSet<BindingGraphPlugin>> externalPluginsProvider,
      Provider<DiagnosticReporterFactory> diagnosticReporterFactoryProvider) {
    return new BindingGraphValidationModule_ModuleBindingGraphValidatorFactory(
        validationPluginsProvider, externalPluginsProvider, diagnosticReporterFactoryProvider);
  }

  public static BindingGraphValidator proxyModuleBindingGraphValidator(
      Set<BindingGraphPlugin> validationPlugins,
      ImmutableSet<BindingGraphPlugin> externalPlugins,
      Object diagnosticReporterFactory) {
    return Preconditions.checkNotNull(
        BindingGraphValidationModule.moduleBindingGraphValidator(
            validationPlugins,
            externalPlugins,
            (DiagnosticReporterFactory) diagnosticReporterFactory),
        "Cannot return null from a non-@Nullable @Provides method");
  }
}
